/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.utils.IdResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IdResolverTest
extends TestCase {
    static /* synthetic */ Class class$org$apache$xml$security$test$utils$IdResolverTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$utils$IdResolverTest == null ? (class$org$apache$xml$security$test$utils$IdResolverTest = IdResolverTest.class$("org.apache.xml.security.test.utils.IdResolverTest")) : class$org$apache$xml$security$test$utils$IdResolverTest);
    }

    public void testIdSoap() throws Exception {
        String string = "<env:Envelope xmlns:SOAP-SEC=\"http://schemas.xmlsoap.org/soap/security/2000-12\" xmlns:env=\"http://www.w3.org/2001/12/soap-envelope\" actor=\"some-uri\" mustUnderstand=\"1\">\r\n<env:Header><SOAP-SEC:Signature>xxxx</SOAP-SEC:Signature></env:Header>\r\n<env:Body SOAP-SEC:id=\"Body\">This is signed together with it's Body ancestor</env:Body>\r\n</env:Envelope>";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes()));
        Element element = IdResolver.getElementById((Document)document, (String)"Body");
        IdResolverTest.assertNotNull((Object)element);
        IdResolverTest.assertEquals((String)"Body", (String)element.getLocalName());
    }

    public void testIdWithOtherIdSoap() throws Exception {
        String string = "<env:Envelope xmlns:SOAP-SEC=\"http://schemas.xmlsoap.org/soap/security/2000-12\" xmlns:env=\"http://www.w3.org/2001/12/soap-envelope\" actor=\"some-uri\" mustUnderstand=\"1\">\r\n<env:Header><SOAP-SEC:Signature>xxxx</SOAP-SEC:Signature></env:Header>\r\n<a id=\"Body\"/><env:Body SOAP-SEC:id=\"Body\">This is signed together with it's Body ancestor</env:Body>\r\n</env:Envelope>";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes()));
        Element element = IdResolver.getElementById((Document)document, (String)"Body");
        IdResolverTest.assertNotNull((Object)element);
        IdResolverTest.assertEquals((String)"Body", (String)element.getLocalName());
    }

    public void testANoId() throws Exception {
        String string = "<env:Envelope xmlns:SOAP-SEC=\"http://schemas.xmlsoap.org/soap/security/2000-12\" xmlns:env=\"http://www.w3.org/2001/12/soap-envelope\" actor=\"some-uri\" mustUnderstand=\"1\">\r\n<env:Header><SOAP-SEC:Signature>xxxx</SOAP-SEC:Signature></env:Header>\r\n<a id=\"Body\"/></env:Envelope>";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes()));
        Element element = IdResolver.getElementById((Document)document, (String)"Body");
        IdResolverTest.assertNotNull((Object)element);
        IdResolverTest.assertEquals((String)"a", (String)element.getLocalName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

