/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.util.ArrayList;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class EncryptionSupport {
    public static void decrypt(Properties props) {
        StandardPBEStringEncryptor encryptor = EncryptionSupport.createEncryptor();
        for (Object k : new ArrayList<Object>(props.keySet())) {
            String key = (String)k;
            String value = props.getProperty(key);
            if (!PropertyValueEncryptionUtils.isEncryptedValue((String)value)) continue;
            value = PropertyValueEncryptionUtils.decrypt((String)value, (StringEncryptor)encryptor);
            props.setProperty(key, value);
        }
    }

    public static StandardPBEStringEncryptor createEncryptor() {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        config.setAlgorithm("PBEWithMD5AndDES");
        config.setPasswordEnvName("ACTIVEMQ_ENCRYPTION_PASSWORD");
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }
}

