/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.DatatypeConverter;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageIdScanListener;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.JdbcMemoryTransactionStore;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJDBCAdapter.class);
    public static final int MAX_ROWS = Short.MAX_VALUE;
    protected Statements statements;
    private boolean batchStatements = true;
    protected boolean batchStatments = true;
    protected boolean prioritizedMessages;
    protected ReadWriteLock cleanupExclusiveLock = new ReentrantReadWriteLock();
    protected int maxRows = Short.MAX_VALUE;
    char priorityIterator = '\u0000';

    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBytes(index, data);
    }

    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doCreateTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        this.cleanupExclusiveLock.writeLock().lock();
        try {
            boolean alreadyExists = false;
            ResultSet rs = null;
            try {
                rs = c.getConnection().getMetaData().getTables(null, null, this.statements.getFullMessageTableName(), new String[]{"TABLE"});
                alreadyExists = rs.next();
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                catch (Throwable throwable2) {
                    DefaultJDBCAdapter.close(rs);
                    throw throwable2;
                }
            }
            DefaultJDBCAdapter.close(rs);
            s = c.getConnection().createStatement();
            String[] createStatments = this.statements.getCreateSchemaStatements();
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    LOG.debug("Executing SQL: " + createStatments[i]);
                    s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    if (alreadyExists) {
                        LOG.debug("Could not create JDBC tables; The message table already existed. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                        continue;
                    }
                    LOG.warn("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                    JDBCPersistenceAdapter.log("Failure details: ", e);
                }
            }
            if (!c.getConnection().getAutoCommit()) {
                c.getConnection().commit();
            }
        }
        finally {
            this.cleanupExclusiveLock.writeLock().unlock();
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDropTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        this.cleanupExclusiveLock.writeLock().lock();
        try {
            s = c.getConnection().createStatement();
            String[] dropStatments = this.statements.getDropSchemaStatements();
            for (int i = 0; i < dropStatments.length; ++i) {
                try {
                    LOG.debug("Executing SQL: " + dropStatments[i]);
                    s.execute(dropStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    LOG.warn("Could not drop JDBC tables; they may not exist. Failure was: " + dropStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                    JDBCPersistenceAdapter.log("Failure details: ", e);
                }
            }
            if (!c.getConnection().getAutoCommit()) {
                c.getConnection().commit();
            }
        }
        finally {
            this.cleanupExclusiveLock.writeLock().unlock();
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetLastMessageStoreSequenceId(TransactionContext c) throws SQLException, IOException {
        long l;
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            long seq;
            s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInMsgsStatement());
            rs = s.executeQuery();
            long seq1 = 0L;
            if (rs.next()) {
                seq1 = rs.getLong(1);
            }
            rs.close();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInAcksStatement());
            rs = s.executeQuery();
            long seq2 = 0L;
            if (rs.next()) {
                seq2 = rs.getLong(1);
            }
            l = seq = Math.max(seq1, seq2);
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doGetMessageById(TransactionContext c, long storeSequenceId) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            this.cleanupExclusiveLock.readLock().lock();
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageByIdStatement());
                s.setLong(1, storeSequenceId);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
                this.cleanupExclusiveLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this.cleanupExclusiveLock.readLock().unlock();
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        this.cleanupExclusiveLock.readLock().unlock();
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddMessage(TransactionContext c, long sequence, MessageId messageID, ActiveMQDestination destination, byte[] data, long expiration, byte priority, XATransactionId xid) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        this.cleanupExclusiveLock.readLock().lock();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
                if (this.batchStatements) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, sequence);
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expiration);
            s.setLong(6, priority);
            this.setBinaryData(s, 7, data);
            if (xid != null) {
                byte[] xidVal = xid.getEncodedXidBytes();
                xidVal[0] = 43;
                String xidString = DatatypeConverter.printBase64Binary((byte[])xidVal);
                s.setString(8, xidString);
            } else {
                s.setString(8, null);
            }
            if (this.batchStatements) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            if (!this.batchStatements && s != null) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdateMessage(TransactionContext c, ActiveMQDestination destination, MessageId id, byte[] data) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getUpdateMessageStatement());
            this.setBinaryData(s, 1, data);
            s.setString(2, id.getProducerId().toString());
            s.setLong(3, id.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not update message: " + id + " in " + destination);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddMessageReference(TransactionContext c, long sequence, MessageId messageID, ActiveMQDestination destination, long expirationTime, String messageRef) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        this.cleanupExclusiveLock.readLock().lock();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
                if (this.batchStatements) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, messageID.getBrokerSequenceId());
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expirationTime);
            s.setString(6, messageRef);
            if (this.batchStatements) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            if (!this.batchStatements) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getStoreSequenceId(TransactionContext c, ActiveMQDestination destination, MessageId messageID) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            long[] lArray;
            s = null;
            rs = null;
            this.cleanupExclusiveLock.readLock().lock();
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageSequenceIdStatement());
                s.setString(1, messageID.getProducerId().toString());
                s.setLong(2, messageID.getProducerSequenceId());
                s.setString(3, destination.getQualifiedName());
                rs = s.executeQuery();
                if (rs.next()) break block3;
                lArray = new long[]{0L, 0L};
                this.cleanupExclusiveLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this.cleanupExclusiveLock.readLock().unlock();
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return lArray;
        }
        long[] lArray = new long[]{rs.getLong(1), rs.getLong(2)};
        this.cleanupExclusiveLock.readLock().unlock();
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doGetMessage(TransactionContext c, MessageId id) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            this.cleanupExclusiveLock.readLock().lock();
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
                s.setString(1, id.getProducerId().toString());
                s.setLong(2, id.getProducerSequenceId());
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
                this.cleanupExclusiveLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this.cleanupExclusiveLock.readLock().unlock();
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        this.cleanupExclusiveLock.readLock().unlock();
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGetMessageReference(TransactionContext c, long seq) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            String string;
            s = null;
            rs = null;
            this.cleanupExclusiveLock.readLock().lock();
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
                s.setLong(1, seq);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                string = null;
                this.cleanupExclusiveLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this.cleanupExclusiveLock.readLock().unlock();
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return string;
        }
        String string = rs.getString(1);
        this.cleanupExclusiveLock.readLock().unlock();
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemoveMessage(TransactionContext c, long seq, XATransactionId xid) throws SQLException, IOException {
        PreparedStatement s = c.getRemovedMessageStatement();
        this.cleanupExclusiveLock.readLock().lock();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(xid == null ? this.statements.getRemoveMessageStatement() : this.statements.getUpdateXidFlagStatement());
                if (this.batchStatements) {
                    c.setRemovedMessageStatement(s);
                }
            }
            if (xid == null) {
                s.setLong(1, seq);
            } else {
                byte[] xidVal = xid.getEncodedXidBytes();
                xidVal[0] = 45;
                String xidString = DatatypeConverter.printBase64Binary((byte[])xidVal);
                s.setString(1, xidString);
                s.setLong(2, seq);
            }
            if (this.batchStatements) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to remove message seq: " + seq);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            if (!this.batchStatements && s != null) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecover(TransactionContext c, ActiveMQDestination destination, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllMessagesStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                while (rs.next() && listener.recoverMessageReference(rs.getString(2))) {
                }
            } else {
                while (rs.next() && listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                }
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMessageIdScan(TransactionContext c, int limit, JDBCMessageIdScanListener listener) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllMessageIdsStatement());
            s.setMaxRows(limit);
            rs = s.executeQuery();
            LinkedList<MessageId> reverseOrderIds = new LinkedList<MessageId>();
            while (rs.next()) {
                reverseOrderIds.addFirst(new MessageId(rs.getString(2), rs.getLong(3)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("messageIdScan with limit (" + limit + "), resulted in: " + reverseOrderIds.size() + " ids");
            }
            for (MessageId id : reverseOrderIds) {
                listener.messageId(id);
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetLastAckWithPriority(TransactionContext c, ActiveMQDestination destination, XATransactionId xid, String clientId, String subscriptionName, long seq, long priority) throws SQLException, IOException {
        PreparedStatement s = c.getUpdateLastAckStatement();
        this.cleanupExclusiveLock.readLock().lock();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(xid == null ? this.statements.getUpdateDurableLastAckWithPriorityStatement() : this.statements.getUpdateDurableLastAckWithPriorityInTxStatement());
                if (this.batchStatements) {
                    c.setUpdateLastAckStatement(s);
                }
            }
            if (xid != null) {
                byte[] xidVal = this.encodeXid(xid, seq, priority);
                String xidString = DatatypeConverter.printBase64Binary((byte[])xidVal);
                s.setString(1, xidString);
            } else {
                s.setLong(1, seq);
            }
            s.setString(2, destination.getQualifiedName());
            s.setString(3, clientId);
            s.setString(4, subscriptionName);
            s.setLong(5, priority);
            if (this.batchStatements) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed update last ack with priority: " + priority + ", for sub: " + subscriptionName);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            if (!this.batchStatements) {
                DefaultJDBCAdapter.close(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetLastAck(TransactionContext c, ActiveMQDestination destination, XATransactionId xid, String clientId, String subscriptionName, long seq, long priority) throws SQLException, IOException {
        PreparedStatement s = c.getUpdateLastAckStatement();
        this.cleanupExclusiveLock.readLock().lock();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(xid == null ? this.statements.getUpdateDurableLastAckStatement() : this.statements.getUpdateDurableLastAckInTxStatement());
                if (this.batchStatements) {
                    c.setUpdateLastAckStatement(s);
                }
            }
            if (xid != null) {
                byte[] xidVal = this.encodeXid(xid, seq, priority);
                String xidString = DatatypeConverter.printBase64Binary((byte[])xidVal);
                s.setString(1, xidString);
            } else {
                s.setLong(1, seq);
            }
            s.setString(2, destination.getQualifiedName());
            s.setString(3, clientId);
            s.setString(4, subscriptionName);
            if (this.batchStatements) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new IOException("Could not update last ack seq : " + seq + ", for sub: " + subscriptionName);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            if (!this.batchStatements) {
                DefaultJDBCAdapter.close(s);
            }
        }
    }

    private byte[] encodeXid(XATransactionId xid, long seq, long priority) {
        byte[] xidVal = xid.getEncodedXidBytes();
        DataByteArrayOutputStream outputStream = xid.internalOutputStream();
        outputStream.position(1);
        outputStream.writeLong(seq);
        outputStream.writeByte((int)Long.valueOf(priority).byteValue());
        return xidVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClearLastAck(TransactionContext c, ActiveMQDestination destination, byte priority, String clientId, String subName) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getClearDurableLastAckInTxStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subName);
            s.setLong(4, priority);
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not remove prepared transaction state from message ack for: " + clientId + ":" + subName);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDurableSubMessagesStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                while (rs.next() && listener.recoverMessageReference(rs.getString(2))) {
                }
            } else {
                while (rs.next() && listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                }
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverNextMessages(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq, long priority, int maxReturned, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindDurableSubMessagesStatement());
            s.setMaxRows(Math.min(maxReturned * 2, this.maxRows));
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.setLong(4, seq);
            rs = s.executeQuery();
            int count = 0;
            if (this.statements.isUseExternalMessageReferences()) {
                while (rs.next() && count < maxReturned) {
                    if (!listener.recoverMessageReference(rs.getString(1))) continue;
                    ++count;
                }
            } else {
                while (rs.next() && count < maxReturned) {
                    if (!listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) continue;
                    ++count;
                }
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverNextMessagesWithPriority(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq, long priority, int maxReturned, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindDurableSubMessagesByPriorityStatement());
            s.setMaxRows(Math.min(maxReturned * 2, this.maxRows));
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.setLong(4, seq);
            s.setLong(5, priority);
            rs = s.executeQuery();
            int count = 0;
            if (this.statements.isUseExternalMessageReferences()) {
                while (rs.next() && count < maxReturned) {
                    if (!listener.recoverMessageReference(rs.getString(1))) continue;
                    ++count;
                }
            } else {
                while (rs.next() && count < maxReturned) {
                    if (!listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) continue;
                    ++count;
                }
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doGetDurableSubscriberMessageCount(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, boolean isPrioritizedMessages) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        int result = 0;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = isPrioritizedMessages ? c.getConnection().prepareStatement(this.statements.getDurableSubscriberMessageCountStatementWithPriority()) : c.getConnection().prepareStatement(this.statements.getDurableSubscriberMessageCountStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            rs = s.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetSubscriberEntry(TransactionContext c, SubscriptionInfo info, boolean retroactive, boolean isPrioritizedMessages) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            long lastMessageId = -1L;
            if (!retroactive) {
                s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInMsgsStatement());
                ResultSet rs = null;
                try {
                    rs = s.executeQuery();
                    if (rs.next()) {
                        lastMessageId = rs.getLong(1);
                    }
                }
                finally {
                    DefaultJDBCAdapter.close(rs);
                    DefaultJDBCAdapter.close(s);
                }
            }
            s = c.getConnection().prepareStatement(this.statements.getCreateDurableSubStatement());
            int maxPriority = 1;
            if (isPrioritizedMessages) {
                maxPriority = 10;
            }
            for (int priority = 0; priority < maxPriority; ++priority) {
                s.setString(1, info.getDestination().getQualifiedName());
                s.setString(2, info.getClientId());
                s.setString(3, info.getSubscriptionName());
                s.setString(4, info.getSelector());
                s.setLong(5, lastMessageId);
                s.setString(6, info.getSubscribedDestination().getQualifiedName());
                s.setLong(7, priority);
                if (s.executeUpdate() == 1) continue;
                throw new IOException("Could not create durable subscription for: " + info.getClientId());
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo doGetSubscriberEntry(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            SubscriptionInfo subscriptionInfo;
            s = null;
            rs = null;
            this.cleanupExclusiveLock.readLock().lock();
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindDurableSubStatement());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriptionName);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                subscriptionInfo = null;
                this.cleanupExclusiveLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this.cleanupExclusiveLock.readLock().unlock();
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return subscriptionInfo;
        }
        SubscriptionInfo subscription = new SubscriptionInfo();
        subscription.setDestination(destination);
        subscription.setClientId(clientId);
        subscription.setSubscriptionName(subscriptionName);
        subscription.setSelector(rs.getString(1));
        subscription.setSubscribedDestination(ActiveMQDestination.createDestination((String)rs.getString(2), (byte)1));
        SubscriptionInfo subscriptionInfo = subscription;
        this.cleanupExclusiveLock.readLock().unlock();
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo[] doGetAllSubscriptions(TransactionContext c, ActiveMQDestination destination) throws SQLException, IOException {
        SubscriptionInfo[] subscriptionInfoArray;
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDurableSubsStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            ArrayList<SubscriptionInfo> rc = new ArrayList<SubscriptionInfo>();
            while (rs.next()) {
                SubscriptionInfo subscription = new SubscriptionInfo();
                subscription.setDestination(destination);
                subscription.setSelector(rs.getString(1));
                subscription.setSubscriptionName(rs.getString(2));
                subscription.setClientId(rs.getString(3));
                subscription.setSubscribedDestination(ActiveMQDestination.createDestination((String)rs.getString(4), (byte)1));
                rc.add(subscription);
            }
            subscriptionInfoArray = rc.toArray(new SubscriptionInfo[rc.size()]);
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemoveAllMessages(TransactionContext c, ActiveMQDestination destinationName) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getRemoveAllMessagesStatement());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getRemoveAllSubscriptionsStatement());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getDeleteSubscriptionStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.executeUpdate();
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteOldMessages(TransactionContext c) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.writeLock().lock();
        try {
            LOG.debug("Executing SQL: " + this.statements.getDeleteOldMessagesStatementWithPriority());
            s = c.getConnection().prepareStatement(this.statements.getDeleteOldMessagesStatementWithPriority());
            char c2 = this.priorityIterator;
            this.priorityIterator = (char)(c2 + '\u0001');
            int priority = c2 % 10;
            s.setInt(1, priority);
            s.setInt(2, priority);
            int i = s.executeUpdate();
            LOG.debug("Deleted " + i + " old message(s) at priority: " + priority);
            this.cleanupExclusiveLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.writeLock().unlock();
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetLastAckedDurableSubscriberMessageId(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriberName) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        long result = -1L;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getLastAckedDurableSubscriberMessageStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriberName);
            rs = s.executeQuery();
            if (rs.next() && (result = rs.getLong(1)) == 0L && rs.wasNull()) {
                result = -1L;
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    protected static void close(PreparedStatement s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ActiveMQDestination> doGetDestinations(TransactionContext c) throws SQLException, IOException {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDestinationsStatement());
            rs = s.executeQuery();
            while (rs.next()) {
                rc.add(ActiveMQDestination.createDestination((String)rs.getString(1), (byte)1));
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return rc;
    }

    public boolean isBatchStatements() {
        return this.batchStatements;
    }

    public void setBatchStatements(boolean batchStatements) {
        this.batchStatements = batchStatements;
    }

    public boolean isBatchStatments() {
        return this.batchStatements;
    }

    public void setBatchStatments(boolean batchStatments) {
        LOG.warn("batchStatments is deprecated and will be removed in a future release.  Use batchStatements instead (Note the 'e' in Statement)");
        this.batchStatements = batchStatments;
        this.batchStatments = batchStatments;
    }

    @Override
    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.statements.setUseExternalMessageReferences(useExternalMessageReferences);
    }

    public Statements getStatements() {
        return this.statements;
    }

    @Override
    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecordDestination(TransactionContext c, ActiveMQDestination destination) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getCreateDurableSubStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, destination.getQualifiedName());
            s.setString(3, destination.getQualifiedName());
            s.setString(4, null);
            s.setLong(5, 0L);
            s.setString(6, destination.getQualifiedName());
            s.setLong(7, 11L);
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not create ack record for destination: " + destination);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverPreparedOps(TransactionContext c, JdbcMemoryTransactionStore jdbcMemoryTransactionStore) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindOpsPendingOutcomeStatement());
            rs = s.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                String encodedString = rs.getString(2);
                byte[] encodedXid = DatatypeConverter.parseBase64Binary((String)encodedString);
                if (encodedXid[0] == 43) {
                    jdbcMemoryTransactionStore.recoverAdd(id, this.getBinaryData(rs, 3));
                    continue;
                }
                jdbcMemoryTransactionStore.recoverAck(id, encodedXid, this.getBinaryData(rs, 3));
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            s = c.getConnection().prepareStatement(this.statements.getFindAcksPendingOutcomeStatement());
            rs = s.executeQuery();
            while (rs.next()) {
                String encodedString = rs.getString(1);
                byte[] encodedXid = DatatypeConverter.parseBase64Binary((String)encodedString);
                String destination = rs.getString(2);
                String subName = rs.getString(3);
                String subId = rs.getString(4);
                jdbcMemoryTransactionStore.recoverLastAck(encodedXid, ActiveMQDestination.createDestination((String)destination, (byte)2), subName, subId);
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        this.cleanupExclusiveLock.readLock().unlock();
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommitAddOp(TransactionContext c, long preparedSequence, long sequence) throws SQLException, IOException {
        PreparedStatement s = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getClearXidFlagStatement());
            s.setLong(1, sequence);
            s.setLong(2, preparedSequence);
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not remove prepared transaction state from message add for sequenceId: " + sequence);
            }
        }
        finally {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doGetMessageCount(TransactionContext c, ActiveMQDestination destination) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        int result = 0;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getDestinationMessageCountStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverNextMessages(TransactionContext c, ActiveMQDestination destination, long[] lastRecoveredEntries, long maxSeq, int maxReturned, boolean isPrioritizedMessages, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            int count;
            s = isPrioritizedMessages ? c.getConnection().prepareStatement(this.limitQuery(this.statements.getFindNextMessagesByPriorityStatement())) : c.getConnection().prepareStatement(this.limitQuery(this.statements.getFindNextMessagesStatement()));
            s.setMaxRows(Math.min(maxReturned, this.maxRows));
            s.setString(1, destination.getQualifiedName());
            s.setLong(2, maxSeq);
            int paramId = 3;
            if (isPrioritizedMessages) {
                for (int i = 9; i >= 0; --i) {
                    s.setLong(paramId++, lastRecoveredEntries[i]);
                }
            } else {
                s.setLong(paramId, lastRecoveredEntries[0]);
            }
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                for (count = 0; rs.next() && count < maxReturned; ++count) {
                    if (listener.recoverMessageReference(rs.getString(1))) {
                        continue;
                    }
                    LOG.debug("Stopped recover next messages");
                    break;
                }
            } else {
                while (rs.next() && count < maxReturned) {
                    if (listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                        ++count;
                        continue;
                    }
                    LOG.debug("Stopped recover next messages");
                    break;
                }
            }
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Exception e) {
            try {
                LOG.warn("Exception recovering next messages", (Throwable)e);
                this.cleanupExclusiveLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this.cleanupExclusiveLock.readLock().unlock();
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetLastProducerSequenceId(TransactionContext c, ProducerId id) throws SQLException, IOException {
        long l;
        PreparedStatement s = null;
        ResultSet rs = null;
        this.cleanupExclusiveLock.readLock().lock();
        try {
            s = c.getConnection().prepareStatement(this.statements.getLastProducerSequenceIdStatement());
            s.setString(1, id.toString());
            rs = s.executeQuery();
            long seq = -1L;
            if (rs.next()) {
                seq = rs.getLong(1);
            }
            l = seq;
            this.cleanupExclusiveLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.cleanupExclusiveLock.readLock().unlock();
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    public static void dumpTables(Connection c, String destinationName, String clientId, String subscriptionName) throws SQLException {
        DefaultJDBCAdapter.printQuery(c, "Select * from ACTIVEMQ_MSGS", System.out);
        DefaultJDBCAdapter.printQuery(c, "Select * from ACTIVEMQ_ACKS", System.out);
        PreparedStatement s = c.prepareStatement("SELECT M.ID, D.LAST_ACKED_ID FROM ACTIVEMQ_MSGS M, ACTIVEMQ_ACKS D WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=? AND M.CONTAINER=D.CONTAINER AND M.ID > D.LAST_ACKED_ID ORDER BY M.ID");
        s.setString(1, destinationName);
        s.setString(2, clientId);
        s.setString(3, subscriptionName);
        DefaultJDBCAdapter.printQuery(s, System.out);
    }

    public static void dumpTables(Connection c) throws SQLException {
        DefaultJDBCAdapter.printQuery(c, "SELECT COUNT(*) from ACTIVEMQ_MSGS", System.out);
    }

    public static void printQuery(Connection c, String query, PrintStream out) throws SQLException {
        DefaultJDBCAdapter.printQuery(c.prepareStatement(query), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printQuery(PreparedStatement s, PrintStream out) throws SQLException {
        ResultSet set = null;
        try {
            int i;
            set = s.executeQuery();
            ResultSetMetaData metaData = set.getMetaData();
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                if (i == 1) {
                    out.print("||");
                }
                out.print(metaData.getColumnName(i) + "||");
            }
            out.println();
            while (set.next()) {
                for (i = 1; i <= metaData.getColumnCount(); ++i) {
                    if (i == 1) {
                        out.print("|");
                    }
                    out.print(set.getString(i) + "|");
                }
                out.println();
            }
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public String limitQuery(String query) {
        return query;
    }
}

