/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet.hba;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activeio.xnet.hba.IPAddressPermission;

public class ExactIPv6AddressPermission
implements IPAddressPermission {
    private static final Pattern MASK_VALIDATOR = Pattern.compile("^(([a-fA-F0-9]{1,4}:){7})([a-fA-F0-9]{1,4})$");
    private final byte[] bytes;

    public static boolean canSupport(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        return matcher.matches();
    }

    public ExactIPv6AddressPermission(byte[] bytes) {
        this.bytes = bytes;
    }

    public ExactIPv6AddressPermission(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mask " + mask + " does not match pattern " + MASK_VALIDATOR.pattern());
        }
        this.bytes = new byte[16];
        int pos = 0;
        StringTokenizer tokenizer = new StringTokenizer(mask, ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int value = Integer.parseInt(token, 16);
            this.bytes[pos++] = (byte)((value & 0xFF00) >> 8);
            this.bytes[pos++] = (byte)value;
        }
    }

    public boolean implies(InetAddress address) {
        if (!(address instanceof Inet6Address)) {
            return false;
        }
        byte[] byteAddress = address.getAddress();
        for (int i = 0; i < 16; ++i) {
            if (byteAddress[i] == this.bytes[i]) continue;
            return false;
        }
        return true;
    }
}

