/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.util.ServiceHelper;

public final class AsyncProcessorConverterHelper {
    private AsyncProcessorConverterHelper() {
    }

    public static AsyncProcessor convert(Processor value) {
        if (value instanceof AsyncProcessor) {
            return (AsyncProcessor)value;
        }
        return new ProcessorToAsyncProcessorBridge(value);
    }

    private static final class ProcessorToAsyncProcessorBridge
    implements DelegateProcessor,
    AsyncProcessor,
    Navigate<Processor>,
    Service {
        protected Processor processor;

        private ProcessorToAsyncProcessorBridge(Processor processor) {
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean process(Exchange exchange, AsyncCallback callback) {
            if (this.processor == null) {
                callback.done(true);
                return true;
            }
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            finally {
                callback.done(true);
            }
            return true;
        }

        public String toString() {
            if (this.processor != null) {
                return this.processor.toString();
            }
            return "Processor is null";
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            this.processNext(exchange);
        }

        protected void processNext(Exchange exchange) throws Exception {
            if (this.processor != null) {
                this.processor.process(exchange);
            }
        }

        @Override
        public void start() throws Exception {
            ServiceHelper.startServices(this.processor);
        }

        @Override
        public void stop() throws Exception {
            ServiceHelper.stopServices(this.processor);
        }

        @Override
        public boolean hasNext() {
            return this.processor != null;
        }

        @Override
        public List<Processor> next() {
            if (!this.hasNext()) {
                return null;
            }
            ArrayList<Processor> answer = new ArrayList<Processor>(1);
            answer.add(this.processor);
            return answer;
        }

        @Override
        public Processor getProcessor() {
            return this.processor;
        }
    }
}

