/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.MessageSentCallback;

public class InOnlyMessageSentCallback
implements MessageSentCallback {
    private final Exchange exchange;

    public InOnlyMessageSentCallback(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void sent(Session session, Message message, Destination destination) {
        String id;
        if (this.exchange != null && (id = JmsMessageHelper.getJMSMessageID(message)) != null) {
            if (this.exchange.hasOut()) {
                this.exchange.getOut().setHeader("JMSMessageID", id);
            } else {
                this.exchange.getIn().setHeader("JMSMessageID", id);
            }
        }
    }
}

