/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Date;
import java.util.TimeZone;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class Time {
    private static final Primitive _TIME = new Primitive("%time", Lisp.PACKAGE_SYS, false){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject arg) {
            LispObject lispObject;
            Cons.setCount(0L);
            long realStart = System.currentTimeMillis();
            try {
                lispObject = arg.execute();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                long realElapsed = System.currentTimeMillis() - realStart;
                long count = Cons.getCount();
                Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
                out.freshLine();
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf((float)realElapsed / 1000.0f));
                sb.append(" seconds real time");
                sb.append(System.getProperty("line.separator"));
                sb.append(count);
                sb.append(" cons cell");
                if (count != 1L) {
                    sb.append('s');
                }
                sb.append(System.getProperty("line.separator"));
                out._writeString(sb.toString());
                out._finishOutput();
                throw throwable;
            }
            long realElapsed = System.currentTimeMillis() - realStart;
            long count = Cons.getCount();
            Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
            out.freshLine();
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf((float)realElapsed / 1000.0f));
            sb.append(" seconds real time");
            sb.append(System.getProperty("line.separator"));
            sb.append(count);
            sb.append(" cons cell");
            if (count != 1L) {
                sb.append('s');
            }
            sb.append(System.getProperty("line.separator"));
            out._writeString(sb.toString());
            out._finishOutput();
            return lispObject;
        }
    };
    private static final Primitive GET_INTERNAL_REAL_TIME = new Primitive("get-internal-real-time", ""){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis());
        }
    };
    private static final Primitive GET_INTERNAL_RUN_TIME = new Primitive("get-internal-run-time", ""){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis());
        }
    };
    private static final Primitive GET_UNIVERSAL_TIME = new Primitive("get-universal-time", ""){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis() / 1000L + 2208988800L);
        }
    };
    private static final Primitive DEFAULT_TIME_ZONE = new Primitive("default-time-zone", Lisp.PACKAGE_SYS, false){

        public LispObject execute() {
            TimeZone tz = TimeZone.getDefault();
            int rawOffset = tz.getRawOffset();
            boolean inDaylightTime = tz.inDaylightTime(new Date(System.currentTimeMillis()));
            if (inDaylightTime) {
                rawOffset += tz.getDSTSavings();
            }
            return LispThread.currentThread().setValues(Fixnum.getInstance(-rawOffset).divideBy(Fixnum.getInstance(3600000)), inDaylightTime ? Lisp.T : Lisp.NIL);
        }
    };
}

