/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef WebKitDOMHTMLElementUnstable_h
#define WebKitDOMHTMLElementUnstable_h

#ifdef WEBKIT_DOM_USE_UNSTABLE_API

#include <webkitdom/webkitdomdefines-unstable.h>

G_BEGIN_DECLS

/**
 * webkit_dom_html_element_insert_adjacent_element:
 * @self: A #WebKitDOMHTMLElement
 * @where: A #gchar
 * @element: A #WebKitDOMElement
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMElement
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMElement*
webkit_dom_html_element_insert_adjacent_element(WebKitDOMHTMLElement* self, const gchar* where, WebKitDOMElement* element, GError** error);

/**
 * webkit_dom_html_element_insert_adjacent_html:
 * @self: A #WebKitDOMHTMLElement
 * @where: A #gchar
 * @html: A #gchar
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_insert_adjacent_html(WebKitDOMHTMLElement* self, const gchar* where, const gchar* html, GError** error);

/**
 * webkit_dom_html_element_insert_adjacent_text:
 * @self: A #WebKitDOMHTMLElement
 * @where: A #gchar
 * @text: A #gchar
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_insert_adjacent_text(WebKitDOMHTMLElement* self, const gchar* where, const gchar* text, GError** error);

/**
 * webkit_dom_html_element_get_translate:
 * @self: A #WebKitDOMHTMLElement
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_html_element_get_translate(WebKitDOMHTMLElement* self);

/**
 * webkit_dom_html_element_set_translate:
 * @self: A #WebKitDOMHTMLElement
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_set_translate(WebKitDOMHTMLElement* self, gboolean value);

/**
 * webkit_dom_html_element_get_draggable:
 * @self: A #WebKitDOMHTMLElement
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_html_element_get_draggable(WebKitDOMHTMLElement* self);

/**
 * webkit_dom_html_element_set_draggable:
 * @self: A #WebKitDOMHTMLElement
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_set_draggable(WebKitDOMHTMLElement* self, gboolean value);

/**
 * webkit_dom_html_element_get_webkitdropzone:
 * @self: A #WebKitDOMHTMLElement
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_html_element_get_webkitdropzone(WebKitDOMHTMLElement* self);

/**
 * webkit_dom_html_element_set_webkitdropzone:
 * @self: A #WebKitDOMHTMLElement
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_set_webkitdropzone(WebKitDOMHTMLElement* self, const gchar* value);

/**
 * webkit_dom_html_element_get_hidden:
 * @self: A #WebKitDOMHTMLElement
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_html_element_get_hidden(WebKitDOMHTMLElement* self);

/**
 * webkit_dom_html_element_set_hidden:
 * @self: A #WebKitDOMHTMLElement
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_set_hidden(WebKitDOMHTMLElement* self, gboolean value);

/**
 * webkit_dom_html_element_get_spellcheck:
 * @self: A #WebKitDOMHTMLElement
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_html_element_get_spellcheck(WebKitDOMHTMLElement* self);

/**
 * webkit_dom_html_element_set_spellcheck:
 * @self: A #WebKitDOMHTMLElement
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_html_element_set_spellcheck(WebKitDOMHTMLElement* self, gboolean value);


G_END_DECLS

#endif /* WEBKIT_DOM_USE_UNSTABLE_API */
#endif /* WebKitDOMHTMLElementUnstable_h */
