/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    long cursor;
    long lastCursor;
    long window;
    boolean tracking;
    boolean cancelled;
    boolean grabbed;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int cursorOrientation = 0;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        Point point = this.display.map(this.parent, null, newX, newY);
        this.display.setCursorLocation(point);
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int[] state = new int[1];
        OS.gdk_window_get_pointer(this.window, actualX, actualY, state);
        return new Point(actualX[0], actualY[0]);
    }

    Point adjustResizeCursor() {
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        Point point = this.display.map(this.parent, null, newX, newY);
        this.display.setCursorLocation(point);
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int[] state = new int[1];
        OS.gdk_window_get_pointer(this.window, actualX, actualY, state);
        return new Point(actualX[0], actualY[0]);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.bounds.width != 0) {
                x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                width = rects[i].width * 100 / this.bounds.width;
            } else {
                width = 100;
            }
            if (this.bounds.height != 0) {
                y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                height = rects[i].height * 100 / this.bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
            ++i;
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects) {
        long window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            window = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        }
        if (window == 0L) {
            return;
        }
        long gc = OS.gdk_gc_new(window);
        if (gc == 0L) {
            return;
        }
        long colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white(colormap, color);
        OS.gdk_gc_set_foreground(gc, color);
        OS.gdk_gc_set_subwindow(gc, 1L);
        OS.gdk_gc_set_function(gc, 2L);
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            OS.gdk_draw_rectangle(window, gc, 0, rect.x, rect.y, rect.width, rect.height);
            ++i;
        }
        OS.g_object_unref(gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    boolean grab() {
        int result = OS.gdk_pointer_grab(this.window, false, 516, this.window, this.cursor, 0);
        return result == 0;
    }

    long gtk_button_release_event(long widget, long event) {
        return this.gtk_mouse(7, widget, event);
    }

    long gtk_key_press_event(long widget, long eventPtr) {
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove(keyEvent, eventPtr, (long)GdkEventKey.sizeof);
        int stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
        int xChange = 0;
        int yChange = 0;
        switch (keyEvent.keyval) {
            case 65307: {
                this.cancelled = true;
            }
            case 65293: {
                this.tracking = false;
                break;
            }
            case 65361: {
                xChange = -stepSize;
                break;
            }
            case 65363: {
                xChange = stepSize;
                break;
            }
            case 65362: {
                yChange = -stepSize;
                break;
            }
            case 65364: {
                yChange = stepSize;
            }
        }
        if (xChange != 0 || yChange != 0) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            event.x = this.oldX + xChange;
            event.y = this.oldY + yChange;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(xChange, yChange);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                Point cursorPos = this.adjustResizeCursor();
                this.oldX = cursorPos.x;
                this.oldY = cursorPos.y;
            } else {
                this.moveRectangles(xChange, yChange);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                Point cursorPos = this.adjustMoveCursor();
                this.oldX = cursorPos.x;
                this.oldY = cursorPos.y;
            }
        }
        return result;
    }

    long gtk_motion_notify_event(long widget, long eventPtr) {
        if (this.cursor != this.lastCursor) {
            this.ungrab();
            this.grabbed = this.grab();
            this.lastCursor = this.cursor;
        }
        return this.gtk_mouse(3, widget, eventPtr);
    }

    long gtk_mouse(int eventType, long widget, long eventPtr) {
        int[] newX = new int[1];
        int[] newY = new int[1];
        OS.gdk_window_get_pointer(this.window, newX, newY, null);
        if (this.oldX != newX[0] || this.oldY != newY[0]) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            if (this.parent == null) {
                event.x = newX[0];
                event.y = newY[0];
            } else {
                Point screenCoord = this.display.map(this.parent, null, newX[0], newY[0]);
                event.x = screenCoord.x;
                event.y = screenCoord.y;
            }
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(newX[0] - this.oldX, newY[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                Point cursorPos = this.adjustResizeCursor();
                newX[0] = cursorPos.x;
                newY[0] = cursorPos.y;
            } else {
                this.moveRectangles(newX[0] - this.oldX, newY[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
            }
            this.oldX = newX[0];
            this.oldY = newY[0];
        }
        this.tracking = eventType != 7;
        return 0L;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        int mask;
        boolean mouseDown;
        int hStyle;
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        this.window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            this.window = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        }
        if (this.window == 0L) {
            return false;
        }
        this.cancelled = false;
        this.tracking = true;
        this.update();
        this.drawRectangles(this.rectangles);
        int[] oldX = new int[1];
        int[] oldY = new int[1];
        int[] state = new int[1];
        OS.gdk_window_get_pointer(this.window, oldX, oldY, state);
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        boolean bl = mouseDown = (state[0] & (mask = 1792)) != 0;
        if (!mouseDown) {
            Point cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            oldX[0] = cursorPos.x;
            oldY[0] = cursorPos.y;
        }
        this.oldX = oldX[0];
        this.oldY = oldY[0];
        this.grabbed = this.grab();
        this.lastCursor = this.cursor;
        GdkEvent gdkEvent = new GdkEvent();
        while (this.tracking) {
            long eventPtr;
            if (this.parent != null && this.parent.isDisposed()) break;
            while ((eventPtr = OS.gdk_event_get()) == 0L) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            OS.memmove(gdkEvent, eventPtr, (long)GdkEvent.sizeof);
            long widget = OS.gtk_get_event_widget(eventPtr);
            switch (gdkEvent.type) {
                case 3: {
                    this.gtk_motion_notify_event(widget, eventPtr);
                    break;
                }
                case 7: {
                    this.gtk_button_release_event(widget, eventPtr);
                    break;
                }
                case 8: {
                    this.gtk_key_press_event(widget, eventPtr);
                    break;
                }
                case 9: {
                    this.gtk_key_release_event(widget, eventPtr);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    break;
                }
                case 2: {
                    this.update();
                    this.drawRectangles(this.rectangles);
                    OS.gtk_main_do_event(eventPtr);
                    this.drawRectangles(this.rectangles);
                    break;
                }
                default: {
                    OS.gtk_main_do_event(eventPtr);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if (!this.isDisposed()) {
            this.update();
            this.drawRectangles(this.rectangles);
        }
        this.ungrab();
        this.window = 0L;
        return !this.cancelled;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0L;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }

    void ungrab() {
        if (this.grabbed) {
            OS.gdk_pointer_ungrab(0);
        }
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }
}

