/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.util.IOUtils;

public class RawDataBlock
implements ListManagedBlock {
    private byte[] _data = new byte[512];
    private boolean _eof;

    public RawDataBlock(InputStream inputStream) throws IOException {
        int n = IOUtils.readFully(inputStream, this._data);
        if (n == -1) {
            this._eof = true;
        } else {
            if (n != 512) {
                String string = " byte".concat(String.valueOf(String.valueOf(n == 1 ? "" : "s")));
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Unable to read entire block; ").append(n).append(string).append(" read; expected ").append(512).append(" bytes"))));
            }
            this._eof = false;
        }
    }

    public boolean eof() throws IOException {
        return this._eof;
    }

    public byte[] getData() throws IOException {
        if (this.eof()) {
            throw new IOException("Cannot return empty data");
        }
        return this._data;
    }
}

