/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.BlockWritable;

public class PropertyBlock
extends BigBlock {
    private static final int _properties_per_block = 4;
    private Property[] _properties = new Property[4];

    private PropertyBlock(Property[] propertyArray, int n) {
        for (int i = 0; i < 4; ++i) {
            this._properties[i] = propertyArray[i + n];
        }
    }

    public static BlockWritable[] createPropertyBlockArray(List list) {
        int n = (list.size() + 4 - 1) / 4;
        Property[] propertyArray = new Property[n * 4];
        System.arraycopy(list.toArray(new Property[0]), 0, propertyArray, 0, list.size());
        for (int i = list.size(); i < propertyArray.length; ++i) {
            propertyArray[i] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
        }
        BlockWritable[] blockWritableArray = new BlockWritable[n];
        for (int i = 0; i < n; ++i) {
            blockWritableArray[i] = new PropertyBlock(propertyArray, i * 4);
        }
        return blockWritableArray;
    }

    void writeData(OutputStream outputStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            this._properties[i].writeData(outputStream);
        }
    }
}

