/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class DocumentOutputStream
extends OutputStream {
    private OutputStream stream;
    private int limit;
    private int written;

    DocumentOutputStream(OutputStream outputStream, int n) {
        this.stream = outputStream;
        this.limit = n;
        this.written = 0;
    }

    public void write(int n) throws IOException {
        this.limitCheck(1);
        this.stream.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.limitCheck(n2);
        this.stream.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
    }

    void writeFiller(int n, byte by) throws IOException {
        if (n > this.written) {
            byte[] byArray = new byte[n - this.written];
            Arrays.fill(byArray, by);
            this.stream.write(byArray);
        }
    }

    private void limitCheck(int n) throws IOException {
        if (this.written + n > this.limit) {
            throw new IOException("tried to write too much data");
        }
        this.written += n;
    }
}

