/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.HDFType;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.CharacterSprmUncompressor;
import org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.LittleEndian;

public class StyleSheet
implements HDFType {
    public static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    private static final ParagraphProperties NIL_PAP = new ParagraphProperties();
    private static final CharacterProperties NIL_CHP = new CharacterProperties();
    private int _stshiLength;
    private int _baseLength;
    private int _flags;
    private int _maxIndex;
    private int _maxFixedIndex;
    private int _stylenameVersion;
    private int[] _rgftc;
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] byArray, int n) {
        int n2;
        this._stshiLength = LittleEndian.getShort(byArray, n);
        int n3 = LittleEndian.getShort(byArray, n += 2);
        this._baseLength = LittleEndian.getShort(byArray, n += 2);
        this._flags = LittleEndian.getShort(byArray, n += 2);
        this._maxIndex = LittleEndian.getShort(byArray, n += 2);
        this._maxFixedIndex = LittleEndian.getShort(byArray, n += 2);
        this._stylenameVersion = LittleEndian.getShort(byArray, n += 2);
        this._rgftc = new int[3];
        this._rgftc[0] = LittleEndian.getShort(byArray, n += 2);
        this._rgftc[1] = LittleEndian.getShort(byArray, n += 2);
        this._rgftc[2] = LittleEndian.getShort(byArray, n += 2);
        n += 2;
        n = 2 + this._stshiLength;
        this._styleDescriptions = new StyleDescription[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            short s = LittleEndian.getShort(byArray, n);
            n += 2;
            if (s > 0) {
                StyleDescription styleDescription;
                this._styleDescriptions[n2] = styleDescription = new StyleDescription(byArray, this._baseLength, n, true);
            }
            n += s;
        }
        for (n2 = 0; n2 < this._styleDescriptions.length; ++n2) {
            if (this._styleDescriptions[n2] == null) continue;
            this.createPap(n2);
            this.createChp(n2);
        }
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[this._stshiLength + 2];
        LittleEndian.putShort(byArray, n, (short)this._stshiLength);
        LittleEndian.putShort(byArray, n += 2, (short)this._styleDescriptions.length);
        LittleEndian.putShort(byArray, n += 2, (short)this._baseLength);
        LittleEndian.putShort(byArray, n += 2, (short)this._flags);
        LittleEndian.putShort(byArray, n += 2, (short)this._maxIndex);
        LittleEndian.putShort(byArray, n += 2, (short)this._maxFixedIndex);
        LittleEndian.putShort(byArray, n += 2, (short)this._stylenameVersion);
        LittleEndian.putShort(byArray, n += 2, (short)this._rgftc[0]);
        LittleEndian.putShort(byArray, n += 2, (short)this._rgftc[1]);
        LittleEndian.putShort(byArray, n += 2, (short)this._rgftc[2]);
        hWPFOutputStream.write(byArray);
        byte[] byArray2 = new byte[2];
        for (int i = 0; i < this._styleDescriptions.length; ++i) {
            if (this._styleDescriptions[i] != null) {
                byte[] byArray3 = this._styleDescriptions[i].toByteArray();
                LittleEndian.putShort(byArray2, (short)byArray3.length);
                hWPFOutputStream.write(byArray2);
                hWPFOutputStream.write(byArray3);
                if (byArray3.length % 2 != 1) continue;
                hWPFOutputStream.write(0);
                continue;
            }
            byArray2[0] = 0;
            byArray2[1] = 0;
            hWPFOutputStream.write(byArray2);
        }
    }

    public boolean equals(Object object) {
        StyleSheet styleSheet = (StyleSheet)object;
        if (styleSheet._baseLength == this._baseLength && styleSheet._flags == this._flags && styleSheet._maxFixedIndex == this._maxFixedIndex && styleSheet._maxIndex == this._maxIndex && styleSheet._rgftc[0] == this._rgftc[0] && styleSheet._rgftc[1] == this._rgftc[1] && styleSheet._rgftc[2] == this._rgftc[2] && styleSheet._stshiLength == this._stshiLength && styleSheet._stylenameVersion == this._stylenameVersion && styleSheet._styleDescriptions.length == this._styleDescriptions.length) {
            for (int i = 0; i < this._styleDescriptions.length; ++i) {
                if (styleSheet._styleDescriptions[i] == this._styleDescriptions[i] || styleSheet._styleDescriptions[i].equals(this._styleDescriptions[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void createPap(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        ParagraphProperties paragraphProperties = styleDescription.getPAP();
        byte[] byArray = styleDescription.getPAPX();
        int n2 = styleDescription.getBaseStyle();
        if (paragraphProperties == null && byArray != null) {
            ParagraphProperties paragraphProperties2 = new ParagraphProperties();
            if (n2 != 4095 && (paragraphProperties2 = this._styleDescriptions[n2].getPAP()) == null) {
                this.createPap(n2);
                paragraphProperties2 = this._styleDescriptions[n2].getPAP();
            }
            paragraphProperties = ParagraphSprmUncompressor.uncompressPAP(paragraphProperties2, byArray, 2);
            styleDescription.setPAP(paragraphProperties);
        }
    }

    private void createChp(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        CharacterProperties characterProperties = styleDescription.getCHP();
        byte[] byArray = styleDescription.getCHPX();
        int n2 = styleDescription.getBaseStyle();
        if (characterProperties == null && byArray != null) {
            CharacterProperties characterProperties2 = new CharacterProperties();
            if (n2 != 4095 && (characterProperties2 = this._styleDescriptions[n2].getCHP()) == null) {
                this.createChp(n2);
                characterProperties2 = this._styleDescriptions[n2].getCHP();
            }
            characterProperties = CharacterSprmUncompressor.uncompressCHP(characterProperties2, byArray, 0);
            styleDescription.setCHP(characterProperties);
        }
    }

    public StyleDescription getStyleDescription(int n) {
        return this._styleDescriptions[n];
    }

    public CharacterProperties getCharacterStyle(int n) {
        if (n == 4095) {
            return NIL_CHP;
        }
        return this._styleDescriptions[n] != null ? this._styleDescriptions[n].getCHP() : null;
    }

    public ParagraphProperties getParagraphStyle(int n) {
        if (n == 4095) {
            return NIL_PAP;
        }
        return this._styleDescriptions[n] != null ? this._styleDescriptions[n].getPAP() : null;
    }
}

