/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSPageRuleImpl
implements CSSPageRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private String _ident = null;
    private String _pseudoPage = null;
    private CSSStyleDeclaration _style = null;

    public CSSPageRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String ident, String pseudoPage) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._ident = ident;
        this._pseudoPage = pseudoPage;
    }

    public short getType() {
        return 6;
    }

    public String getCssText() {
        String sel = this.getSelectorText();
        return "@page " + sel + (sel.length() > 0 ? " " : "") + this.getStyle().getCssText();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 6) {
                throw new DOMExceptionImpl(13, 9);
            }
            this._ident = ((CSSPageRuleImpl)r)._ident;
            this._pseudoPage = ((CSSPageRuleImpl)r)._pseudoPage;
            this._style = ((CSSPageRuleImpl)r)._style;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getSelectorText() {
        return String.valueOf(this._ident != null ? this._ident : "") + (this._pseudoPage != null ? ":" + this._pseudoPage : "");
    }

    public void setSelectorText(String selectorText) throws DOMException {
    }

    public CSSStyleDeclaration getStyle() {
        return this._style;
    }

    protected void setIdent(String ident) {
        this._ident = ident;
    }

    protected void setPseudoPage(String pseudoPage) {
        this._pseudoPage = pseudoPage;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this._style = style;
    }
}

