/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.misc;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import java.io.UnsupportedEncodingException;

public class Plain
implements SaslClient {
    private boolean completed = false;
    private byte[] pw;
    private String authorizationID;
    private String authenticationID;
    private static byte SEP = 0;

    public Plain(String string, String string2, byte[] byArray) throws SaslException {
        if (string2 == null || byArray == null) {
            throw new SaslException("PLAIN: authorization ID and password must be specified");
        }
        this.authorizationID = string;
        this.authenticationID = string2;
        this.pw = byArray;
    }

    private void clearPassword() {
        if (this.pw != null) {
            int n = 0;
            while (n < this.pw.length) {
                this.pw[n] = 0;
                ++n;
            }
            this.pw = null;
        }
    }

    public void dispose() throws SaslException {
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new SaslException("Already completed");
        }
        this.completed = true;
        try {
            byte[] byArray2 = this.authorizationID != null ? this.authorizationID.getBytes("UTF8") : null;
            byte[] byArray3 = this.authenticationID.getBytes("UTF8");
            byte[] byArray4 = new byte[this.pw.length + byArray3.length + 2 + (byArray2 == null ? 0 : byArray2.length)];
            int n = 0;
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                n = byArray2.length;
            }
            byArray4[n++] = SEP;
            System.arraycopy(byArray3, 0, byArray4, n, byArray3.length);
            n += byArray3.length;
            byArray4[n++] = SEP;
            System.arraycopy(this.pw, 0, byArray4, n, this.pw.length);
            this.clearPassword();
            return byArray4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("Cannot get UTF-8 encoding of ids", (Throwable)unsupportedEncodingException);
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public String getNegotiatedProperty(String string) throws SaslException {
        if (this.completed) {
            if (string.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new SaslException("Not completed");
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new SaslException("Not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new SaslException("Not completed");
    }
}

