/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.jdbc4.Jdbc4Connection;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    private static final Logger logger = new Logger();
    private static boolean logLevelSet = false;
    private Properties defaultProperties;
    private static final Object[][] knownProperties;
    public static final int MAJORVERSION = 8;
    public static final int MINORVERSION = 3;
    private static String[] protocols;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            String driverLogLevel;
            if (!logLevelSet && (driverLogLevel = this.defaultProperties.getProperty("loglevel")) != null) {
                try {
                    Driver.setLogLevel(Integer.parseInt(driverLogLevel));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return this.defaultProperties;
        }
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            logger.debug("Can't find a classloader for the Driver; not loading driver configuration");
            return merged;
        }
        logger.debug("Loading driver configuration via classloader " + cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            logger.debug("Loading driver configuration from: " + url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties"), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            props.setProperty(propName, info.getProperty(propName));
        }
        if ((props = this.parseURL(url, props)) == null) {
            logger.debug("Error in url: " + url);
            return null;
        }
        try {
            logger.debug("Connecting with URL: " + url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread").start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            logger.debug("Connection error:", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to."), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            logger.debug("Unexpected connection error:", ex2);
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        return new Jdbc4Connection(Driver.host(props), Driver.port(props), Driver.user(props), Driver.database(props), props, url);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        this.parseURL(url, copy);
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < knownProperties.length; ++i) {
            String name = (String)knownProperties[i][0];
            props[i] = new DriverPropertyInfo(name, copy.getProperty(name));
            props[i].required = (Boolean)knownProperties[i][1];
            props[i].description = (String)knownProperties[i][2];
            if (knownProperties[i].length <= 3) continue;
            props[i].choices = (String[])knownProperties[i][3];
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 8;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    public static String getVersion() {
        return "PostgreSQL 8.3 JDBC4 with SSL (build 607)";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        int state = -1;
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        int ipv6start = l_urlServer.indexOf("[");
        int ipv6end = l_urlServer.indexOf("]");
        String ipv6address = null;
        if (ipv6start != -1 && ipv6end > ipv6start) {
            ipv6address = l_urlServer.substring(ipv6start + 1, ipv6end);
            l_urlServer = l_urlServer.substring(0, ipv6start) + "ipv6host" + l_urlServer.substring(ipv6end + 1);
        }
        StringTokenizer st = new StringTokenizer(l_urlServer, ":/", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count <= 3) {
                if (count % 2 != 1 || !token.equals(":")) {
                    if (count % 2 != 0) return null;
                    boolean found = count == 0;
                    for (int tmp = 0; tmp < protocols.length; ++tmp) {
                        if (!token.equals(protocols[tmp]) || count != 2 || tmp <= 0) continue;
                        urlProps.setProperty("Protocol", token);
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                }
            } else if (count > 3) {
                if (count == 4 && token.equals("/")) {
                    state = 0;
                } else if (count == 4) {
                    urlProps.setProperty("PGDBNAME", token);
                    state = -2;
                } else if (count == 5 && state == 0 && token.equals("/")) {
                    state = 1;
                } else {
                    if (count == 5 && state == 0) {
                        return null;
                    }
                    if (count == 6 && state == 1) {
                        urlProps.setProperty("PGHOST", token);
                    } else if (count == 7 && token.equals(":")) {
                        state = 2;
                    } else if (count == 8 && state == 2) {
                        try {
                            Integer portNumber = Integer.decode(token);
                            urlProps.setProperty("PGPORT", portNumber.toString());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else if (!(count != 7 && count != 9 || state != 1 && state != 2 || !token.equals("/"))) {
                        state = -1;
                    } else if (state == -1) {
                        urlProps.setProperty("PGDBNAME", token);
                        state = -2;
                    }
                }
            }
            ++count;
        }
        if (count <= 1) {
            return null;
        }
        if (ipv6address != null) {
            urlProps.setProperty("PGHOST", ipv6address);
        }
        StringTokenizer qst = new StringTokenizer(l_urlArgs, "&");
        count = 0;
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.setProperty(token, "");
            } else {
                urlProps.setProperty(token.substring(0, l_pos), token.substring(l_pos + 1));
            }
            ++count;
        }
        return urlProps;
    }

    private static String host(Properties props) {
        return props.getProperty("PGHOST", "localhost");
    }

    private static int port(Properties props) {
        return Integer.parseInt(props.getProperty("PGPORT", "5432"));
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = props.getProperty("loginTimeout");
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                logger.debug("Couldn't parse loginTimeout value: " + timeout);
            }
        }
        return DriverManager.getLoginTimeout() * 1000;
    }

    public static SQLException notImplemented(Class callClass, String functionName) {
        return new PSQLException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(int logLevel) {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            logger.setLogLevel(logLevel);
            logLevelSet = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLogLevel() {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger.getLogLevel();
        }
    }

    public static void makeSSL(PGStream stream, Properties info, Logger logger) throws IOException, SQLException {
        MakeSSL.convert(stream, info, logger);
    }

    public static boolean sslEnabled() {
        boolean l_return = false;
        l_return = true;
        return l_return;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        knownProperties = new Object[][]{{"PGDBNAME", Boolean.TRUE, "Database name to connect to; may be specified directly in the JDBC URL."}, {"user", Boolean.TRUE, "Username to connect to the database as.", null}, {"PGHOST", Boolean.FALSE, "Hostname of the PostgreSQL server; may be specified directly in the JDBC URL."}, {"PGPORT", Boolean.FALSE, "Port number to connect to the PostgreSQL server on; may be specified directly in the JDBC URL."}, {"password", Boolean.FALSE, "Password to use when authenticating."}, {"protocolVersion", Boolean.FALSE, "Force use of a particular protocol version when connecting; if set, disables protocol version fallback."}, {"ssl", Boolean.FALSE, "Control use of SSL; any nonnull value causes SSL to be required."}, {"sslfactory", Boolean.FALSE, "Provide a SSLSocketFactory class when using SSL."}, {"sslfactoryarg", Boolean.FALSE, "Argument forwarded to constructor of SSLSocketFactory class."}, {"loglevel", Boolean.FALSE, "Control the driver's log verbosity: 0 is off, 1 is INFO, 2 is DEBUG.", new String[]{"0", "1", "2"}}, {"allowEncodingChanges", Boolean.FALSE, "Allow the user to change the client_encoding variable."}, {"logUnclosedConnections", Boolean.FALSE, "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source."}, {"prepareThreshold", Boolean.FALSE, "Default statement prepare threshold (numeric)."}, {"charSet", Boolean.FALSE, "When connecting to a pre-7.3 server, the database encoding to assume is in use."}, {"compatible", Boolean.FALSE, "Force compatibility of some features with an older version of the driver.", new String[]{"7.1", "7.2", "7.3", "7.4", "8.0", "8.1", "8.2"}}, {"loginTimeout", Boolean.FALSE, "The login timeout, in seconds; 0 means no timeout beyond the normal TCP connection timout."}, {"stringtype", Boolean.FALSE, "The type to bind String parameters as (usually 'varchar'; 'unspecified' allows implicit casting to other types)", new String[]{"varchar", "unspecified"}}};
        protocols = new String[]{"jdbc", "postgresql"};
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Interrupted while attempting to connect."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                }
                return this.result;
            }
        }
    }
}

