/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class NormalizeSpace
extends OXMLFunction {
    private int numParams;

    NormalizeSpace(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "normalize-space";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        int n;
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence2.appendItem(oXMLItem2);
            return oXMLSequence2;
        }
        String string = oXMLItem.getString();
        int n2 = string.length();
        for (n = 0; n < n2 && FNUtil.isWhitespace(string.charAt(n)); ++n) {
        }
        char[] cArray = new char[n2 - n];
        boolean bl = false;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (FNUtil.isWhitespace(c)) {
                bl = true;
                continue;
            }
            if (bl) {
                cArray[n3++] = 32;
                bl = false;
            }
            cArray[n3++] = c;
        }
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
        oXMLItem3.setString(OXMLSequenceType.TSTRING, new String(cArray, 0, n3));
        oXMLSequence3.appendItem(oXMLItem3);
        return oXMLSequence3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        OXMLSequence oXMLSequence = FNFunctionLibrary.getInstance().getFunction("string", 0).invoke(oXMLFunctionContext);
        return this.invoke(oXMLFunctionContext, oXMLSequence);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 0: {
                oXMLSequence = this.invoke(oXMLFunctionContext);
                break;
            }
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
            }
        }
        return oXMLSequence;
    }
}

