/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import oracle.xml.util.QxName;
import oracle.xml.util.XMLUtil;

public class QxNameHash {
    static final Hashtable hashMap = new Hashtable();
    static final ReferenceQueue refQueue = new ReferenceQueue();

    private QxNameHash() {
    }

    public static QxName create(String string, String string2) {
        QxName qxName = QxNameHash.get(string, string2);
        if (qxName == null) {
            qxName = QxNameHash.add(string, XMLUtil.getLocalName(string2), XMLUtil.getPrefix(string2), string2);
        }
        return qxName;
    }

    public static QxName create(String string, String string2, String string3, String string4) {
        QxName qxName = QxNameHash.get(string, string4);
        if (qxName == null) {
            qxName = QxNameHash.add(string, string2, string3, string4);
        }
        return qxName;
    }

    public static QxName create(String string, String string2, String string3) {
        if (string3 == null || string3.equals("")) {
            return QxNameHash.create(string, string2, string3, string2);
        }
        return QxNameHash.create(string, string2, string3, string3 + ":" + string2);
    }

    private static QxName get(String string, String string2) {
        Object var2_2 = null;
        WeakValue weakValue = (WeakValue)hashMap.get(string2);
        if (weakValue != null) {
            weakValue = weakValue.next;
        }
        while (weakValue != null) {
            QxName qxName = (QxName)weakValue.get();
            if (qxName != null && string.equals(qxName.getNamespaceURI())) {
                return qxName;
            }
            weakValue = weakValue.next;
        }
        return null;
    }

    private static synchronized QxName add(String string, String string2, String string3, String string4) {
        QxNameHash.freeNullReferences();
        WeakValue weakValue = (WeakValue)hashMap.get(string4);
        QxName qxName = new QxName(string, string2, string3, string4);
        WeakValue weakValue2 = new WeakValue(qxName, refQueue);
        if (weakValue == null) {
            WeakValue weakValue3 = new WeakValue(string4);
            weakValue3.next = weakValue2;
            weakValue2.prev = weakValue3;
            hashMap.put(string4, weakValue3);
        } else {
            weakValue2.next = weakValue.next;
            if (weakValue.next != null) {
                weakValue.next.prev = weakValue2;
            }
            weakValue.next = weakValue2;
            weakValue2.prev = weakValue;
        }
        return qxName;
    }

    private static void freeNullReferences() {
        WeakValue weakValue = (WeakValue)refQueue.poll();
        while (weakValue != null) {
            weakValue.prev.next = weakValue.next;
            if (weakValue.next != null) {
                weakValue.next.prev = weakValue.prev;
            } else if (weakValue.prev.prev == null) {
                String string = (String)weakValue.prev.get();
                hashMap.remove(string);
            }
            weakValue = (WeakValue)refQueue.poll();
        }
    }

    static class WeakValue
    extends WeakReference {
        WeakValue prev;
        WeakValue next;

        WeakValue(Object object) {
            super(object);
        }

        WeakValue(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
        }
    }
}

