/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.CacheManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class ImageCache {
    private static final Logger logger = Logger.getLogger(ImageCache.class.toString());
    private File tempFile = null;
    private long length = 0L;
    private boolean isCached = false;
    private CacheManager cacheManager = null;
    private boolean isScaled = false;
    private BufferedImage imageStore;
    private static boolean isCachingEnabled;
    private static boolean scaleImages;
    private static Method imageIOReadMethod;
    private static Method imageIOWriteMethod;

    public ImageCache(Library library) {
        this.cacheManager = library.getCacheManager();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.setImage(bufferedImage, this.isCached);
    }

    public void setImage(BufferedImage bufferedImage, boolean bl) {
        try {
            if (bl && this.isCached && this.imageStore == bufferedImage) {
                return;
            }
            if (this.imageStore != null && this.imageStore != bufferedImage) {
                this.imageStore.flush();
                this.imageStore = null;
            }
            this.imageStore = bufferedImage;
            if (bl) {
                this.tempFile = File.createTempFile("PDFImageStream" + this.getClass().hashCode(), ".tmp");
                this.cacheManager.addCachedFile(this.tempFile.getAbsolutePath());
                this.tempFile.deleteOnExit();
                if (imageIOWriteMethod != null) {
                    Object[] objectArray = new Object[]{bufferedImage, "png", this.tempFile};
                    try {
                        imageIOWriteMethod.invoke(null, objectArray);
                    }
                    catch (Throwable throwable) {
                        logger.fine("ImageCache: Java 1.4 Imaging subsystem write failure: " + throwable);
                    }
                } else {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile.getAbsolutePath(), false);
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                    jPEGImageEncoder.encode(bufferedImage);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                this.length = this.tempFile.length();
                this.isCached = true;
            } else {
                this.isCached = false;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error creating ImageCache temporary file.", iOException);
        }
    }

    public BufferedImage readImage() {
        if (this.imageStore != null) {
            return this.imageStore;
        }
        if (this.isCached) {
            BufferedImage bufferedImage = null;
            try {
                if (imageIOReadMethod != null) {
                    Object[] objectArray = new Object[]{this.tempFile};
                    try {
                        bufferedImage = (BufferedImage)imageIOReadMethod.invoke(null, objectArray);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.FINE, "ImageCache: Java 1.4 Imaging subsystem read failure.", throwable);
                    }
                } else {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(this.tempFile);
                        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)fileInputStream);
                        bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                        fileInputStream.close();
                    }
                    catch (ImageFormatException imageFormatException) {
                        logger.log(Level.FINE, "Error decoding ImageCache cached image.", imageFormatException);
                    }
                }
                this.length = this.tempFile.length();
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error creating ImageCache temporary file ", iOException);
            }
            this.imageStore = bufferedImage;
            return bufferedImage;
        }
        return null;
    }

    public void dispose(boolean bl, boolean bl2) {
        if (this.imageStore != null) {
            if (bl && isCachingEnabled && !this.isCached && !bl2) {
                this.setImage(this.imageStore, true);
            }
            if (!bl || this.isCached || bl2) {
                this.imageStore = null;
            }
        }
    }

    public void scaleImage(int n, int n2) {
        if (scaleImages) {
            this.setImage(ImageCache.scaleBufferedImage(this.readImage(), n, n2));
            this.isScaled = true;
        } else {
            this.isScaled = false;
        }
    }

    public void setIsScaled(boolean bl) {
        this.isScaled = bl;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isScaled() {
        return this.isScaled;
    }

    public boolean isCachedSomehow() {
        return this.isCached || this.imageStore != null;
    }

    public static BufferedImage scaleBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        double d = 1.0;
        if (!(n < 500 && n2 < 500 || n >= 1000 && n2 >= 1000)) {
            d = 0.8;
        } else if (!(n < 1000 && n2 < 1000 || n >= 1500 && n2 >= 1500)) {
            d = 0.7;
        } else if (!(n < 1500 && n2 < 1500 || n >= 2000 && n2 >= 2000)) {
            d = 0.6;
        } else if (!(n < 2000 && n2 < 2000 || n >= 2500 && n2 >= 2500)) {
            d = 0.5;
        } else if (!(n < 2500 && n2 < 2500 || n >= 3000 && n2 >= 3000)) {
            d = 0.4;
        } else if (n >= 3000 || n2 >= 3000) {
            d = 0.3;
        }
        if (d != 1.0) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(d, d);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
            bufferedImage.flush();
            bufferedImage = null;
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    static {
        imageIOReadMethod = null;
        imageIOWriteMethod = null;
        isCachingEnabled = Defs.sysPropertyBoolean("org.icepdf.core.imagecache.enabled", true);
        scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);
        if (Defs.sysPropertyBoolean("org.icepdf.core.imagecache.use14", true)) {
            try {
                Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                Class[] classArray = new Class[]{File.class};
                imageIOReadMethod = clazz.getMethod("read", classArray);
                Class[] classArray2 = new Class[]{RenderedImage.class, String.class, File.class};
                imageIOWriteMethod = clazz.getMethod("write", classArray2);
            }
            catch (Throwable throwable) {
                logger.fine("ImageCache: Java 1.4 Imaging subsystem not found.");
                imageIOReadMethod = null;
                imageIOWriteMethod = null;
            }
        }
    }
}

