/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.io.InputStream;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.security.EncryptionDictionary;
import org.icepdf.core.pobjects.security.Permissions;
import org.icepdf.core.pobjects.security.SecurityHandler;
import org.icepdf.core.pobjects.security.StandardEncryption;

public class StandardSecurityHandler
extends SecurityHandler {
    private StandardEncryption standardEnryption = null;
    private byte[] encryptionKey = null;
    private boolean initiated = false;
    private String password;

    public StandardSecurityHandler(EncryptionDictionary encryptionDictionary) {
        super(encryptionDictionary);
        this.handlerName = "Adobe Standard Security";
    }

    public boolean isAuthorized(String string) {
        boolean bl = this.standardEnryption.authenticateUserPassword(string);
        if (!bl) {
            bl = this.standardEnryption.authenticateOwnerPassword(string);
            if (bl) {
                this.password = this.standardEnryption.getUserPassword();
            }
        } else {
            this.password = string;
        }
        return bl;
    }

    public boolean isOwnerAuthorized(String string) {
        return this.standardEnryption.authenticateOwnerPassword(string);
    }

    public boolean isUserAuthorized(String string) {
        boolean bl = this.standardEnryption.authenticateUserPassword(string);
        if (bl) {
            this.password = string;
        }
        return bl;
    }

    public byte[] encrypt(Reference reference, byte[] byArray, byte[] byArray2) {
        return this.standardEnryption.generalEncryptionAlgorithm(reference, byArray, byArray2);
    }

    public byte[] decrypt(Reference reference, byte[] byArray, byte[] byArray2) {
        return this.encrypt(reference, byArray, byArray2);
    }

    public InputStream getEncryptionInputStream(Reference reference, byte[] byArray, InputStream inputStream) {
        return this.standardEnryption.generalEncryptionInputStream(reference, byArray, inputStream);
    }

    public byte[] getEncryptionKey() {
        if (!this.initiated) {
            this.init();
        }
        this.encryptionKey = this.standardEnryption.encryptionKeyAlgorithm(this.password, this.encryptionDictionary.getKeyLength());
        return this.encryptionKey;
    }

    public byte[] getDecryptionKey() {
        return this.getEncryptionKey();
    }

    public Permissions getPermissions() {
        if (!this.initiated) {
            this.init();
        }
        return this.permissions;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void init() {
        this.standardEnryption = new StandardEncryption(this.encryptionDictionary);
        this.permissions = new Permissions(this.encryptionDictionary);
        this.permissions.init();
        this.initiated = true;
    }

    public void dispose() {
        this.standardEnryption = null;
        this.encryptionKey = null;
        this.permissions = null;
        this.initiated = false;
    }
}

