/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.security.SecurityManager;

public class LiteralStringObject
implements StringObject {
    private StringBuffer stringData;
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    Reference reference;

    public LiteralStringObject(byte[] byArray) {
        this(new StringBuffer(byArray.length).append(new String(byArray)));
    }

    public LiteralStringObject(String string) {
        this.stringData = new StringBuffer(string);
    }

    public LiteralStringObject(StringBuffer stringBuffer) {
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.stringData = new StringBuffer(stringBuffer.length());
        this.stringData.append(stringBuffer.toString());
    }

    public int getUnsignedInt(int n, int n2) {
        if (n < 0 || this.stringData.length() < n + n2) {
            return 0;
        }
        if (n2 == 1) {
            return this.stringData.charAt(n);
        }
        if (n2 == 2) {
            return (this.stringData.charAt(n) & 0xFF) << 8 | this.stringData.charAt(n + 1) & 0xFF;
        }
        if (n2 == 4) {
            return (this.stringData.charAt(n) & 0xFF) << 24 | (this.stringData.charAt(n + 1) & 0xFF) << 16 | (this.stringData.charAt(n + 2) & 0xFF) << 8 | this.stringData.charAt(n + 3) & 0xFF;
        }
        return 0;
    }

    public String toString() {
        return this.stringData.toString();
    }

    public String getHexString() {
        return this.stringToHex(this.stringData).toString();
    }

    public StringBuffer getHexStringBuffer() {
        return this.stringToHex(this.stringData);
    }

    public StringBuffer getLiteralStringBuffer() {
        return this.stringData;
    }

    public String getLiteralString() {
        return this.stringData.toString();
    }

    public StringBuffer getLiteralStringBuffer(int n, FontFile fontFile) {
        if (n == 1) {
            int n2 = 1;
            int n3 = this.getLength();
            StringBuffer stringBuffer = new StringBuffer(n3);
            int n4 = 0;
            for (int i = 0; i < n3; i += n2) {
                int n5 = this.getUnsignedInt(i - n4, n4 + n2);
                if (n5 >= 0) {
                    stringBuffer.append((char)n5);
                    n4 = 0;
                    continue;
                }
                n4 += n2;
            }
            return stringBuffer;
        }
        if (n == 2) {
            int n6 = 2;
            int n7 = this.getLength();
            StringBuffer stringBuffer = new StringBuffer(n7);
            for (int i = 0; i < n7; i += n6) {
                int n8 = this.getUnsignedInt(i, n6);
                if (!fontFile.canDisplayEchar((char)n8)) continue;
                stringBuffer.append((char)n8);
            }
            return stringBuffer;
        }
        return null;
    }

    public int getLength() {
        return this.stringData.length();
    }

    private StringBuffer stringToHex(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length() * 2);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            stringBuffer2.append(hexChar[(c & 0xF0) >>> 4]);
            stringBuffer2.append(hexChar[c & 0xF]);
        }
        return stringBuffer2;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String getDecryptedLiteralString(SecurityManager securityManager) {
        if (securityManager != null && this.reference != null) {
            byte[] byArray = securityManager.getDecryptionKey();
            byte[] byArray2 = new byte[this.stringData.length()];
            int n = byArray2.length;
            for (int i = 0; i < n; ++i) {
                byArray2[i] = (byte)this.stringData.charAt(i);
            }
            byArray2 = securityManager.decrypt(this.reference, byArray, byArray2);
            return new String(byArray2);
        }
        return this.stringData.toString();
    }
}

