/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis;

import net.sourceforge.jffmpeg.codecs.audio.vorbis.OggReader;

public class CodeBook {
    private int dim;
    private int entries;
    private int[] lengthList;
    private int mapType;
    private long q_min;
    private long q_delta;
    private int q_quant;
    private long q_sequencep;
    private int quantvals;
    private long[] quantlist;
    private float[] valuelist;
    private int used_entries;
    private int dec_maxlength;
    private int dec_firsttablen;
    private int[] dec_firsttable;
    private int[] dec_codelengths;
    private int[] dec_index;
    private int[] codelist;
    private static final int VQ_FEXP = 10;
    private static final int VQ_FMAN = 21;
    private static final int VQ_FEXP_BIAS = 768;

    public CodeBook() {
        this.quantlist = new long[this.quantvals];
    }

    public int getDim() {
        return this.dim;
    }

    private final int decode_packed_entry_number(OggReader oggReader) {
        int n = this.dec_maxlength;
        long l = oggReader.showBits(this.dec_firsttablen);
        int n2 = this.dec_firsttable[(int)l];
        if (((long)n2 & 0x80000000L) == 0L) {
            oggReader.skipBits(this.dec_codelengths[n2 - 1]);
            return n2 - 1;
        }
        int n3 = n2 >> 15 & Short.MAX_VALUE;
        int n4 = this.used_entries - (n2 & Short.MAX_VALUE);
        l = oggReader.showBits(n);
        int n5 = CodeBook.bitreverse(l);
        while (n4 - n3 > 1) {
            int n6 = n4 - n3 >> 1;
            int n7 = this.codelist[n3 + n6] > n5 ? 1 : 0;
            n3 += n6 & n7 - 1;
            n4 -= n6 & -n7;
        }
        if (this.dec_codelengths[n3] <= n) {
            oggReader.skipBits(this.dec_codelengths[n3]);
            return n3;
        }
        throw new Error("Unrecognised Code");
    }

    public void decodev_set(float[] fArray, int n, OggReader oggReader, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.decode_packed_entry_number(oggReader);
            int n5 = n4 * this.dim;
            for (int i = 0; i < this.dim; ++i) {
                fArray[n + n3++] = this.valuelist[n5 + i];
            }
        }
    }

    public void decodev_add(float[] fArray, int n, OggReader oggReader, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.decode_packed_entry_number(oggReader);
            System.out.println("decodev_add " + n4);
            int n5 = n4 * this.dim;
            for (int i = 0; i < this.dim; ++i) {
                int n6 = n + n3++;
                fArray[n6] = fArray[n6] + this.valuelist[n5 + i];
            }
        }
    }

    public void decodevs_add(float[] fArray, int n, OggReader oggReader, int n2) {
        int n3;
        int n4 = n2 / this.dim;
        long[] lArray = new long[n4];
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            lArray[n3] = this.decode_packed_entry_number(oggReader);
            nArray[n3] = (int)(lArray[n3] * (long)this.dim);
        }
        n3 = 0;
        int n5 = 0;
        while (n5 < this.dim) {
            for (int i = 0; i < n4; ++i) {
                int n6 = n + i;
                fArray[n6] = fArray[n6] + this.valuelist[nArray[i] + n5];
            }
            ++n5;
            n3 += n4;
        }
    }

    public void decodevv_add(float[][] fArray, int n, int n2, OggReader oggReader, int n3) {
        int n4 = 0;
        int n5 = n / n2;
        while (n5 < (n + n3) / n2) {
            long l = this.decode_packed_entry_number(oggReader);
            int n6 = (int)l * this.dim;
            for (int i = 0; i < this.dim; ++i) {
                float[] fArray2 = fArray[n4++];
                int n7 = n5++;
                fArray2[n7] = fArray2[n7] + this.valuelist[n6 + i];
                if (n4 != n2) continue;
                n4 = 0;
            }
        }
    }

    public int decode(OggReader oggReader) {
        int n = this.decode_packed_entry_number(oggReader);
        return this.dec_index[n];
    }

    private static final int _ilog(long l) {
        int n = 0;
        while (l > 0L) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    public void unpack(OggReader oggReader) {
        int n;
        int n2;
        if (oggReader.getBits(24) != 5653314L) {
            throw new Error("Bad padding");
        }
        this.dim = (int)oggReader.getBits(16);
        this.entries = (int)oggReader.getBits(24);
        this.lengthList = new int[this.entries];
        if (oggReader.getBits(1) == 0L) {
            if (oggReader.getBits(1) == 1L) {
                for (n2 = 0; n2 < this.entries; ++n2) {
                    if (oggReader.getBits(1) != 0L) {
                        n = (int)oggReader.getBits(5);
                        this.lengthList[n2] = n + 1;
                        continue;
                    }
                    this.lengthList[n2] = 0;
                }
            } else {
                for (n2 = 0; n2 < this.entries; ++n2) {
                    n = (int)oggReader.getBits(5);
                    this.lengthList[n2] = n + 1;
                }
            }
        } else {
            n2 = (int)oggReader.getBits(5);
            n = 0;
            while (n < this.entries) {
                int n3 = (int)oggReader.getBits(CodeBook._ilog(this.entries - n));
                for (int i = 0; i < n3 && n < this.entries; ++i, ++n) {
                    this.lengthList[n] = n2;
                }
                ++n2;
            }
        }
        this.mapType = (int)oggReader.getBits(4);
        switch (this.mapType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.q_min = oggReader.getBits(32);
                this.q_delta = oggReader.getBits(32);
                this.q_quant = (int)(oggReader.getBits(4) + 1L);
                this.q_sequencep = oggReader.getBits(1);
                this.quantvals = 0;
                this.quantvals = this.mapType == 1 ? (int)Math.floor(Math.pow(this.entries, 1.0 / (double)this.dim)) : this.entries * this.dim;
                this.quantlist = new long[this.quantvals];
                for (n2 = 0; n2 < this.quantvals; ++n2) {
                    this.quantlist[n2] = oggReader.getBits(this.q_quant);
                }
                break;
            }
            default: {
                throw new Error("Illegal mapType");
            }
        }
    }

    private int[] _make_words(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int[] nArray2 = new int[33];
        int[] nArray3 = new int[n2 > 0 ? n2 : n];
        for (n5 = 0; n5 < n; ++n5) {
            n4 = nArray[n5];
            if (n4 > 0) {
                n3 = nArray2[n4];
                if (n4 < 32 && n3 >> n4 != 0) {
                    return null;
                }
                nArray3[n6++] = n3;
                int n7 = n4;
                while (n7 > 0) {
                    if ((nArray2[n7] & 1) != 0) {
                        if (n7 == 1) {
                            nArray2[1] = nArray2[1] + 1;
                            break;
                        }
                        nArray2[n7] = nArray2[n7 - 1] << 1;
                        break;
                    }
                    int n8 = n7--;
                    nArray2[n8] = nArray2[n8] + 1;
                }
                for (n7 = n4 + 1; n7 < 33 && nArray2[n7] >> 1 == n3; ++n7) {
                    n3 = nArray2[n7];
                    nArray2[n7] = nArray2[n7 - 1] << 1;
                }
                continue;
            }
            if (n2 != 0) continue;
            ++n6;
        }
        n5 = 0;
        n6 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < nArray[n5]; ++n3) {
                n4 <<= 1;
                n4 |= nArray3[n6] >> n3 & 1;
            }
            if (n2 != 0) {
                if (nArray[n5] == 0) continue;
                nArray3[n6++] = n4;
                continue;
            }
            nArray3[n6++] = n4;
        }
        return nArray3;
    }

    private static final int bitreverse(long l) {
        l = l >> 16 & 0xFFFFL | l << 16 & 0xFFFF0000L;
        l = l >> 8 & 0xFF00FFL | l << 8 & 0xFF00FF00L;
        l = l >> 4 & 0xF0F0F0FL | l << 4 & 0xF0F0F0F0L;
        l = l >> 2 & 0x33333333L | l << 2 & 0xCCCCCCCCL;
        l = l >> 1 & 0x55555555L | l << 1 & 0xAAAAAAAAL;
        return (int)l;
    }

    private static void qsort(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = i + 1; j < nArray.length; ++j) {
                long l = (long)nArray2[nArray[i]] & 0xFFFFFFFFL;
                long l2 = (long)nArray2[nArray[j]] & 0xFFFFFFFFL;
                if (l <= l2) continue;
                int n = nArray[i];
                nArray[i] = nArray[j];
                nArray[j] = n;
            }
        }
    }

    public void initDecode() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.entries; ++n2) {
            if (this.lengthList[n2] <= 0) continue;
            ++n4;
        }
        this.used_entries = n4;
        int[] nArray = this._make_words(this.lengthList, this.entries, this.used_entries);
        int[] nArray2 = new int[n4];
        if (nArray == null) {
            throw new Error("Error creating words");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = CodeBook.bitreverse(nArray[n2]);
            nArray2[n2] = n2;
        }
        CodeBook.qsort(nArray2, nArray);
        int[] nArray3 = new int[n4];
        this.codelist = new int[n4];
        n2 = 0;
        while (n2 < n4) {
            n = nArray2[n2];
            nArray3[n] = n2++;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.codelist[nArray3[n2]] = nArray[n2];
        }
        this.valuelist = this._book_unquantize(n4, nArray3);
        this.dec_index = new int[n4];
        n4 = 0;
        for (n2 = 0; n2 < this.entries; ++n2) {
            if (this.lengthList[n2] <= 0) continue;
            this.dec_index[nArray3[n4++]] = n2;
        }
        this.dec_codelengths = new int[n4];
        n4 = 0;
        for (n2 = 0; n2 < this.entries; ++n2) {
            if (this.lengthList[n2] <= 0) continue;
            this.dec_codelengths[nArray3[n4++]] = this.lengthList[n2];
        }
        this.dec_firsttablen = CodeBook._ilog(this.used_entries) - 4;
        if (this.dec_firsttablen < 5) {
            this.dec_firsttablen = 5;
        }
        if (this.dec_firsttablen > 8) {
            this.dec_firsttablen = 8;
        }
        int n5 = 1 << this.dec_firsttablen;
        this.dec_firsttable = new int[n5];
        this.dec_maxlength = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.dec_maxlength < this.dec_codelengths[n2]) {
                this.dec_maxlength = this.dec_codelengths[n2];
            }
            if (this.dec_codelengths[n2] > this.dec_firsttablen) continue;
            n = CodeBook.bitreverse(this.codelist[n2]);
            for (n3 = 0; n3 < 1 << this.dec_firsttablen - this.dec_codelengths[n2]; ++n3) {
                this.dec_firsttable[n | n3 << this.dec_codelengths[n2]] = n2 + 1;
            }
        }
        long l = 0xFFFFFFFEL << 31 - this.dec_firsttablen;
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            long l2 = (long)n2 << 32 - this.dec_firsttablen;
            if (this.dec_firsttable[CodeBook.bitreverse(l2)] != 0) continue;
            while (n6 + 1 < n4 && ((long)this.codelist[n6 + 1] & 0xFFFFFFFFL) <= l2) {
                ++n6;
            }
            while (n7 < n4 && l2 >= ((long)this.codelist[n7] & l & 0xFFFFFFFFL)) {
                ++n7;
            }
            int n8 = n6;
            int n9 = n4 - n7;
            if (n8 > Short.MAX_VALUE) {
                n8 = Short.MAX_VALUE;
            }
            if (n9 > Short.MAX_VALUE) {
                n9 = Short.MAX_VALUE;
            }
            this.dec_firsttable[CodeBook.bitreverse((long)l2)] = (int)(0x80000000L | (long)(n8 << 15) | (long)n9);
        }
    }

    private static float _float32_unpack(long l) {
        double d = l & 0x1FFFFFL;
        boolean bl = (l & 0x80000000L) != 0L;
        long l2 = l & 0x7FE00000L;
        l2 >>>= 21;
        if (bl) {
            d = -d;
        }
        return (float)(d * Math.pow(2.0, l2 - 20L - 768L));
    }

    private static final float fabs(float f) {
        return f > 0.0f ? f : -f;
    }

    private float[] _book_unquantize(int n, int[] nArray) {
        int n2 = 0;
        float[] fArray = null;
        if (this.mapType == 1 || this.mapType == 2) {
            float f = CodeBook._float32_unpack(this.q_min);
            float f2 = CodeBook._float32_unpack(this.q_delta);
            fArray = new float[n * this.dim];
            switch (this.mapType) {
                case 1: {
                    int n3 = (int)Math.floor(Math.pow(this.entries, 1.0 / (double)this.dim));
                    for (int i = 0; i < this.entries; ++i) {
                        if ((nArray == null || this.lengthList[i] == 0) && nArray != null) continue;
                        float f3 = 0.0f;
                        int n4 = 1;
                        for (int j = 0; j < this.dim; ++j) {
                            int n5 = i / n4 % n3;
                            float f4 = this.quantlist[n5];
                            f4 = CodeBook.fabs(f4) * f2 + f + f3;
                            if (this.q_sequencep != 0L) {
                                f3 = f4;
                            }
                            if (nArray != null) {
                                fArray[nArray[n2] * this.dim + j] = f4;
                            } else {
                                fArray[n2 * this.dim + j] = f4;
                            }
                            n4 *= n3;
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.entries; ++i) {
                        if ((nArray == null || this.lengthList[i] == 0) && nArray != null) continue;
                        float f5 = 0.0f;
                        for (int j = 0; j < this.dim; ++j) {
                            float f6 = this.quantlist[i * this.dim + j];
                            f6 = CodeBook.fabs(f6) * f2 + f + f5;
                            if (this.q_sequencep != 0L) {
                                f5 = f6;
                            }
                            if (nArray != null) {
                                fArray[nArray[n2] * this.dim + j] = f6;
                                continue;
                            }
                            fArray[n2 * this.dim + j] = f6;
                        }
                        ++n2;
                    }
                    break;
                }
            }
        }
        return fArray;
    }
}

