/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3;

import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.Granule;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.data.Table;

public class SoundOutput {
    private static final int[] mdct_win;
    public static final int C1_18;
    public static final int C2_18;
    public static final int C3_18;
    public static final int C4_18;
    public static final int C5_18;
    public static final int C6_18;
    public static final int C7_18;
    public static final int C8_18;
    public static final int[] icos36;
    public static final int[] icos72;
    int[] imdct36TmpBuffer = new int[18];
    public static final int C1;
    public static final int C3;
    public static final int C5;
    public static final int C7;
    public static final int C9;
    public static final int C11;
    int[] computerImdctTmpBuffer = new int[36];
    int[] computerImdctTmpBuffer2 = new int[12];
    int[] computerImdctTmpIn = new int[6];
    public static final int COS0_0;
    public static final int COS0_1;
    public static final int COS0_2;
    public static final int COS0_3;
    public static final int COS0_4;
    public static final int COS0_5;
    public static final int COS0_6;
    public static final int COS0_7;
    public static final int COS0_8;
    public static final int COS0_9;
    public static final int COS0_10;
    public static final int COS0_11;
    public static final int COS0_12;
    public static final int COS0_13;
    public static final int COS0_14;
    public static final int COS0_15;
    public static final int COS1_0;
    public static final int COS1_1;
    public static final int COS1_2;
    public static final int COS1_3;
    public static final int COS1_4;
    public static final int COS1_5;
    public static final int COS1_6;
    public static final int COS1_7;
    public static final int COS2_0;
    public static final int COS2_1;
    public static final int COS2_2;
    public static final int COS2_3;
    public static final int COS3_0;
    public static final int COS3_1;
    public static final int COS4_0;
    private int[] synth_buf_offset = new int[2];
    private int[][] synth_buf = new int[2][1024];
    private int[] synth_filterTmpBuffer = new int[32];
    private static final int[] window;
    private static final int FRAC_BITS = 23;
    private static final int WFRAC_BITS = 16;
    public static final int OUT_SHIFT = 24;

    private void imdct36(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        for (n7 = 17 + n; n7 >= 1 + n; --n7) {
            int n8 = n7;
            nArray2[n8] = nArray2[n8] + nArray2[n7 - 1];
        }
        for (n7 = 17 + n; n7 >= 3 + n; n7 -= 2) {
            int n9 = n7;
            nArray2[n9] = nArray2[n9] + nArray2[n7 - 2];
        }
        for (n6 = 0; n6 < 2; ++n6) {
            int n10 = n6 + n;
            long l = SoundOutput.MUL64(nArray2[n10 + 6], C3_18);
            long l2 = SoundOutput.MUL64(nArray2[n10 + 12], C6_18);
            this.imdct36TmpBuffer[n6 + 0] = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[n10 + 2], C1_18) + l + SoundOutput.MUL64(nArray2[n10 + 10], C5_18) + SoundOutput.MUL64(nArray2[n10 + 14], C7_18));
            this.imdct36TmpBuffer[n6 + 2] = nArray2[n10 + 0] + SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[n10 + 4], C2_18) + SoundOutput.MUL64(nArray2[n10 + 8], C4_18) + l2 + SoundOutput.MUL64(nArray2[n10 + 16], C8_18));
            this.imdct36TmpBuffer[n6 + 4] = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[n10 + 2] - nArray2[n10 + 10] - nArray2[n10 + 14], C3_18));
            this.imdct36TmpBuffer[n6 + 6] = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[n10 + 4] - nArray2[n10 + 8] - nArray2[n10 + 16], C6_18)) - nArray2[n10 + 12] + nArray2[n10 + 0];
            this.imdct36TmpBuffer[n6 + 8] = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[n10 + 2], C5_18) - l - SoundOutput.MUL64(nArray2[n10 + 10], C7_18) + SoundOutput.MUL64(nArray2[n10 + 14], C1_18));
            this.imdct36TmpBuffer[n6 + 10] = nArray2[n10 + 0] + SoundOutput.FRAC_RND(SoundOutput.MUL64(-nArray2[n10 + 4], C8_18) - SoundOutput.MUL64(nArray2[n10 + 8], C2_18) + l2 + SoundOutput.MUL64(nArray2[n10 + 16], C4_18));
            this.imdct36TmpBuffer[n6 + 12] = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[n10 + 2], C7_18) - l + SoundOutput.MUL64(nArray2[n10 + 10], C1_18) - SoundOutput.MUL64(nArray2[n10 + 14], C5_18));
            this.imdct36TmpBuffer[n6 + 14] = nArray2[n10 + 0] + SoundOutput.FRAC_RND(SoundOutput.MUL64(-nArray2[n10 + 4], C4_18) + SoundOutput.MUL64(nArray2[n10 + 8], C8_18) + l2 - SoundOutput.MUL64(nArray2[n10 + 16], C2_18));
            this.imdct36TmpBuffer[n6 + 16] = nArray2[n10 + 0] - nArray2[n10 + 4] + nArray2[n10 + 8] - nArray2[n10 + 12] + nArray2[n10 + 16];
        }
        n7 = 0;
        for (n6 = 0; n6 < 4; ++n6) {
            n5 = this.imdct36TmpBuffer[n7];
            n4 = this.imdct36TmpBuffer[n7 + 2];
            n3 = n4 + n5;
            int n11 = n4 - n5;
            int n12 = this.imdct36TmpBuffer[n7 + 1];
            int n13 = this.imdct36TmpBuffer[n7 + 3];
            n2 = SoundOutput.MULL(n13 + n12, icos36[n6]);
            int n14 = SoundOutput.MULL(n13 - n12, icos36[8 - n6]);
            n5 = SoundOutput.MULL(n3 + n2, icos72[17 - n6]);
            n4 = SoundOutput.MULL(n3 - n2, icos72[8 - n6]);
            nArray[27 + n6] = n5;
            nArray[26 - n6] = n5;
            nArray[9 + n6] = -n4;
            nArray[8 - n6] = n4;
            n5 = SoundOutput.MULL(n11 + n14, icos72[9 + n6]);
            n4 = SoundOutput.MULL(n11 - n14, icos72[n6]);
            nArray[27 + (8 - n6)] = n5;
            nArray[18 + n6] = n5;
            nArray[9 + (8 - n6)] = -n4;
            nArray[n6] = n4;
            n7 += 4;
        }
        n3 = this.imdct36TmpBuffer[16];
        n2 = SoundOutput.MULL(this.imdct36TmpBuffer[17], icos36[4]);
        n5 = SoundOutput.MULL(n3 + n2, icos72[13]);
        n4 = SoundOutput.MULL(n3 - n2, icos72[4]);
        nArray[31] = n5;
        nArray[22] = n5;
        nArray[13] = -n4;
        nArray[4] = n4;
    }

    private void imdct12(int[] nArray, int[] nArray2) {
        int n;
        long l = SoundOutput.MUL64(nArray2[1], C3);
        long l2 = SoundOutput.MUL64(nArray2[1], C9);
        long l3 = SoundOutput.MUL64(nArray2[4], C3);
        long l4 = SoundOutput.MUL64(nArray2[4], C9);
        nArray[0] = n = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[0], C7) - l - SoundOutput.MUL64(nArray2[2], C11) + SoundOutput.MUL64(nArray2[3], C1) - l4 - SoundOutput.MUL64(nArray2[5], C5));
        nArray[5] = -n;
        nArray[1] = n = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[0] - nArray2[3], C9) - l + SoundOutput.MUL64(nArray2[2] + nArray2[5], C3) - l4);
        nArray[4] = -n;
        nArray[2] = n = SoundOutput.FRAC_RND(SoundOutput.MUL64(nArray2[0], C11) - l2 + SoundOutput.MUL64(nArray2[2], C7) - SoundOutput.MUL64(nArray2[3], C5) + l3 - SoundOutput.MUL64(nArray2[5], C1));
        nArray[3] = -n;
        nArray[6] = n = SoundOutput.FRAC_RND(SoundOutput.MUL64(-nArray2[0], C5) + l2 + SoundOutput.MUL64(nArray2[2], C1) + SoundOutput.MUL64(nArray2[3], C11) - l3 - SoundOutput.MUL64(nArray2[5], C7));
        nArray[11] = n;
        nArray[7] = n = SoundOutput.FRAC_RND(SoundOutput.MUL64(-nArray2[0] + nArray2[3], C3) - l2 + SoundOutput.MUL64(nArray2[2] + nArray2[5], C9) + l3);
        nArray[10] = n;
        nArray[8] = n = SoundOutput.FRAC_RND(-SoundOutput.MUL64(nArray2[0], C1) - l - SoundOutput.MUL64(nArray2[2], C5) - SoundOutput.MUL64(nArray2[3], C7) - l4 - SoundOutput.MUL64(nArray2[5], C11));
        nArray[9] = n;
    }

    public void computeImdct(Granule granule, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray3 = granule.getSbHybrid();
        int n5 = 576;
        int n6 = 36;
        while (n5 >= n6 && (nArray3[n5 -= 6] | nArray3[n5 + 1] | nArray3[n5 + 2] | nArray3[n5 + 3] | nArray3[n5 + 4] | nArray3[n5 + 5]) == 0) {
        }
        int n7 = n5 / 18 + 1;
        int n8 = 0;
        int n9 = 0;
        if (granule.getBlockType() == 2) {
            if (granule.getSwitchPoint()) {
                n9 = 2;
            }
        } else {
            n9 = n7;
        }
        n5 = 0;
        for (n4 = 0; n4 < n9; ++n4) {
            this.imdct36(this.computerImdctTmpBuffer, nArray3, n5);
            n3 = n4;
            n2 = granule.getSwitchPoint() && n4 < 2 ? 0 : 36 * granule.getBlockType();
            n2 += 0x90 & -(n4 & 1);
            for (n = 0; n < 18; ++n) {
                nArray[n3] = SoundOutput.MULL(this.computerImdctTmpBuffer[n], mdct_win[n2 + n]) + nArray2[n8 + n];
                nArray2[n8 + n] = SoundOutput.MULL(this.computerImdctTmpBuffer[n + 18], mdct_win[n2 + n + 18]);
                n3 += 32;
            }
            n5 += 18;
            n8 += 18;
        }
        for (n4 = n9; n4 < n7; ++n4) {
            int n10;
            for (n3 = 0; n3 < 6; ++n3) {
                this.computerImdctTmpBuffer[n3] = 0;
                this.computerImdctTmpBuffer[n3 + 6] = 0;
                this.computerImdctTmpBuffer[n3 + 30] = 0;
            }
            n3 = 0x90 & -(n4 & 1);
            n2 = 6;
            for (n = 0; n < 3; ++n) {
                int n11;
                n10 = n5 + n;
                for (n11 = 0; n11 < 6; ++n11) {
                    this.computerImdctTmpIn[n11] = nArray3[n10];
                    n10 += 3;
                }
                this.imdct12(this.computerImdctTmpBuffer2, this.computerImdctTmpIn);
                for (n11 = 0; n11 < 6; ++n11) {
                    this.computerImdctTmpBuffer[n2 + n11] = SoundOutput.MULL(this.computerImdctTmpBuffer2[n11], mdct_win[72 + n3 + n11]) + this.computerImdctTmpBuffer[n2 + n11];
                    this.computerImdctTmpBuffer[n2 + n11 + 6] = SoundOutput.MULL(this.computerImdctTmpBuffer2[n11 + 6], mdct_win[72 + n3 + n11 + 6]);
                }
                n2 += 6;
            }
            n = 0;
            for (n10 = 0; n10 < 18; ++n10) {
                nArray[n4 + n] = this.computerImdctTmpBuffer[n10] + nArray2[n8 + n10];
                nArray2[n8 + n10] = this.computerImdctTmpBuffer[n10 + 18];
                n += 32;
            }
            n8 += 18;
            n5 += 18;
        }
        for (n4 = n7; n4 < 32; ++n4) {
            n3 = n4;
            for (n2 = 0; n2 < 18; ++n2) {
                nArray[n3] = nArray2[n8 + n2];
                nArray2[n8 + n2] = 0;
                n3 += 32;
            }
            n8 += 18;
        }
    }

    private final void BF(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = nArray[n2 += n] + nArray[n3 += n];
        int n6 = nArray[n2] - nArray[n3];
        nArray[n2] = n5;
        nArray[n3] = SoundOutput.MULL(n6, n4);
    }

    public final void BF1(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        this.BF(nArray, n, n2, n3, COS4_0);
        this.BF(nArray, n, n4, n5, -COS4_0);
        int n6 = n + n4;
        nArray[n6] = nArray[n6] + nArray[n + n5];
    }

    public final void BF2(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        this.BF(nArray, n, n2, n3, COS4_0);
        this.BF(nArray, n, n4, n5, -COS4_0);
        int n6 = n + n4;
        nArray[n6] = nArray[n6] + nArray[n + n5];
        int n7 = n + n2;
        nArray[n7] = nArray[n7] + nArray[n + n4];
        int n8 = n + n4;
        nArray[n8] = nArray[n8] + nArray[n + n3];
        int n9 = n + n3;
        nArray[n9] = nArray[n9] + nArray[n + n5];
    }

    private void dct32(int[] nArray, int[] nArray2, int n) {
        this.BF(nArray2, n, 0, 31, COS0_0);
        this.BF(nArray2, n, 1, 30, COS0_1);
        this.BF(nArray2, n, 2, 29, COS0_2);
        this.BF(nArray2, n, 3, 28, COS0_3);
        this.BF(nArray2, n, 4, 27, COS0_4);
        this.BF(nArray2, n, 5, 26, COS0_5);
        this.BF(nArray2, n, 6, 25, COS0_6);
        this.BF(nArray2, n, 7, 24, COS0_7);
        this.BF(nArray2, n, 8, 23, COS0_8);
        this.BF(nArray2, n, 9, 22, COS0_9);
        this.BF(nArray2, n, 10, 21, COS0_10);
        this.BF(nArray2, n, 11, 20, COS0_11);
        this.BF(nArray2, n, 12, 19, COS0_12);
        this.BF(nArray2, n, 13, 18, COS0_13);
        this.BF(nArray2, n, 14, 17, COS0_14);
        this.BF(nArray2, n, 15, 16, COS0_15);
        this.BF(nArray2, n, 0, 15, COS1_0);
        this.BF(nArray2, n, 1, 14, COS1_1);
        this.BF(nArray2, n, 2, 13, COS1_2);
        this.BF(nArray2, n, 3, 12, COS1_3);
        this.BF(nArray2, n, 4, 11, COS1_4);
        this.BF(nArray2, n, 5, 10, COS1_5);
        this.BF(nArray2, n, 6, 9, COS1_6);
        this.BF(nArray2, n, 7, 8, COS1_7);
        this.BF(nArray2, n, 16, 31, -COS1_0);
        this.BF(nArray2, n, 17, 30, -COS1_1);
        this.BF(nArray2, n, 18, 29, -COS1_2);
        this.BF(nArray2, n, 19, 28, -COS1_3);
        this.BF(nArray2, n, 20, 27, -COS1_4);
        this.BF(nArray2, n, 21, 26, -COS1_5);
        this.BF(nArray2, n, 22, 25, -COS1_6);
        this.BF(nArray2, n, 23, 24, -COS1_7);
        this.BF(nArray2, n, 0, 7, COS2_0);
        this.BF(nArray2, n, 1, 6, COS2_1);
        this.BF(nArray2, n, 2, 5, COS2_2);
        this.BF(nArray2, n, 3, 4, COS2_3);
        this.BF(nArray2, n, 8, 15, -COS2_0);
        this.BF(nArray2, n, 9, 14, -COS2_1);
        this.BF(nArray2, n, 10, 13, -COS2_2);
        this.BF(nArray2, n, 11, 12, -COS2_3);
        this.BF(nArray2, n, 16, 23, COS2_0);
        this.BF(nArray2, n, 17, 22, COS2_1);
        this.BF(nArray2, n, 18, 21, COS2_2);
        this.BF(nArray2, n, 19, 20, COS2_3);
        this.BF(nArray2, n, 24, 31, -COS2_0);
        this.BF(nArray2, n, 25, 30, -COS2_1);
        this.BF(nArray2, n, 26, 29, -COS2_2);
        this.BF(nArray2, n, 27, 28, -COS2_3);
        this.BF(nArray2, n, 0, 3, COS3_0);
        this.BF(nArray2, n, 1, 2, COS3_1);
        this.BF(nArray2, n, 4, 7, -COS3_0);
        this.BF(nArray2, n, 5, 6, -COS3_1);
        this.BF(nArray2, n, 8, 11, COS3_0);
        this.BF(nArray2, n, 9, 10, COS3_1);
        this.BF(nArray2, n, 12, 15, -COS3_0);
        this.BF(nArray2, n, 13, 14, -COS3_1);
        this.BF(nArray2, n, 16, 19, COS3_0);
        this.BF(nArray2, n, 17, 18, COS3_1);
        this.BF(nArray2, n, 20, 23, -COS3_0);
        this.BF(nArray2, n, 21, 22, -COS3_1);
        this.BF(nArray2, n, 24, 27, COS3_0);
        this.BF(nArray2, n, 25, 26, COS3_1);
        this.BF(nArray2, n, 28, 31, -COS3_0);
        this.BF(nArray2, n, 29, 30, -COS3_1);
        this.BF1(nArray2, n, 0, 1, 2, 3);
        this.BF2(nArray2, n, 4, 5, 6, 7);
        this.BF1(nArray2, n, 8, 9, 10, 11);
        this.BF2(nArray2, n, 12, 13, 14, 15);
        this.BF1(nArray2, n, 16, 17, 18, 19);
        this.BF2(nArray2, n, 20, 21, 22, 23);
        this.BF1(nArray2, n, 24, 25, 26, 27);
        this.BF2(nArray2, n, 28, 29, 30, 31);
        int n2 = n + 8;
        nArray2[n2] = nArray2[n2] + nArray2[n + 12];
        int n3 = n + 12;
        nArray2[n3] = nArray2[n3] + nArray2[n + 10];
        int n4 = n + 10;
        nArray2[n4] = nArray2[n4] + nArray2[n + 14];
        int n5 = n + 14;
        nArray2[n5] = nArray2[n5] + nArray2[n + 9];
        int n6 = n + 9;
        nArray2[n6] = nArray2[n6] + nArray2[n + 13];
        int n7 = n + 13;
        nArray2[n7] = nArray2[n7] + nArray2[n + 11];
        int n8 = n + 11;
        nArray2[n8] = nArray2[n8] + nArray2[n + 15];
        nArray[0] = nArray2[n + 0];
        nArray[16] = nArray2[n + 1];
        nArray[8] = nArray2[n + 2];
        nArray[24] = nArray2[n + 3];
        nArray[4] = nArray2[n + 4];
        nArray[20] = nArray2[n + 5];
        nArray[12] = nArray2[n + 6];
        nArray[28] = nArray2[n + 7];
        nArray[2] = nArray2[n + 8];
        nArray[18] = nArray2[n + 9];
        nArray[10] = nArray2[n + 10];
        nArray[26] = nArray2[n + 11];
        nArray[6] = nArray2[n + 12];
        nArray[22] = nArray2[n + 13];
        nArray[14] = nArray2[n + 14];
        nArray[30] = nArray2[n + 15];
        int n9 = n + 24;
        nArray2[n9] = nArray2[n9] + nArray2[n + 28];
        int n10 = n + 28;
        nArray2[n10] = nArray2[n10] + nArray2[n + 26];
        int n11 = n + 26;
        nArray2[n11] = nArray2[n11] + nArray2[n + 30];
        int n12 = n + 30;
        nArray2[n12] = nArray2[n12] + nArray2[n + 25];
        int n13 = n + 25;
        nArray2[n13] = nArray2[n13] + nArray2[n + 29];
        int n14 = n + 29;
        nArray2[n14] = nArray2[n14] + nArray2[n + 27];
        int n15 = n + 27;
        nArray2[n15] = nArray2[n15] + nArray2[n + 31];
        nArray[1] = nArray2[n + 16] + nArray2[n + 24];
        nArray[17] = nArray2[n + 17] + nArray2[n + 25];
        nArray[9] = nArray2[n + 18] + nArray2[n + 26];
        nArray[25] = nArray2[n + 19] + nArray2[n + 27];
        nArray[5] = nArray2[n + 20] + nArray2[n + 28];
        nArray[21] = nArray2[n + 21] + nArray2[n + 29];
        nArray[13] = nArray2[n + 22] + nArray2[n + 30];
        nArray[29] = nArray2[n + 23] + nArray2[n + 31];
        nArray[3] = nArray2[n + 24] + nArray2[n + 20];
        nArray[19] = nArray2[n + 25] + nArray2[n + 21];
        nArray[11] = nArray2[n + 26] + nArray2[n + 22];
        nArray[27] = nArray2[n + 27] + nArray2[n + 23];
        nArray[7] = nArray2[n + 28] + nArray2[n + 18];
        nArray[23] = nArray2[n + 29] + nArray2[n + 19];
        nArray[15] = nArray2[n + 30] + nArray2[n + 17];
        nArray[31] = nArray2[n + 31];
    }

    private long SUM8(long l, int n, int[] nArray, int n2) {
        l += SoundOutput.MUL64(window[0 + n], nArray[0 + n2]);
        l += SoundOutput.MUL64(window[64 + n], nArray[64 + n2]);
        l += SoundOutput.MUL64(window[128 + n], nArray[128 + n2]);
        l += SoundOutput.MUL64(window[192 + n], nArray[192 + n2]);
        l += SoundOutput.MUL64(window[256 + n], nArray[256 + n2]);
        l += SoundOutput.MUL64(window[320 + n], nArray[320 + n2]);
        l += SoundOutput.MUL64(window[384 + n], nArray[384 + n2]);
        return l += SoundOutput.MUL64(window[448 + n], nArray[448 + n2]);
    }

    private long SUB8(long l, int n, int[] nArray, int n2) {
        l -= SoundOutput.MUL64(window[0 + n], nArray[0 + n2]);
        l -= SoundOutput.MUL64(window[64 + n], nArray[64 + n2]);
        l -= SoundOutput.MUL64(window[128 + n], nArray[128 + n2]);
        l -= SoundOutput.MUL64(window[192 + n], nArray[192 + n2]);
        l -= SoundOutput.MUL64(window[256 + n], nArray[256 + n2]);
        l -= SoundOutput.MUL64(window[320 + n], nArray[320 + n2]);
        l -= SoundOutput.MUL64(window[384 + n], nArray[384 + n2]);
        return l -= SoundOutput.MUL64(window[448 + n], nArray[448 + n2]);
    }

    private void OUT_SAMPLE(long l, byte[] byArray, int n) {
        int n2 = (int)(l + 0x800000L >> 24);
        if (n2 < Short.MIN_VALUE) {
            n2 = Short.MIN_VALUE;
        } else if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        }
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
    }

    public int synth_filter(int n, int n2, byte[] byArray, int n3, int[] nArray, int n4) {
        int n5;
        int n6;
        int n7;
        this.dct32(this.synth_filterTmpBuffer, nArray, n4);
        int n8 = this.synth_buf_offset[n];
        int[] nArray2 = this.synth_buf[n];
        for (n7 = 0; n7 < 32; ++n7) {
            nArray2[n7 + n8] = this.synth_filterTmpBuffer[n7];
        }
        System.arraycopy(nArray2, n8, nArray2, n8 + 512, 32);
        n7 = 0;
        long l = 0L;
        for (n6 = 0; n6 < 16; ++n6) {
            l = 0L;
            n5 = n8 + 16 + n6;
            l = this.SUM8(l, n7, nArray2, n5);
            n5 = n8 + 48 - n6;
            l = this.SUB8(l, n7 + 32, nArray2, n5);
            this.OUT_SAMPLE(l, byArray, n3);
            n3 += 2 * n2;
            ++n7;
        }
        n5 = n8 + 32;
        l = 0L;
        l = this.SUB8(l, n7 + 32, nArray2, n5);
        this.OUT_SAMPLE(l, byArray, n3);
        n3 += 2 * n2;
        ++n7;
        for (n6 = 17; n6 < 32; ++n6) {
            l = 0L;
            n5 = n8 + 48 - n6;
            l = this.SUB8(l, n7, nArray2, n5);
            n5 = n8 + 16 + n6;
            l = this.SUB8(l, n7 + 32, nArray2, n5);
            this.OUT_SAMPLE(l, byArray, n3);
            n3 += 2 * n2;
            ++n7;
        }
        this.synth_buf_offset[n] = n8 = n8 - 32 & 0x1FF;
        return n3;
    }

    private static final int MULL(int n, int n2) {
        return (int)((long)n * (long)n2 >> 23);
    }

    public static final int FIXR(double d) {
        return (int)(d * 8388608.0 + 0.5);
    }

    public static final long MUL64(long l, long l2) {
        return l * l2;
    }

    public static int FRAC_RND(long l) {
        return (int)(l + 0x400000L >> 23);
    }

    static {
        int n;
        C1_18 = SoundOutput.FIXR(0.984807753012208);
        C2_18 = SoundOutput.FIXR(0.9396926207859084);
        C3_18 = SoundOutput.FIXR(0.8660254037844386);
        C4_18 = SoundOutput.FIXR(0.766044443118978);
        C5_18 = SoundOutput.FIXR(0.6427876096865394);
        C6_18 = SoundOutput.FIXR(0.5);
        C7_18 = SoundOutput.FIXR(0.3420201433256687);
        C8_18 = SoundOutput.FIXR(0.17364817766693036);
        icos36 = new int[]{SoundOutput.FIXR(0.5019099187716737), SoundOutput.FIXR(0.5176380902050415), SoundOutput.FIXR(0.5516889594812459), SoundOutput.FIXR(0.610387294380728), SoundOutput.FIXR(0.7071067811865476), SoundOutput.FIXR(0.871723397810549), SoundOutput.FIXR(1.1831007915762493), SoundOutput.FIXR(1.9318516525781366), SoundOutput.FIXR(5.736856622834927)};
        icos72 = new int[]{SoundOutput.FIXR(0.7400936164611305), SoundOutput.FIXR(0.8213398158522908), SoundOutput.FIXR(0.930579498351789), SoundOutput.FIXR(1.0828402851001002), SoundOutput.FIXR(1.3065629648763766), SoundOutput.FIXR(1.6627547617115208), SoundOutput.FIXR(2.3101131576726495), SoundOutput.FIXR(3.8306487877701945), SoundOutput.FIXR(11.462792813026674), SoundOutput.FIXR(-0.6781708524546284), SoundOutput.FIXR(-0.6302362070051323), SoundOutput.FIXR(-0.5928445237170803), SoundOutput.FIXR(-0.5636909734331712), SoundOutput.FIXR(-0.541196100146197), SoundOutput.FIXR(-0.5242645625704053), SoundOutput.FIXR(-0.5121397571572546), SoundOutput.FIXR(-0.5043144802900763), SoundOutput.FIXR(-0.50047634258166)};
        C1 = SoundOutput.FIXR(0.9914448613738104);
        C3 = SoundOutput.FIXR(0.9238795325112867);
        C5 = SoundOutput.FIXR(0.7933533402912352);
        C7 = SoundOutput.FIXR(0.6087614290087207);
        C9 = SoundOutput.FIXR(0.3826834323650898);
        C11 = SoundOutput.FIXR(0.1305261922200516);
        COS0_0 = SoundOutput.FIXR(0.5006029982351963);
        COS0_1 = SoundOutput.FIXR(0.5054709598975436);
        COS0_2 = SoundOutput.FIXR(0.5154473099226246);
        COS0_3 = SoundOutput.FIXR(0.5310425910897841);
        COS0_4 = SoundOutput.FIXR(0.5531038960344445);
        COS0_5 = SoundOutput.FIXR(0.5829349682061339);
        COS0_6 = SoundOutput.FIXR(0.6225041230356648);
        COS0_7 = SoundOutput.FIXR(0.6748083414550058);
        COS0_8 = SoundOutput.FIXR(0.7445362710022985);
        COS0_9 = SoundOutput.FIXR(0.839349645415527);
        COS0_10 = SoundOutput.FIXR(0.9725682378619607);
        COS0_11 = SoundOutput.FIXR(1.1694399334328849);
        COS0_12 = SoundOutput.FIXR(1.4841646163141662);
        COS0_13 = SoundOutput.FIXR(2.0577810099534117);
        COS0_14 = SoundOutput.FIXR(3.407608418468719);
        COS0_15 = SoundOutput.FIXR(10.190008123548056);
        COS1_0 = SoundOutput.FIXR(0.5024192861881557);
        COS1_1 = SoundOutput.FIXR(0.5224986149396889);
        COS1_2 = SoundOutput.FIXR(0.5669440348163577);
        COS1_3 = SoundOutput.FIXR(0.6468217833599901);
        COS1_4 = SoundOutput.FIXR(0.7881546234512502);
        COS1_5 = SoundOutput.FIXR(1.0606776859903475);
        COS1_6 = SoundOutput.FIXR(1.722447098238334);
        COS1_7 = SoundOutput.FIXR(5.101148618689164);
        COS2_0 = SoundOutput.FIXR(0.5097955791041592);
        COS2_1 = SoundOutput.FIXR(0.6013448869350453);
        COS2_2 = SoundOutput.FIXR(0.8999762231364157);
        COS2_3 = SoundOutput.FIXR(2.5629154477415064);
        COS3_0 = SoundOutput.FIXR(0.541196100146197);
        COS3_1 = SoundOutput.FIXR(1.3065629648763766);
        COS4_0 = SoundOutput.FIXR(0.7071067811865476);
        window = new int[512];
        mdct_win = new int[288];
        for (n = 0; n < 36; ++n) {
            int n2;
            SoundOutput.mdct_win[0 + n] = n2 = SoundOutput.FIXR(Granule.sin(Math.PI * ((double)n + 0.5) / 36.0));
            SoundOutput.mdct_win[36 + n] = n2;
            SoundOutput.mdct_win[108 + n] = n2;
        }
        for (n = 0; n < 6; ++n) {
            SoundOutput.mdct_win[54 + n] = SoundOutput.FIXR(1.0);
            SoundOutput.mdct_win[60 + n] = SoundOutput.FIXR(Granule.sin(Math.PI * ((double)(n + 6) + 0.5) / 12.0));
            SoundOutput.mdct_win[66 + n] = SoundOutput.FIXR(0.0);
            SoundOutput.mdct_win[108 + n] = SoundOutput.FIXR(0.0);
            SoundOutput.mdct_win[114 + n] = SoundOutput.FIXR(Granule.sin(Math.PI * ((double)n + 0.5) / 12.0));
            SoundOutput.mdct_win[120 + n] = SoundOutput.FIXR(1.0);
        }
        for (n = 0; n < 12; ++n) {
            SoundOutput.mdct_win[72 + n] = SoundOutput.FIXR(Granule.sin(Math.PI * ((double)n + 0.5) / 12.0));
        }
        for (int i = 0; i < 4; ++i) {
            for (n = 0; n < 36; n += 2) {
                SoundOutput.mdct_win[(i + 4) * 36 + n] = mdct_win[i * 36 + n];
                SoundOutput.mdct_win[(i + 4) * 36 + n + 1] = -mdct_win[i * 36 + n + 1];
            }
        }
        int[] nArray = Table.getMpaEnTable();
        for (n = 0; n < 257; ++n) {
            int n3;
            SoundOutput.window[n] = n3 = nArray[n];
            if ((n & 0x3F) != 0) {
                n3 = -n3;
            }
            if (n == 0) continue;
            SoundOutput.window[512 - n] = n3;
        }
    }
}

