/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.Granule;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.SoundOutput;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.data.Table;
import net.sourceforge.jffmpeg.codecs.utils.BitStream;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;

public class MP3
implements Codec,
JMFCodec {
    public static final boolean debug = false;
    public static final int MPA_STEREO = 0;
    public static final int MPA_JSTEREO = 1;
    public static final int MPA_DUAL = 2;
    public static final int MPA_MONO = 3;
    public static final int MODE_EXT_I_STEREO = 1;
    public static final int MODE_EXT_MS_STEREO = 2;
    protected BitStream in = new BitStream();
    protected BitStream granuleIn = new BitStream();
    protected int headerMask = 0;
    protected int streamHeader = 0;
    protected boolean gotHeader = false;
    protected boolean lsf;
    protected int layer;
    protected boolean mpeg25;
    protected boolean error_protection;
    protected int bitrate_index;
    protected int sample_rate_index;
    protected boolean padding;
    protected boolean extension;
    protected int mode;
    protected int mode_ext;
    protected boolean copyright;
    protected boolean original;
    protected int emphasis;
    protected int frame_size;
    protected int bitRate;
    public static int ID3 = 0x494433;
    public static int LAME = 1279348037;
    private boolean lameFile;
    protected int nb_channels;
    protected int[][][] mpa_bitrate_tab = Table.getBitrateTable();
    protected int[] mpa_freq_tab = new int[]{44100, 48000, 32000};
    protected Granule[][] granules;
    private int[][][] sb_samples = new int[2][2][576];
    private int[][] mdct_buffer = new int[2][576];
    private SoundOutput soundOutput = new SoundOutput();
    private AudioFormat inputFormat;
    private int currentHeader = -1;

    private final boolean isHeader(int n) {
        return (n & 0xFFE00000) == -2097152 && (n & 0x60000) != 0 && (n & 0xF000) != 15 && (n & 0xC00) != 3;
    }

    public MP3() {
        this.granules = new Granule[2][2];
        this.granules[0][0] = new Granule();
        this.granules[0][1] = new Granule();
        this.granules[1][0] = new Granule();
        this.granules[1][1] = new Granule();
    }

    private int decodeHeader() {
        int n = this.in.getBits(16) << 16 | this.in.getBits(16);
        int n2 = n >> 21 & 0x7FF;
        if ((n & 0x100000) != 0) {
            this.lsf = (n & 0x80000) == 0;
            this.mpeg25 = false;
        } else {
            this.lsf = true;
            this.mpeg25 = true;
        }
        this.layer = 4 - (n >> 17 & 3);
        this.error_protection = (n >> 16 & 1) == 0;
        this.bitrate_index = n >> 12 & 0xF;
        this.sample_rate_index = n >> 10 & 3;
        this.padding = (n >> 9 & 1) != 0;
        this.extension = (n >> 8 & 1) != 0;
        this.mode = n >> 6 & 3;
        this.mode_ext = n >> 4 & 3;
        this.copyright = (n >> 3 & 1) != 0;
        this.original = (n >> 2 & 1) != 0;
        this.emphasis = n & 3;
        int n3 = this.nb_channels = this.mode == 3 ? 1 : 2;
        if ((0xFFFEFC00 & this.currentHeader) != this.streamHeader && this.streamHeader != 0 || n2 != 2047 || this.layer == 4 || this.bitrate_index == 15 || this.sample_rate_index == 3) {
            this.in.seek(this.in.getPos() - 24 & 0xFFFFFFF8);
            while (this.in.availableBits() > 32 && this.in.showBits(11) != 2047) {
                this.in.getBits(8);
            }
            return -1;
        }
        this.streamHeader = this.currentHeader & 0xFFFEFC00;
        if (this.bitrate_index != 0) {
            int n4 = this.mpa_freq_tab[this.sample_rate_index] >> (this.lsf ? 1 : 0) + (this.mpeg25 ? 1 : 0);
            this.sample_rate_index += 3 * ((this.lsf ? 1 : 0) + (this.mpeg25 ? 1 : 0));
            this.frame_size = this.mpa_bitrate_tab[this.lsf ? 1 : 0][this.layer - 1][this.bitrate_index];
            this.bitRate = this.frame_size * 1000;
            switch (this.layer) {
                case 1: {
                    this.frame_size = this.frame_size * 12000 / n4;
                    this.frame_size = (this.frame_size + (this.padding ? 1 : 0)) * 4;
                    break;
                }
                case 2: {
                    this.frame_size = this.frame_size * 144000 / n4;
                    this.frame_size += this.padding ? 1 : 0;
                    break;
                }
                default: {
                    this.frame_size = this.frame_size * 144000 / (n4 << (this.lsf ? 1 : 0));
                    this.frame_size += this.padding ? 1 : 0;
                    break;
                }
            }
        } else {
            throw new Error("Free format frame size");
        }
        return n;
    }

    private void decodeMP3(Buffer buffer, int n) throws FFMpegException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.error_protection) {
            this.in.getBits(16);
        }
        if (this.lsf) {
            n6 = this.in.getBits(8);
            n5 = this.in.getBits(this.nb_channels == 2 ? 2 : 1);
            n4 = 1;
        } else {
            n6 = this.in.getBits(9);
            n5 = this.in.getBits(this.nb_channels == 2 ? 3 : 5);
            n4 = 2;
            for (n3 = 0; n3 < this.nb_channels; ++n3) {
                this.granules[n3][0].setScfsi(0);
                this.granules[n3][1].setScfsi(this.in.getBits(4));
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i < this.nb_channels; ++i) {
                this.granules[i][n3].read(this.in, this.lsf, this.mode_ext);
            }
        }
        n3 = this.granuleIn.getPos() + this.granuleIn.availableBits() - n6 * 8;
        this.granuleIn.seek(n3);
        byte[] byArray = this.in.getDataArray();
        int n7 = (this.in.getPos() + 7) / 8;
        this.granuleIn.addData(byArray, n7, this.frame_size - (n7 - n / 8));
        this.in.seek(n + this.frame_size * 8);
        if (n3 < 0) {
            return;
        }
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < this.nb_channels; ++n2) {
                this.granules[n2][i].readScaleFactors(this.granuleIn, this.lsf, this.granules[n2][0], n2, this.mode_ext);
                this.granules[n2][i].exponents_from_scale_factors(this.sample_rate_index);
                this.granules[n2][i].huffman_decode(this.granuleIn, this.sample_rate_index);
            }
            if (this.nb_channels == 2) {
                this.granules[1][i].computeStereo(this, this.granules[0][i]);
            }
            for (n2 = 0; n2 < this.nb_channels; ++n2) {
                this.granules[n2][i].reorderBlock(this);
                this.granules[n2][i].antialias(this);
                this.soundOutput.computeImdct(this.granules[n2][i], this.sb_samples[n2][i], this.mdct_buffer[n2]);
            }
        }
        byte[] byArray2 = (byte[])buffer.getData();
        n2 = buffer.getLength();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
            n2 = 0;
        }
        if (byArray2.length - n2 < this.nb_channels * n4 * 18 * 32 * 2) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[4 * (byArray2.length + this.nb_channels * n4 * 18 * 32)];
            System.arraycopy(byArray3, 0, byArray2, 0, n2);
            buffer.setData((Object)byArray2);
        }
        for (int i = 0; i < this.nb_channels; ++i) {
            int n8 = n2 + i * 2;
            for (int j = 0; j < n4 * 18; ++j) {
                this.soundOutput.synth_filter(i, this.nb_channels, byArray2, n8, this.sb_samples[i][j / 18], j % 18 * 32);
                n8 += 32 * this.nb_channels * 2;
            }
        }
        buffer.setLength(n2 + this.nb_channels * n4 * 18 * 32 * 2);
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("mpeglayer3")};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return new Format[]{new AudioFormat("LINEAR")};
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (AudioFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        return new AudioFormat("LINEAR", this.inputFormat.getSampleRate(), this.inputFormat.getSampleSizeInBits() > 0 ? this.inputFormat.getSampleSizeInBits() : 16, this.inputFormat.getChannels(), 0, 1);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if ((buffer.getFlags() & 0x200) != 0) {
            this.reset();
        }
        buffer2.setFlags(buffer.getFlags());
        buffer2.setTimeStamp(buffer.getTimeStamp());
        buffer2.setDuration(buffer.getDuration());
        try {
            byte[] byArray = (byte[])buffer.getData();
            int n = buffer.getLength();
            this.in.addData(byArray, 0, n);
            do {
                if (this.currentHeader == -1) {
                    if (this.in.availableBits() >= 32) {
                        this.currentHeader = this.decodeHeader();
                        if (this.currentHeader == -1) continue;
                    }
                    break;
                }
                if (this.frame_size * 8 >= this.in.availableBits() - 32) continue;
                this.decodeMP3(buffer2, this.in.getPos() - 32);
                this.currentHeader = -1;
            } while (this.currentHeader == -1 && this.in.availableBits() >= 128);
        }
        catch (Exception exception) {
            this.reset();
            exception.printStackTrace();
            return 1;
        }
        catch (Error error) {
            this.reset();
            error.printStackTrace();
            this.currentHeader = -1;
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
        this.sb_samples = new int[2][2][576];
        this.mdct_buffer = new int[2][576];
        this.soundOutput = new SoundOutput();
        this.in = new BitStream();
        this.granuleIn = new BitStream();
        this.granules[0][0] = new Granule();
        this.granules[0][1] = new Granule();
        this.granules[1][0] = new Granule();
        this.granules[1][1] = new Granule();
    }

    public String getName() {
        return "mpeglayer3";
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public boolean isCodecAvailable() {
        return true;
    }

    public void setVideoSize(Dimension dimension) {
    }

    public void setEncoding(String string) {
    }

    public void setIsRtp(boolean bl) {
    }

    public void setIsTruncated(boolean bl) {
    }
}

