/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg;

import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.sourceforge.jffmpeg.CodecManager;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.JffmpegAudioFormat;

public class AudioDecoder
implements Codec {
    private CodecManager codecManager = new CodecManager();
    private JMFCodec peer = null;

    public Format[] getSupportedInputFormats() {
        return this.codecManager.getSupportedAudioFormats();
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null || !(format instanceof AudioFormat)) {
            return new Format[0];
        }
        AudioFormat audioFormat = (AudioFormat)format;
        JffmpegAudioFormat jffmpegAudioFormat = this.codecManager.getAudioCodec(format.getEncoding());
        return new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() > 0 ? audioFormat.getSampleSizeInBits() : 16, audioFormat.getChannels(), 0, 1)};
    }

    public Format setInputFormat(Format format) {
        JffmpegAudioFormat jffmpegAudioFormat = this.codecManager.getAudioCodec(format.getEncoding());
        if (jffmpegAudioFormat == null) {
            return null;
        }
        try {
            this.peer = (JMFCodec)Class.forName(jffmpegAudioFormat.getCodecClass()).newInstance();
            if (!this.peer.isCodecAvailable()) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        this.peer.setEncoding(jffmpegAudioFormat.getFFMpegCodecName());
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (this.peer == null) {
            throw new IllegalArgumentException("Must set Input Format first");
        }
        AudioFormat audioFormat = (AudioFormat)format;
        return new AudioFormat("LINEAR", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() > 0 ? audioFormat.getSampleSizeInBits() : 16, audioFormat.getChannels(), 0, 1);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        return this.peer.process(buffer, buffer2);
    }

    public void open() throws ResourceUnavailableException {
        this.peer.open();
    }

    public void close() {
        this.peer.close();
    }

    public void reset() {
        this.peer.reset();
    }

    public String getName() {
        return "JFFMPEG audio decoder";
    }

    public Object[] getControls() {
        return null;
    }

    public Object getControl(String string) {
        return null;
    }
}

