/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class TiffDecoder {
    byte[] bytes;

    public TiffDecoder(int n, int n2, Map map, byte[] byArray) {
        this.bytes = null;
        boolean bl = false;
        int n3 = 0;
        String string = (String)map.get("K");
        if (string != null) {
            n3 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("BlackIs1")) != null) {
            bl = Boolean.valueOf(string);
        }
        this.buildImage(n, n2, byArray, bl, n3);
    }

    public TiffDecoder(int n, int n2, PdfObject pdfObject, byte[] byArray) {
        HashMap hashMap = new HashMap();
        this.bytes = null;
        boolean bl = false;
        int n3 = 0;
        if (pdfObject != null) {
            n3 = pdfObject.getInt(27);
            int n4 = pdfObject.getInt(1162902911);
            if (n4 != -1) {
                n = n4;
            }
            bl = pdfObject.getBoolean(1297445940);
        }
        this.buildImage(n, n2, byArray, bl, n3);
    }

    private void buildImage(int n, int n2, byte[] byArray, boolean bl, int n3) {
        int n4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String[] stringArray = new String[]{"4d", "4d", "00", "2a", "00", "00", "00", "08"};
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            byteArrayOutputStream.write(Integer.parseInt(stringArray[n4], 16));
        }
        n4 = 9;
        boolean bl2 = true;
        this.writeWord(String.valueOf(n4), byteArrayOutputStream);
        this.writeTag("256", "04", "01", String.valueOf(n), byteArrayOutputStream);
        this.writeTag("257", "04", "01", String.valueOf(n2), byteArrayOutputStream);
        this.writeTag("258", "03", "01", "00010000h", byteArrayOutputStream);
        if (n3 == 0) {
            this.writeTag("259", "03", "01", "00030000h", byteArrayOutputStream);
        } else if (n3 > 0) {
            this.writeTag("259", "03", "01", "00020000h", byteArrayOutputStream);
        } else if (n3 < 0) {
            this.writeTag("259", "03", "01", "00040000h", byteArrayOutputStream);
        }
        if (!bl) {
            this.writeTag("262", "03", "01", "00000000h", byteArrayOutputStream);
        } else {
            this.writeTag("262", "03", "01", "00010000h", byteArrayOutputStream);
        }
        this.writeTag("273", "04", "1", "122", byteArrayOutputStream);
        this.writeTag("277", "03", "01", "00010000h", byteArrayOutputStream);
        this.writeTag("278", "04", "01", String.valueOf(n2), byteArrayOutputStream);
        this.writeTag("279", "04", "1", String.valueOf(byArray.length), byteArrayOutputStream);
        this.writeDWord("0", byteArrayOutputStream);
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            JAIHelper.confirmJAIOnClasspath();
            ByteArraySeekableStream byteArraySeekableStream = new ByteArraySeekableStream(byteArrayOutputStream.toByteArray());
            RenderedOp renderedOp = JAI.create((String)"stream", (Object)byteArraySeekableStream);
            Raster raster = renderedOp.getData();
            DataBuffer dataBuffer = raster.getDataBuffer();
            DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
            this.bytes = dataBufferByte.getData();
            if (!bl) {
                int n5 = this.bytes.length;
                for (int i = 0; i < n5; ++i) {
                    this.bytes[i] = (byte)(255 - this.bytes[i]);
                }
            }
        }
        catch (Error error) {
            LogWriter.writeLog("[PDF] Tiff error " + error);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    private void writeWord(String string, ByteArrayOutputStream byteArrayOutputStream) {
        int n = 0;
        n = string.endsWith("h") ? Integer.parseInt(string.substring(0, string.length() - 1), 16) : (string.endsWith("o") ? Integer.parseInt(string.substring(0, string.length() - 1), 8) : Integer.parseInt(string));
        byteArrayOutputStream.write(n >> 8);
        byteArrayOutputStream.write(n & 0xFF);
    }

    private void writeDWord(String string, ByteArrayOutputStream byteArrayOutputStream) {
        int n = 0;
        n = string.endsWith("h") ? Integer.parseInt(string.substring(0, string.length() - 1), 16) : (string.endsWith("o") ? Integer.parseInt(string.substring(0, string.length() - 1), 8) : Integer.parseInt(string));
        byteArrayOutputStream.write(n >> 24 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
    }

    private void writeTag(String string, String string2, String string3, String string4, ByteArrayOutputStream byteArrayOutputStream) {
        this.writeWord(string, byteArrayOutputStream);
        this.writeWord(string2, byteArrayOutputStream);
        this.writeDWord(string3, byteArrayOutputStream);
        this.writeDWord(string4, byteArrayOutputStream);
    }
}

