/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoder;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.io.ColorSpaceConvertor;

public class HiResThumbnailExtractor {
    private static boolean debug = true;
    static final String separator = System.getProperty("file.separator");

    public static void main(String[] stringArray) throws Exception {
        String string = "";
        String string2 = "";
        if (stringArray != null && stringArray.length > 1) {
            string2 = stringArray[0];
            string = stringArray[1];
            if (string2.endsWith(".pdf") && (string.equals("jpg") || string.equals("png") || string.equals("tiff"))) {
                HiResThumbnailExtractor.extract(string, string2);
            } else {
                System.out.println("The file to be processed has to be a pdf and the output filetype can only be jpg,png or tiff");
            }
        } else {
            System.out.println("Not enough arguments passed in! Usage: \"C:\\examples\\1.pdf\" \"jpg\"");
        }
    }

    private static void extract(String string, String string2) throws Exception {
        String string3 = string2.substring(0, string2.indexOf(".pdf")) + separator;
        File file = new File(string3);
        if (!(file.exists() && file.isDirectory() || file.mkdirs() || !debug)) {
            System.err.println("Can't create directory " + string3);
        }
        PdfDecoder pdfDecoder = new PdfDecoder(true);
        pdfDecoder.openPdfFile(string2);
        if (debug) {
            System.out.println("pdf : " + string2);
        }
        for (int i = 1; i <= pdfDecoder.getPageCount(); ++i) {
            HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
            hashMap.put(JPedalSettings.EXTRACT_AT_BEST_QUALITY, Boolean.TRUE);
            PdfDecoder.modifyJPedalParameters(hashMap);
            if (debug) {
                System.out.println("page : " + i);
            }
            BufferedImage bufferedImage = pdfDecoder.getPageAsImage(i);
            pdfDecoder.flushObjectValues(true);
            if (string.equals("jpg")) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
            String string4 = string3 + "page" + i + "." + string;
            File file2 = new File(string4);
            ImageIO.write((RenderedImage)bufferedImage, string, file2);
            if (!debug) continue;
            System.out.println("Created : " + string4);
        }
    }
}

