/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.decompression;

import java.util.BitSet;

public class CusotomBitSet {
    private boolean debug = false;
    public int cbsPtr = 0;
    public int cbsLength = 0;
    private BitSet data = null;

    public CusotomBitSet(BitSet bitSet, int n) {
        this.data = bitSet;
        this.cbsLength = n;
    }

    public void moveToEOLMarker() {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            bl = true;
            for (n = 0; n < 12; ++n) {
                if (n == 11) {
                    if (this.data.get(n + this.cbsPtr)) continue;
                    bl = false;
                    continue;
                }
                if (!this.data.get(n + this.cbsPtr)) continue;
                bl = false;
            }
            ++this.cbsPtr;
            if (this.cbsPtr <= 36) continue;
            this.cbsPtr = 0;
            return;
        }
        this.cbsPtr = this.cbsPtr + n - 1;
        if (this.debug) {
            System.out.println("-> CusotomBitSet pointer = " + this.cbsPtr);
        }
    }

    public BitSet getSection() {
        int n;
        BitSet bitSet = new BitSet();
        for (n = 0; n < 13; ++n) {
            bitSet.set(n, this.data.get(n + this.cbsPtr));
        }
        this.cbsPtr += n;
        if (this.debug) {
            System.out.println("-> CusotomBitSet pointer = " + this.cbsPtr);
            System.out.println("-> Sction listing:");
            for (int i = 0; i < 13; ++i) {
                if (bitSet.get(i)) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println("");
        }
        return bitSet;
    }

    public BitSet shiftOnce(BitSet bitSet) {
        int n;
        BitSet bitSet2 = new BitSet();
        for (n = 0; n < 12; ++n) {
            bitSet2.set(n, bitSet.get(n + 1));
        }
        bitSet2.set(12, this.data.get(this.cbsPtr++));
        if (this.debug) {
            System.err.println("-> Parameter:");
            for (n = 0; n < 13; ++n) {
                if (bitSet.get(n)) {
                    System.err.print("1");
                    continue;
                }
                System.err.print("0");
            }
            System.err.println("");
            System.err.println("- > shifted to:");
            for (n = 0; n < 13; ++n) {
                if (bitSet2.get(n)) {
                    System.err.print("1");
                    continue;
                }
                System.err.print("0");
            }
            System.err.println("");
        }
        return bitSet2;
    }

    public BitSet moveToNextRun(BitSet bitSet, int n) {
        int n2;
        BitSet bitSet2 = new BitSet();
        int n3 = n;
        int n4 = this.cbsPtr;
        int n5 = 13 - (13 - n);
        int n6 = 0;
        while (n < 13) {
            bitSet2.set(n6, bitSet.get(n));
            ++n6;
            ++n;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            bitSet2.set(n6, this.data.get(this.cbsPtr));
            ++this.cbsPtr;
            ++n6;
        }
        if (this.debug) {
            System.out.println("-> Parameter (t val=" + n3 + "):");
            for (n2 = 0; n2 < 13; ++n2) {
                if (bitSet.get(n2)) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println("");
            System.out.println("-> CusotomBitSet pointer = " + n4 + "\n");
            System.out.println("- > next:");
            for (n2 = 0; n2 < 13; ++n2) {
                if (bitSet2.get(n2)) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println("");
            System.out.println("-> CusotomBitSet pointer = " + this.cbsPtr);
        }
        return bitSet2;
    }

    public int getCbsPtr() {
        return this.cbsPtr;
    }

    public void printData(int n, int n2) {
        System.out.println("-> Displaying data from " + n + " till " + n2);
        while (n < n2) {
            if (this.data.get(n)) {
                System.out.print("1");
            } else {
                System.out.print("0");
            }
            ++n;
        }
        System.out.println("");
    }

    public BitSet byteAlignRow(BitSet bitSet, int n) {
        BitSet bitSet2 = null;
        if (n == 387) {
            // empty if block
        }
        int n2 = (this.cbsPtr - 13) % 8;
        int n3 = 8 - n2;
        if (n2 > 0) {
            this.cbsPtr = this.cbsPtr - 13 + n3;
            bitSet2 = this.getSection();
            if (n == 387) {
                // empty if block
            }
            return bitSet2;
        }
        return bitSet;
    }
}

