/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.repositories.Vector_Int;

public class SingleDisplay
implements Display {
    boolean isGeneratingOtherPages = false;
    Rectangle userAnnot = null;
    AffineTransform rawAf;
    Shape rawClip;
    DynamicVectorRenderer currentDisplay;
    boolean running = false;
    protected PageOffsets currentOffset;
    protected int volatileWidth;
    protected int volatileHeight;
    int startViewPage = 0;
    int endViewPage = 0;
    Map pagesDrawn = new HashMap();
    Map cachedPageViews = new WeakHashMap();
    Map currentPageViews = new HashMap();
    boolean screenNeedsRedrawing;
    PdfDecoder pdf;
    protected Vector_Int offsets = new Vector_Int(3);
    protected Map newPages = new HashMap();
    protected int currentXOffset = 0;
    protected int additionalPageCount = 0;
    float oldScaling = -1.0f;
    float oldRotation = -1.0f;
    float oldVolatileWidth = -1.0f;
    float oldVolatileHeight = -1.0f;
    int indent = 0;
    int[] xReached;
    int[] yReached;
    int[] pageW;
    int[] pageH;
    boolean[] isRotated;
    Map accleratedPagesAlreadyDrawn = new HashMap();
    boolean overRideAcceleration = false;
    private boolean message = false;
    int displayRotation;
    int displayView = 1;
    int insetW;
    int insetH;
    float scaling;
    int pageNumber;
    int pageCount = 0;
    PdfPageData pageData = null;
    private int lastPageChecked = -1;
    private int lastState = -1;
    Graphics2D g2;
    Rectangle[] areas;
    boolean useAcceleration = true;
    boolean isInitialised;
    int rx = 0;
    int ry = 0;
    int rw = 0;
    int rh = 0;
    int crx;
    int cry;
    int crw;
    int crh;
    int CURRENT_BORDER_STYLE = 1;
    AffineTransform current2 = null;
    Shape currentClip = null;
    protected Border myBorder;
    VolatileImage backBuffer = null;
    int topW;
    int topH;
    double cropX;
    double cropY;
    double cropW;
    double cropH;
    boolean thumbnailsRunning;
    protected GUIThumbnailPanel thumbnails = null;

    public SingleDisplay(int n, int n2, DynamicVectorRenderer dynamicVectorRenderer) {
        this.pageNumber = n;
        this.pageCount = n2;
        this.currentDisplay = dynamicVectorRenderer;
    }

    public SingleDisplay(PdfDecoder pdfDecoder) {
        this.pdf = pdfDecoder;
    }

    public void clearAdditionalPages() {
        this.offsets.clear();
        this.newPages.clear();
        this.currentXOffset = 0;
        this.additionalPageCount = 0;
    }

    public void addAdditionalPage(DynamicVectorRenderer dynamicVectorRenderer, int n, int n2) {
        this.offsets.addElement(this.currentXOffset + n2);
        this.newPages.put(new Integer(this.currentXOffset + n2), dynamicVectorRenderer);
        ++this.additionalPageCount;
        this.currentXOffset += n;
        this.oldScaling = -this.oldScaling;
        this.refreshDisplay();
    }

    protected void createBackBuffer() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
            this.backBuffer = null;
        }
        int n = 0;
        int n2 = 0;
        if (this.displayView == 1) {
            if (this.displayRotation == 90 | this.displayRotation == 270) {
                n = this.volatileHeight + this.currentXOffset;
                n2 = this.volatileWidth;
            } else {
                n = this.volatileWidth + this.currentXOffset;
                n2 = this.volatileHeight;
            }
        } else if (this.currentOffset != null) {
            int n3;
            int n4;
            int n5 = 0;
            if (this.displayView == 3 && this.pageW != null) {
                n4 = this.pageNumber;
                if ((n4 & 1) == 1) {
                    --n4;
                }
                n3 = n4 + 1;
                n5 = this.pageH[n4];
                if (n3 < this.pageH.length && n5 < this.pageH[n3]) {
                    n5 = this.pageH[n3];
                }
            }
            n4 = this.currentOffset.gaps;
            n3 = this.currentOffset.doubleGaps;
            switch (this.displayView) {
                case 3: {
                    if (this.displayRotation == 90 | this.displayRotation == 270) {
                        n = (int)((float)(this.currentOffset.doublePageHeight + this.insetW) * this.scaling);
                        n2 = n5;
                        break;
                    }
                    n = (int)((float)(this.currentOffset.doublePageWidth + this.insetW) * this.scaling);
                    n2 = n5;
                    break;
                }
                case 2: {
                    if (this.displayRotation == 90 | this.displayRotation == 270) {
                        n = (int)((float)this.currentOffset.biggestHeight * this.scaling);
                        n2 = (int)((float)this.currentOffset.totalSingleWidth * this.scaling) + n4 + this.insetH;
                        break;
                    }
                    n = (int)((float)this.currentOffset.biggestWidth * this.scaling);
                    n2 = (int)((float)this.currentOffset.totalSingleHeight * this.scaling) + n4 + this.insetH;
                    break;
                }
                case 4: {
                    if (this.displayRotation == 90 | this.displayRotation == 270) {
                        n = (int)((float)this.currentOffset.doublePageHeight * this.scaling) + this.insetW * 2 + n3;
                        n2 = (int)((float)this.currentOffset.totalDoubleWidth * this.scaling) + n3 + this.insetH;
                        break;
                    }
                    n = (int)((float)this.currentOffset.doublePageWidth * this.scaling) + this.insetW * 2;
                    n2 = (int)((float)this.currentOffset.totalDoubleHeight * this.scaling) + n3 + this.insetH;
                }
            }
        }
        try {
            if (n2 > 15000) {
                this.volatileHeight = 0;
                n2 = 0;
                this.overRideAcceleration = true;
            }
            if (n > 0 && n2 > 0) {
                this.backBuffer = this.pdf.createVolatileImage(n, n2);
                this.oldVolatileWidth = this.volatileWidth;
                this.oldVolatileHeight = this.volatileHeight;
                Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
                graphics2D.setPaint(this.pdf.getBackground());
                graphics2D.fillRect(0, 0, n, n2);
            }
        }
        catch (Error error) {
            this.overRideAcceleration = true;
            this.backBuffer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentDisplay.setOptimsePainting(true);
    }

    public boolean isAccelerated() {
        return this.useAcceleration && !this.overRideAcceleration;
    }

    public void resetCachedValues() {
        this.lastPageChecked = -1;
        this.lastState = -1;
    }

    public void stopGeneratingPage() {
        this.isGeneratingOtherPages = false;
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void disableScreen() {
        this.isInitialised = false;
    }

    boolean testAcceleratedRendering() {
        boolean bl = false;
        if (this.oldScaling != this.scaling || this.oldRotation != (float)this.displayRotation || this.oldVolatileWidth != (float)this.volatileWidth || this.oldVolatileHeight != (float)this.volatileHeight) {
            this.backBuffer = null;
            this.overRideAcceleration = false;
        }
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("acceleration called " + this.backBuffer);
        }
        if (!this.overRideAcceleration && this.backBuffer == null) {
            this.createBackBuffer();
            this.accleratedPagesAlreadyDrawn.clear();
        }
        if (this.backBuffer != null) {
            do {
                int n = 2;
                if (this.backBuffer != null) {
                    n = this.backBuffer.validate(this.pdf.getGraphicsConfiguration());
                }
                if (n != 1 && n == 2 && !this.overRideAcceleration) {
                    this.createBackBuffer();
                }
                if (this.backBuffer == null) continue;
                bl = true;
            } while (this.backBuffer == null || this.backBuffer.contentsLost());
        }
        return bl;
    }

    public Dimension getPageSize(int n) {
        int n2;
        int n3;
        Dimension dimension = null;
        int n4 = 0;
        if (n == 3 && this.pageW != null) {
            n3 = this.pageNumber;
            if ((n3 & 1) == 1) {
                --n3;
            }
            n2 = n3 + 1;
            if (this.displayRotation == 90 | this.displayRotation == 270) {
                n4 = this.pageW[n3];
                if (n2 < this.pageW.length && n4 < this.pageW[n2]) {
                    n4 = this.pageW[n2];
                }
            } else {
                n4 = this.pageH[n3];
                if (n2 < this.pageH.length && n4 < this.pageH[n2]) {
                    n4 = this.pageH[n2];
                }
            }
        }
        n3 = this.currentOffset.gaps;
        n2 = this.currentOffset.doubleGaps;
        switch (n) {
            case 3: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    dimension = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)n4 * this.scaling + (float)this.insetH + (float)this.insetH));
                    break;
                }
                dimension = new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)n4 * this.scaling + (float)this.insetH + (float)this.insetH));
                break;
            }
            case 2: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    dimension = new Dimension((int)((float)this.currentOffset.biggestHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalSingleWidth * this.scaling + (float)n3 + (float)this.insetH + (float)this.insetH));
                    break;
                }
                dimension = new Dimension((int)((float)this.currentOffset.biggestWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalSingleHeight * this.scaling + (float)n3 + (float)this.insetH + (float)this.insetH));
                break;
            }
            case 4: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    if (this.pageCount == 2) {
                        dimension = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.biggestWidth * this.scaling + (float)n3 + (float)this.insetH + (float)this.insetH));
                        break;
                    }
                    dimension = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalDoubleWidth * this.scaling + (float)n2 + (float)this.insetH + (float)this.insetH));
                    break;
                }
                dimension = this.pageCount == 2 ? new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.biggestHeight * this.scaling + (float)n3 + (float)this.insetH + (float)this.insetH)) : new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalDoubleHeight * this.scaling + (float)n2 + (float)this.insetH + (float)this.insetH));
            }
        }
        return dimension;
    }

    public Rectangle getDisplayedRectangle() {
        Rectangle rectangle = this.pdf.getVisibleRect();
        this.rx = rectangle.x;
        this.ry = rectangle.y;
        this.rw = rectangle.width;
        this.rh = rectangle.height;
        return rectangle;
    }

    public void drawBorder() {
        if (PdfDecoder.CURRENT_BORDER_STYLE == 1 && this.crw > 0 && this.crh > 0 && this.myBorder != null) {
            this.myBorder.paintBorder(this.pdf, this.g2, this.crx - 1, this.cry - 1, this.crw + 1, this.crh + 1);
        }
    }

    void setDisplacementOnG2(Graphics2D graphics2D) {
        float f = (float)this.crx / this.scaling;
        float f2 = (float)this.cry / this.scaling;
        if (this.displayRotation == 0 || this.displayView != 1) {
            graphics2D.translate(-f, f2);
        } else if (this.displayRotation == 90) {
            graphics2D.translate(-f2, -f);
        } else if (this.displayRotation == 180) {
            graphics2D.translate(f, -f2);
        } else if (this.displayRotation == 270) {
            graphics2D.translate(f2, f);
        }
    }

    protected void getPageView(PdfObject pdfObject, PdfObject pdfObject2, DynamicVectorRenderer dynamicVectorRenderer, int n) {
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.pdf.useHiResImageForDisplay);
        pdfStreamDecoder.setExternalImageRender(this.pdf.customImageHandler);
        pdfStreamDecoder.setName(this.pdf.filename);
        pdfStreamDecoder.setStore(this.pdf.objectStoreRef);
        dynamicVectorRenderer.setHiResImageForDisplayMode(this.pdf.useHiResImageForDisplay);
        try {
            pdfStreamDecoder.init(true, true, 7, 0, this.pageData, n, dynamicVectorRenderer, this.pdf.currentPdfFile);
            if (this.pdf.globalResources != null) {
                pdfStreamDecoder.readResources(this.pdf.globalResources, true);
            }
            if (pdfObject != null) {
                pdfStreamDecoder.readResources(pdfObject, true);
            }
            int n2 = this.pageData.getMediaBoxWidth(n);
            int n3 = this.pageData.getMediaBoxHeight(n);
            int n4 = this.pageData.getRotation(n);
            dynamicVectorRenderer.init(n2, n3, n4);
            pdfStreamDecoder.decodePageContent(pdfObject2, 0, 0, null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            this.pdf.decodeStatus = this.pdf.decodeStatus + "Error in decoding page " + error.toString();
            System.out.println(error);
        }
    }

    public void refreshDisplay() {
        this.screenNeedsRedrawing = true;
        this.accleratedPagesAlreadyDrawn.clear();
        this.overRideAcceleration = false;
    }

    public void flushPageCaches() {
        this.currentPageViews.clear();
        this.cachedPageViews.clear();
    }

    public void init(float f, int n, int n2, int n3, DynamicVectorRenderer dynamicVectorRenderer, boolean bl, PdfPageData pdfPageData, int n4, int n5) {
        this.currentDisplay = dynamicVectorRenderer;
        this.scaling = f;
        this.pageCount = n;
        this.displayRotation = n2;
        this.pageNumber = n3;
        this.pageData = pdfPageData;
        this.insetW = n4;
        this.insetH = n5;
        dynamicVectorRenderer.setInset(n4, n5);
        pdfPageData.setScalingValue(f);
        this.volatileWidth = pdfPageData.getScaledCropBoxWidth(this.pageNumber);
        this.volatileHeight = pdfPageData.getScaledCropBoxHeight(this.pageNumber);
        if (bl) {
            this.lastPageChecked = -1;
            this.setPageOffsets(n, this.pageNumber);
            this.isInitialised = true;
        }
    }

    public void setPageOffsets(int n, int n2) {
        int n3;
        int n4;
        if (this.displayView == 1) {
            return;
        }
        this.lastPageChecked = n2;
        this.lastState = this.displayView;
        this.xReached = new int[n + 1];
        this.yReached = new int[n + 1];
        this.pageW = new int[n + 1];
        this.pageH = new int[n + 1];
        int n5 = 0;
        int n6 = 0;
        this.isRotated = new boolean[n + 1];
        int n7 = 10;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n4 = 0; n4 < n + 1; ++n4) {
            this.pageW[n4] = this.pageData.getScaledCropBoxWidth(n4);
            this.pageH[n4] = this.pageData.getScaledCropBoxHeight(n4);
            n6 = this.pageData.getRotation(n4) + this.displayRotation;
            if (n6 >= 360) {
                n6 -= 360;
            }
            if (n6 == 90 || n6 == 270) {
                n3 = this.pageW[n4];
                this.pageW[n4] = this.pageH[n4];
                this.pageH[n4] = n3;
                this.isRotated[n4] = true;
            }
            if ((n4 & 1) == 1) {
                if (this.pageW[n4] > n10) {
                    n10 = this.pageW[n4];
                }
                if (this.pageH[n4] <= n11) continue;
                n11 = this.pageH[n4];
                continue;
            }
            if (this.pageW[n4] > n8) {
                n8 = this.pageW[n4];
            }
            if (this.pageH[n4] <= n9) continue;
            n9 = this.pageH[n4];
        }
        for (n4 = 1; n4 < n + 1; ++n4) {
            n5 = 0;
            if (n == 2 && (this.displayView == 3 || this.displayView == 4)) {
                if (n4 == 1) {
                    this.xReached[1] = 0;
                    this.yReached[1] = 0;
                    continue;
                }
                this.xReached[2] = this.xReached[1] + this.pageW[1] + n7;
                this.yReached[2] = 0;
                continue;
            }
            if (n4 == 1) {
                if (this.displayView == 2) {
                    this.xReached[1] = 0;
                    this.yReached[1] = 0;
                    continue;
                }
                if (this.displayView != 3 && this.displayView != 4) continue;
                if (this.isRotated[n4]) {
                    this.xReached[1] = n8 + n7;
                    this.yReached[1] = this.yReached[n4] = this.yReached[n4];
                    continue;
                }
                this.xReached[1] = n8 + n7;
                this.yReached[1] = 0;
                continue;
            }
            if (this.displayView == 4) {
                if ((n4 & 1) == 0) {
                    if (n4 < n) {
                        n5 = (this.pageH[n4 + 1] - this.pageH[n4]) / 2;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n4 > 3 && (n3 = (this.pageH[n4 - 2] - this.pageH[n4 - 1]) / 2) > 0) {
                        n5 += n3;
                    }
                    this.yReached[n4] = this.yReached[n4 - 1] + this.pageH[n4 - 1] + n7 + n5;
                } else {
                    n5 = (this.pageH[n4 - 1] - this.pageH[n4]) / 2;
                    this.yReached[n4] = this.yReached[n4 - 1] + n5;
                }
                if ((n4 & 1) == 0) {
                    this.xReached[n4] = this.xReached[n4] + (n8 - this.pageW[n4]);
                    continue;
                }
                this.xReached[n4] = this.xReached[n4 - 1] + this.pageW[n4 - 1] + n7;
                continue;
            }
            if (this.displayView == 2) {
                this.yReached[n4] = this.yReached[n4 - 1] + this.pageH[n4 - 1] + n7;
                if (!this.isRotated[n4]) continue;
                this.xReached[n4] = this.xReached[n4] - (n8 - this.pageW[n4]) / 2;
                continue;
            }
            if (this.displayView != 3) continue;
            if ((n4 & 1) == 1) {
                this.xReached[n4] = this.xReached[n4 - 1] + this.pageW[n4 - 1] + n7;
                if (this.pageH[n4] >= this.pageH[n4 - 1]) continue;
                this.yReached[n4] = this.yReached[n4] + (this.pageH[n4 - 1] - this.pageH[n4]) / 2;
                continue;
            }
            this.xReached[n4] = (n8 - this.pageW[n4]) / 2;
            if (n4 >= n || this.pageH[n4] >= this.pageH[n4 + 1]) continue;
            this.yReached[n4] = this.yReached[n4] + (this.pageH[n4 + 1] - this.pageH[n4]) / 2;
        }
        this.pdf.setMultiPageOffsets(this.xReached, this.yReached);
    }

    public void decodeOtherPages(int n, int n2) {
    }

    public void completeForm(Graphics2D graphics2D) {
        graphics2D.drawLine(this.crx, this.cry, this.crx + this.crw, this.cry + this.crh);
        graphics2D.drawLine(this.crx, this.crh + this.cry, this.crw + this.crx, this.cry);
    }

    public void resetToDefaultClip() {
        if (this.current2 != null) {
            this.g2.setTransform(this.current2);
        }
        if (this.currentClip != null) {
            this.g2.setClip(this.currentClip);
        }
    }

    public void initRenderer(Rectangle[] rectangleArray, Graphics2D graphics2D, Border border, int n) {
        this.rawAf = graphics2D.getTransform();
        this.rawClip = graphics2D.getClip();
        this.areas = rectangleArray;
        this.g2 = graphics2D;
        this.myBorder = border;
        this.indent = n;
        this.pagesDrawn.clear();
        this.setPageSize(this.pageNumber, this.scaling);
    }

    void setPageSize(int n, float f) {
        this.pageData.setScalingValue(f);
        this.topW = this.pageData.getScaledCropBoxWidth(n);
        this.topH = this.pageData.getScaledCropBoxHeight(n);
        double d = this.pageData.getScaledMediaBoxHeight(n);
        this.cropX = this.pageData.getScaledCropBoxX(n);
        this.cropY = this.pageData.getScaledCropBoxY(n);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int n2 = (int)(d - this.cropH);
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            this.crw = (int)this.cropH;
            this.crh = (int)this.cropW;
            int n3 = this.crx;
            this.crx = this.cry;
            this.cry = n3;
            this.crx += n2;
        } else {
            this.crw = (int)this.cropW;
            this.crh = (int)this.cropH;
            this.cry += n2;
        }
        this.g2.translate(this.insetW - this.crx, this.insetH - this.cry);
        this.current2 = this.g2.getTransform();
        this.currentClip = this.g2.getClip();
        this.g2.clip(new Rectangle(this.crx, this.cry, (int)((float)this.crw + ((float)(this.insetW * this.additionalPageCount) + (float)this.currentXOffset * f)), this.crh));
    }

    Rectangle calcVisibleArea(int n, int n2) {
        Rectangle rectangle;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.getDisplayedRectangle();
        if (this.displayRotation != 270 && this.displayRotation != 180 && this.rx > this.insetW) {
            n3 = (int)((float)(this.rx - this.insetW) / this.scaling);
        }
        int n6 = (int)((float)(this.rw + this.insetW) / this.scaling);
        int n7 = n;
        if (this.displayRotation == 0 || this.displayView != 1) {
            n3 = (int)((float)this.rx / this.scaling) - (int)((float)this.insetW / this.scaling);
            n7 = (int)((float)(this.rh + this.insetH) / this.scaling);
            n6 = (int)((float)(this.rw - this.insetW) / this.scaling) + (int)((float)this.insetW / this.scaling);
            if ((float)n3 < (float)this.insetW / this.scaling) {
                n3 = (int)((float)this.insetW / this.scaling);
            }
            if ((float)n4 < (float)this.insetH / this.scaling) {
                n4 = 0;
            }
            n4 = (int)((float)n - (float)(this.ry + this.rh) / this.scaling);
        } else if (this.displayRotation == 90) {
            n4 = (int)((float)(this.rx - this.insetW) / this.scaling);
            n7 = (int)((float)(this.rw + this.insetW) / this.scaling);
            n3 = this.ry > this.insetW ? (int)((float)(this.ry - this.insetW) / this.scaling) : 0;
            n6 = (int)((float)this.rh / this.scaling);
        } else if (this.displayRotation == 270) {
            n6 = (int)((float)(this.rh + this.insetW) / this.scaling);
            n3 = n2 - (int)((float)(this.ry + this.rh) / this.scaling);
            n7 = (int)((float)(this.rw + this.insetH) / this.scaling);
            n4 = n - (int)((float)(this.rx + this.rw) / this.scaling);
            if (n3 < this.insetH) {
                n3 = 0;
                n6 += this.insetH;
            }
            if (n4 < this.insetW) {
                n4 = 0;
                n7 += this.insetW;
            }
        } else if (this.displayRotation == 180) {
            n7 = (int)((float)(this.rh + this.insetH) / this.scaling) + this.insetH;
            n4 = (int)((float)(this.ry - this.insetH) / this.scaling);
            n6 = (int)((float)(this.rw + this.insetW) / this.scaling);
            n3 = n2 - (int)((float)(this.rx - this.insetW) / this.scaling);
            if ((n3 -= n6) < 0 || n3 < this.insetH) {
                n3 = 0;
                n6 += this.insetH;
            }
            if (n4 < this.insetW) {
                n4 = 0;
                n7 += this.insetW;
            }
        }
        if (this.isAccelerated() || this.scaling >= 2.0f) {
            int n8 = this.pageData.getScaledCropBoxX(this.pageNumber);
            int n9 = this.pageData.getScaledCropBoxY(this.pageNumber);
            n5 = 2;
            rectangle = n8 != 0 || n9 != 0 ? new Rectangle(n3 + (int)((float)n8 / this.scaling), n4 + (int)((float)n9 / this.scaling), n6, n7) : new Rectangle(n3, n4, n6 + (n5 + n5), n7 + (n5 + n5));
        } else {
            rectangle = null;
        }
        if (this.displayView != 1 && this.message) {
            this.message = true;
            System.out.println("SingleDisplay fast scrolling");
            rectangle = null;
        }
        return rectangle;
    }

    public Rectangle drawPage(AffineTransform affineTransform, AffineTransform affineTransform2, int n) {
        Rectangle rectangle = null;
        if (affineTransform2 != null && this.currentDisplay != null) {
            if (this.scaling < 2.0f && this.oldScaling > 2.0f) {
                this.useAcceleration = true;
            }
            if (this.useAcceleration || this.areas != null) {
                this.screenNeedsRedrawing = true;
            }
            boolean bl = false;
            if (this.useAcceleration && !this.overRideAcceleration && this.scaling < 2.0f) {
                bl = this.testAcceleratedRendering();
            } else {
                this.useAcceleration = false;
            }
            Rectangle rectangle2 = null;
            if (!this.isAccelerated()) {
                rectangle2 = this.calcVisibleArea((int)((float)this.topH / this.scaling), (int)((float)this.topW / this.scaling));
            }
            this.currentDisplay.setScalingValues(this.cropX, this.cropH + this.cropY, this.scaling);
            this.g2.transform(affineTransform2);
            if (DynamicVectorRenderer.debugPaint) {
                System.err.println("accelerate or redraw");
            }
            if (bl) {
                Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
                if (this.screenNeedsRedrawing) {
                    graphics2D.setColor(this.currentDisplay.getBackgroundColor());
                    graphics2D.fill(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                    this.currentDisplay.setOptimsePainting(true);
                    graphics2D.setTransform(affineTransform2);
                    this.setDisplacementOnG2(graphics2D);
                    rectangle = this.currentDisplay.paint(graphics2D, this.areas, affineTransform, rectangle2, false, true);
                    this.drawSpreadPages(graphics2D, affineTransform, rectangle2, false);
                    this.screenNeedsRedrawing = false;
                }
                graphics2D.dispose();
                if (this.backBuffer != null) {
                    AffineTransform affineTransform3 = this.g2.getTransform();
                    this.g2.setTransform(this.rawAf);
                    this.g2.drawImage(this.backBuffer, this.insetW, this.insetH, this.pdf);
                    this.g2.setTransform(affineTransform3);
                    rectangle = this.currentDisplay.paint(this.g2, this.areas, affineTransform, rectangle2, true, true);
                    this.drawSpreadPages(this.g2, affineTransform, rectangle2, true);
                }
            } else {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("standard paint called ");
                }
                this.g2.clip(new Rectangle((int)(this.cropX / (double)this.scaling), (int)(this.cropY / (double)this.scaling), (int)((float)this.topW / this.scaling), (int)((float)this.topH / this.scaling)));
                this.currentDisplay.setOptimsePainting(false);
                rectangle = this.currentDisplay.paint(this.g2, this.areas, affineTransform, rectangle2, false, true);
                this.drawSpreadPages(this.g2, affineTransform, rectangle2, false);
            }
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
        return rectangle;
    }

    private void drawSpreadPages(Graphics2D graphics2D, AffineTransform affineTransform, Rectangle rectangle, boolean bl) {
        if (this.currentXOffset > 0) {
            int[] nArray = this.offsets.get();
            int n = nArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = nArray[i];
                if (n2 <= 0) continue;
                DynamicVectorRenderer dynamicVectorRenderer = (DynamicVectorRenderer)this.newPages.get(new Integer(n2));
                graphics2D.setClip(null);
                graphics2D.translate(n2, 0);
                if (dynamicVectorRenderer != null) {
                    dynamicVectorRenderer.paint(graphics2D, this.areas, affineTransform, rectangle, bl, true);
                }
                graphics2D.translate(-n2, 0);
            }
        }
    }

    public void setup(boolean bl, PageOffsets pageOffsets, PdfDecoder pdfDecoder) {
        this.useAcceleration = bl;
        this.currentOffset = pageOffsets;
        this.pdf = pdfDecoder;
        this.overRideAcceleration = false;
    }

    public int getXCordForPage(int n) {
        return this.xReached[n] + this.insetW;
    }

    public int getYCordForPage(int n) {
        return this.yReached[n] + this.insetH;
    }

    public int getStartPage() {
        return this.startViewPage;
    }

    public int getEndPage() {
        return this.endViewPage;
    }

    public boolean isDecoding() {
        return this.running;
    }

    public void setThumbnailsDrawing(boolean bl) {
        this.thumbnailsRunning = bl;
    }

    public void setThumbnailPanel(GUIThumbnailPanel gUIThumbnailPanel) {
        this.thumbnails = gUIThumbnailPanel;
    }

    public void setScaling(float f) {
        this.scaling = f;
        this.pageData.setScalingValue(f);
    }
}

