/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.PixelFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.PdfDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;

public class RadialContext
implements PaintContext {
    GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private boolean[] isExtended;
    private float x0 = 0.0f;
    private float x1 = 0.0f;
    private float y0 = 0.0f;
    private float y1 = 0.0f;
    private float r0;
    private float r1;
    private float t0 = 0.0f;
    private float t1 = 1.0f;
    private PDFFunction function;
    private float[] cx;
    private float[] cy;
    private float[] cr;
    private float[] crSquared;
    private Color[] circleColor;
    private int xstart;
    private int ystart;
    private int circleCount;
    boolean isCone;
    private boolean circlesInitialised = false;
    private int pageHeight;
    private int minX;
    private float[] background;
    private boolean colorsReversed;
    private boolean isPrinting;
    private int offX;
    private int offY;
    float pdfX = 0.0f;
    float pdfY = 0.0f;

    public RadialContext(boolean bl, int n, int n2, int n3, int n4, float f, boolean[] blArray, float[] fArray, float[] fArray2, GenericColorSpace genericColorSpace, boolean bl2, float[] fArray3, PDFFunction pDFFunction) {
        this.offX = n;
        this.offY = n2;
        this.isPrinting = bl;
        this.pageHeight = n4;
        this.isExtended = blArray;
        this.t0 = fArray[0];
        this.t1 = fArray[1];
        this.minX = n3;
        this.background = fArray3;
        this.colorsReversed = bl2;
        this.x0 = fArray2[0];
        this.x1 = fArray2[3];
        this.r0 = fArray2[2];
        this.y0 = fArray2[1];
        this.y1 = fArray2[4];
        this.r1 = fArray2[5];
        this.shadingColorSpace = genericColorSpace;
        this.function = pDFFunction;
        this.scaling = f;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.xstart = n;
        this.ystart = n2;
        if (!this.circlesInitialised) {
            this.circlesInitialised = true;
            this.initialiseCircles();
        }
        WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        if (this.background != null) {
            for (n6 = 0; n6 < n4; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    this.shadingColorSpace.setColor(this.background, 4);
                    Color color = (Color)((Object)this.shadingColorSpace.getColor());
                    int n7 = (n6 * n3 + n5) * 4;
                    nArray[n7] = color.getRed();
                    nArray[n7 + 1] = color.getGreen();
                    nArray[n7 + 2] = color.getBlue();
                    nArray[n7 + 3] = 255;
                }
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            for (n5 = 0; n5 < n3; ++n5) {
                int n8 = this.calculateColor(n5, n6);
                if (n8 < 0) continue;
                this.setColor(n3, nArray, n6, n5, n8);
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private void setColor(int n, int[] nArray, int n2, int n3, int n4) {
        Color color = this.circleColor[n4];
        int n5 = color.getRed();
        int n6 = color.getGreen();
        int n7 = color.getBlue();
        int n8 = (n2 * n + n3) * 4;
        nArray[n8] = n5;
        nArray[n8 + 1] = n6;
        nArray[n8 + 2] = n7;
        nArray[n8 + 3] = 255;
    }

    private int calculateColor(float f, float f2) {
        int n;
        block7: {
            int n2;
            float f3;
            block8: {
                if (PdfDecoder.isRunningOnMac) {
                    f += (float)this.xstart;
                    f2 += (float)this.ystart;
                } else {
                    n = (int)f;
                    int n3 = (int)f2;
                    if (this.isPrinting) {
                        this.pdfX = this.scaling * (f + (float)this.xstart + (float)this.minX);
                        this.pdfY = this.scaling * ((float)this.pageHeight - (f2 + (float)this.ystart));
                    } else {
                        this.pdfX = this.scaling * (f + (float)this.xstart + (float)this.minX);
                        this.pdfY = this.scaling * ((float)this.pageHeight - (f2 + (float)this.ystart));
                    }
                    float[] fArray = PixelFactory.convertPhysicalToPDF(this.isPrinting, this.pdfX, this.pdfY, f, f2, this.offX, this.offY, this.scaling, this.xstart, this.ystart, this.minX, this.pageHeight);
                    this.pdfX = fArray[0];
                    this.pdfY = fArray[1];
                }
                n = -1;
                f3 = 0.0f;
                for (n2 = this.circleCount; n2 > 0; --n2) {
                    f3 = (this.pdfX - this.cx[n2]) * (this.pdfX - this.cx[n2]) + (this.pdfY - this.cy[n2]) * (this.pdfY - this.cy[n2]);
                    if (!(f3 <= this.crSquared[n2] && f3 >= this.crSquared[n2 - 1]) && (!(f3 >= this.crSquared[n2]) || !(f3 <= this.crSquared[n2 - 1]))) continue;
                    n = n2;
                    break;
                }
                if (!(this.cr[0] < this.cr[1])) break block8;
                if (n != -1) break block7;
                for (n2 = 0; n2 < this.circleCount; ++n2) {
                    f3 = (this.pdfX - this.cx[n2]) * (this.pdfX - this.cx[n2]) + (this.pdfY - this.cy[n2]) * (this.pdfY - this.cy[n2]);
                    float f4 = (this.pdfX - this.cx[n2 + 1]) * (this.pdfX - this.cx[n2 + 1]) + (this.pdfY - this.cy[n2 + 1]) * (this.pdfY - this.cy[n2 + 1]);
                    if (!(f3 > this.crSquared[n2]) || !(f4 < this.crSquared[n2 + 1])) continue;
                    n = n2;
                    break block7;
                }
                break block7;
            }
            for (n2 = this.circleCount; n2 > 0; --n2) {
                f3 = (this.pdfX - this.cx[n2]) * (this.pdfX - this.cx[n2]) + (this.pdfY - this.cy[n2]) * (this.pdfY - this.cy[n2]);
                float f5 = (this.pdfX - this.cx[n2 - 1]) * (this.pdfX - this.cx[n2 - 1]) + (this.pdfY - this.cy[n2 - 1]) * (this.pdfY - this.cy[n2 - 1]);
                if (!(f3 > this.crSquared[n2]) || !(f5 < this.crSquared[n2 - 1])) continue;
                n = n2;
                break;
            }
        }
        return n;
    }

    private void initialiseCircles() {
        int n;
        Color[] colorArray;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        float f;
        boolean bl;
        this.circleCount = 100;
        ++this.circleCount;
        this.cx = new float[this.circleCount];
        this.cy = new float[this.circleCount];
        this.cr = new float[this.circleCount];
        this.crSquared = new float[this.circleCount];
        this.circleColor = new Color[this.circleCount];
        --this.circleCount;
        float f2 = this.t1 - this.t0;
        float f3 = this.x1 - this.x0;
        float f4 = this.y1 - this.y0;
        float f5 = this.r1 - this.r0;
        boolean bl2 = this.x0 - this.r0 > this.x1 - this.r1 && this.x0 + this.r0 < this.x1 + this.r1 && this.y0 - this.r0 > this.y1 - this.r1 && this.y0 + this.r0 < this.y1 + this.r1;
        boolean bl3 = bl = this.x1 - this.r1 > this.x0 - this.r0 && this.x1 + this.r1 < this.x0 + this.r0 && this.y1 - this.r1 > this.y0 - this.r0 && this.y1 + this.r1 < this.y0 + this.r0;
        if (!bl2 && !bl) {
            this.isCone = true;
        }
        int n2 = 0;
        float f6 = this.t0;
        while (true) {
            f6 = (this.t1 - this.t0) * (float)n2 / (float)this.circleCount;
            f = (f6 - this.t0) / f2;
            this.cx[n2] = this.x0 + f * f3;
            this.cy[n2] = this.y0 + f * f4;
            this.cr[n2] = this.r0 + f * f5;
            this.crSquared[n2] = this.cr[n2] * this.cr[n2];
            this.circleColor[n2] = this.colorsReversed ? this.calculateColor(1.0f - f6, this.t0, this.t1) : this.calculateColor(f6, this.t0, this.t1);
            if (n2 == this.circleCount) break;
            ++n2;
        }
        if (this.isExtended[0]) {
            n2 = 0;
            f6 = (this.t1 - this.t0) * (float)n2 / (float)this.circleCount;
            f = (f6 - this.t0) / f2;
            if (this.cr[0] < this.cr[1]) {
                while (this.r0 + f * f5 > 0.0f) {
                    f6 = (this.t1 - this.t0) * (float)(-n2) / (float)this.circleCount;
                    f = (f6 - this.t0) / f2;
                    ++n2;
                }
            } else {
                while (this.r0 + f * f5 < 500.0f) {
                    f6 = (this.t1 - this.t0) * (float)(-n2) / (float)this.circleCount;
                    f = (f6 - this.t0) / f2;
                    ++n2;
                }
            }
            if (n2 != 0) {
                fArray4 = new float[n2];
                fArray3 = new float[n2];
                fArray2 = new float[n2];
                fArray = new float[n2];
                colorArray = new Color[n2];
                --n2;
                n = 0;
                while (n2 >= 0) {
                    f6 = (this.t1 - this.t0) * (float)(-n2) / (float)this.circleCount;
                    f = (f6 - this.t0) / f2;
                    fArray4[n] = this.x0 + f * f3;
                    fArray3[n] = this.y0 + f * f4;
                    fArray2[n] = this.r0 + f * f5;
                    fArray[n] = fArray2[n] * fArray2[n];
                    colorArray[n] = this.circleColor[0];
                    ++n;
                    --n2;
                }
                this.cx = this.concat(fArray4, this.cx);
                this.cy = this.concat(fArray3, this.cy);
                this.cr = this.concat(fArray2, this.cr);
                this.crSquared = this.concat(fArray, this.crSquared);
                this.circleColor = this.concat(colorArray, this.circleColor);
                this.circleCount = this.cx.length - 1;
            }
        }
        if (this.isExtended[1]) {
            n2 = this.circleCount + 1;
            if (this.cr[0] > this.cr[1]) {
                while (this.r0 + f * f5 > 0.0f) {
                    f6 = (this.t1 - this.t0) * (float)n2 / (float)this.circleCount;
                    f = (f6 - this.t0) / f2;
                    ++n2;
                }
            } else {
                while (this.r0 + f * f5 < 500.0f) {
                    f6 = (this.t1 - this.t0) * (float)n2 / (float)this.circleCount;
                    f = (f6 - this.t0) / f2;
                    ++n2;
                }
            }
            fArray4 = new float[n2 - (this.circleCount + 1)];
            fArray3 = new float[n2 - (this.circleCount + 1)];
            fArray2 = new float[n2 - (this.circleCount + 1)];
            fArray = new float[n2 - (this.circleCount + 1)];
            colorArray = new Color[n2 - (this.circleCount + 1)];
            n = --n2 - (this.circleCount + 1);
            while (n2 > this.circleCount) {
                f6 = (this.t1 - this.t0) * (float)n2 / (float)this.circleCount;
                f = (f6 - this.t0) / f2;
                fArray4[n] = this.x0 + f * f3;
                fArray3[n] = this.y0 + f * f4;
                fArray2[n] = this.r0 + f * f5;
                fArray[n] = fArray2[n] * fArray2[n];
                colorArray[n] = this.circleColor[this.circleCount];
                --n;
                --n2;
            }
            this.cx = this.concat(this.cx, fArray4);
            this.cy = this.concat(this.cy, fArray3);
            this.cr = this.concat(this.cr, fArray2);
            this.crSquared = this.concat(this.crSquared, fArray);
            this.circleColor = this.concat(this.circleColor, colorArray);
            this.circleCount = this.cx.length - 1;
        }
    }

    private Color calculateColor(float f, float f2, float f3) {
        float[] fArray = new float[]{f};
        float[] fArray2 = this.function.compute(fArray);
        this.shadingColorSpace.setColor(fArray2, fArray2.length);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }

    private float[] concat(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    private Color[] concat(Color[] colorArray, Color[] colorArray2) {
        Color[] colorArray3 = new Color[colorArray.length + colorArray2.length];
        System.arraycopy(colorArray, 0, colorArray3, 0, colorArray.length);
        System.arraycopy(colorArray2, 0, colorArray3, colorArray.length, colorArray2.length);
        return colorArray3;
    }
}

