/*
 * Decompiled with CFR 0.152.
 */
package com.naryx.tagfusion.cfx;

import com.allaire.cfx.Request;
import com.allaire.cfx.Response;
import com.naryx.tagfusion.cfx.Token;
import com.naryx.tagfusion.cfx.sessionRequest;
import com.naryx.tagfusion.cfx.sessionResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import railo.loader.util.Util;

public class CFXNativeLib {
    private static final String NATIVE_PATH_32 = "com/naryx/tagfusion/cfx/native/";
    private static final String NATIVE_PATH_64 = "com/naryx/tagfusion/cfx/native/x64/";

    static {
        String nativeLibName = null;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            nativeLibName = "CFXNativeLib.dll";
        } else if (osName.startsWith("Linux")) {
            nativeLibName = "CFXNativeLib-linux.so";
        } else if (osName.startsWith("SunOS")) {
            nativeLibName = "CFXNativeLib-solaris.so";
        } else if (osName.startsWith("Mac")) {
            nativeLibName = "CFXNativeLib-macosx.so";
        }
        if (nativeLibName != null) {
            File nativeLib = null;
            try {
                nativeLib = CFXNativeLib.getNativeLibFile(nativeLibName);
                if (nativeLib != null) {
                    System.load(nativeLib.getCanonicalPath());
                    CFXNativeLib.out("-] Loaded CFXNativeLib >> [" + nativeLib + "]");
                }
            }
            catch (Throwable t) {
                CFXNativeLib.error("-] Failed to load CFXNativeLib [" + nativeLib + "] C++ CFXs disabled");
                CFXNativeLib.error("-] " + t.getMessage());
            }
        } else {
            CFXNativeLib.error("-] Unknown operating system [" + osName + "] - C++ CFXs disabled");
        }
    }

    private static File getNativeLibFile(String nativeLibName) throws IOException {
        String strPath = System.getProperty("cfx.bin.path");
        File file = null;
        if (strPath == null || strPath.trim().length() == 0) {
            CFXNativeLib.error("-] missing system property \"cfx.bin.path\"");
        } else {
            String prefix;
            String src;
            File path = new File(strPath);
            String arch = System.getProperty("os.arch");
            if (arch != null && arch.indexOf("64") != -1) {
                src = NATIVE_PATH_64 + nativeLibName;
                prefix = "x64";
            } else {
                src = NATIVE_PATH_32 + nativeLibName;
                prefix = "";
            }
            file = new File(path, String.valueOf(prefix) + nativeLibName);
            if (!file.exists()) {
                InputStream is = new Token().getClass().getClassLoader().getResourceAsStream(src);
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    CFXNativeLib.copy(is, fos);
                }
                finally {
                    CFXNativeLib.closeEL(is);
                    CFXNativeLib.closeEL(fos);
                }
            }
        }
        return file;
    }

    private static long length(String dest) {
        InputStream is = new Token().getClass().getClassLoader().getResourceAsStream(dest);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try {
                Util.copy((InputStream)is, (OutputStream)baos);
            }
            catch (IOException iOException) {
                Util.closeEL((InputStream)is);
                return -1L;
            }
        }
        finally {
            Util.closeEL((InputStream)is);
        }
        return baos.size();
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    private static void closeEL(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void closeEL(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void out(String msg) {
        System.out.println(msg);
    }

    private static void error(String msg) {
        System.err.println(msg);
    }

    public static void main(String[] args) {
        System.setProperty("cfx.bin.path", "/Users/mic/Temp/");
        new CFXNativeLib();
    }

    public static native void processRequest(String var0, String var1, sessionRequest var2, sessionResponse var3, boolean var4) throws Exception;

    public static void processRequest(String moduleName, String functionName, Request req, Response rsp, boolean keepLibraryLoaded) throws Exception {
        CFXNativeLib.processRequest(moduleName, functionName, new sessionRequest(req), new sessionResponse(rsp), keepLibraryLoaded);
    }
}

