/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.pdfbox.afmparser.AFMParser;
import org.pdfbox.afmtypes.FontMetric;
import org.pdfbox.cmapparser.CMapParser;
import org.pdfbox.cmaptypes.CMap;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.encoding.AFMEncoding;
import org.pdfbox.encoding.DictionaryEncoding;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.encoding.EncodingManager;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDMatrix;
import org.pdfbox.util.ResourceLoader;

public abstract class PDFont
implements COSObjectable {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$pdmodel$font$PDFont == null ? (class$org$pdfbox$pdmodel$font$PDFont = PDFont.class$("org.pdfbox.pdmodel.font.PDFont")) : class$org$pdfbox$pdmodel$font$PDFont));
    protected COSDictionary font;
    private Encoding fontEncoding = null;
    private CMap cmap = null;
    private static Map afmResources = null;
    private static Map cmapObjects = null;
    private static Map afmObjects = null;
    private static Map cmapSubstitutions = null;
    private static final String[] SINGLE_CHAR_STRING;
    private static final String[][] DOUBLE_CHAR_STRING;
    static /* synthetic */ Class class$org$pdfbox$pdmodel$font$PDFont;

    public static void clearResources() {
        afmObjects.clear();
        cmapObjects.clear();
    }

    public PDFont() {
        this.font = new COSDictionary();
        this.font.setItem(COSName.TYPE, (COSBase)COSName.FONT);
    }

    public PDFont(COSDictionary fontDictionary) {
        this.font = fontDictionary;
    }

    public COSBase getCOSObject() {
        return this.font;
    }

    public abstract float getFontWidth(byte[] var1, int var2, int var3) throws IOException;

    public float getStringWidth(String string) throws IOException {
        byte[] data = string.getBytes();
        float totalWidth = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            totalWidth += this.getFontWidth(data, i, 1);
        }
        return totalWidth;
    }

    public abstract float getAverageFontWidth() throws IOException;

    public abstract void drawString(String var1, Graphics var2, float var3, float var4, float var5, float var6, float var7) throws IOException;

    protected int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code <<= 8;
            code = (data[offset + i] + 256) % 256;
        }
        return code;
    }

    protected float getFontWidthFromAFMFile(int code) throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            Encoding encoding = this.getEncoding();
            COSName characterName = encoding.getName(code);
            retval = metric.getCharacterWidth(characterName.getName());
        }
        return retval;
    }

    protected float getAverageFontWidthFromAFMFile() throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            retval = metric.getAverageCharacterWidth();
        }
        return retval;
    }

    protected FontMetric getAFM() throws IOException {
        COSName name = (COSName)this.font.getDictionaryObject(COSName.BASE_FONT);
        FontMetric result = null;
        if (name != null && (result = (FontMetric)afmObjects.get(name)) == null) {
            String resource = (String)afmResources.get(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("resource: " + resource + ", name: " + name.getName()));
            }
            if (resource == null) {
                log.debug((Object)"resource is null");
            } else {
                InputStream afmStream = ResourceLoader.loadResource(resource);
                if (afmStream == null) {
                    throw new IOException("Can't handle font width:" + resource);
                }
                AFMParser parser = new AFMParser(afmStream);
                parser.parse();
                result = parser.getResult();
                afmObjects.put(name, result);
            }
        }
        return result;
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        COSObjectable encoding;
        String retval = null;
        COSName fontSubtype = (COSName)this.font.getDictionaryObject(COSName.SUBTYPE);
        if ((fontSubtype.getName().equals("Type0") || fontSubtype.getName().equals("Type1") || fontSubtype.getName().equals("TrueType")) && this.cmap == null) {
            if (this.font.getDictionaryObject(COSName.TO_UNICODE) != null) {
                COSStream toUnicode = (COSStream)this.font.getDictionaryObject(COSName.TO_UNICODE);
                if (toUnicode != null) {
                    this.parseCmap(toUnicode.getUnfilteredStream(), null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Getting embedded CMAP Stream from ToUnicode");
                    }
                }
            } else {
                encoding = this.font.getDictionaryObject(COSName.ENCODING);
                if (encoding instanceof COSStream) {
                    COSStream encodingStream = (COSStream)encoding;
                    this.parseCmap(encodingStream.getUnfilteredStream(), null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Getting embedded CMAP Stream from encoding");
                    }
                } else if (fontSubtype.getName().equals("Type0") && encoding instanceof COSName) {
                    COSName encodingName = (COSName)encoding;
                    this.cmap = (CMap)cmapObjects.get(encodingName);
                    if (this.cmap != null) {
                        this.cmap = (CMap)cmapObjects.get(encodingName);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Getting CMAP Stream from resource");
                        }
                        String cmapName = encodingName.getName();
                        cmapName = this.performCMAPSubstitution(cmapName);
                        String resourceName = "Resources/cmap/" + cmapName;
                        this.parseCmap(ResourceLoader.loadResource(resourceName), encodingName);
                        if (this.cmap == null && !encodingName.getName().equals(COSName.IDENTITY_H.getName())) {
                            throw new IOException("Error: Could not find predefined CMAP file for '" + encodingName.getName() + "'");
                        }
                    }
                } else if (encoding instanceof COSName || encoding instanceof COSDictionary) {
                    Encoding currentFontEncoding = this.getEncoding();
                    if (currentFontEncoding != null) {
                        retval = currentFontEncoding.getCharacter(this.getCodeFromArray(c, offset, length));
                    }
                } else {
                    COSDictionary fontDescriptor = (COSDictionary)this.font.getDictionaryObject(COSName.getPDFName("FontDescriptor"));
                    if (fontSubtype.getName().equals("TrueType") && fontDescriptor != null && (fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile")) != null || fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile2")) != null || fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile3")) != null)) {
                        retval = PDFont.getStringFromArray(c, offset, length);
                    }
                }
            }
        }
        log.debug((Object)("retval=" + retval + " cmap=" + this.cmap));
        if (retval == null && this.cmap != null) {
            retval = this.cmap.lookup(c, offset, length);
            if (log.isDebugEnabled()) {
                log.debug((Object)("cmap.lookup(" + c + ")='" + retval + "'"));
            }
        }
        if (!(retval != null || length != 1 || this.cmap != null && this.cmap.hasTwoByteMappings())) {
            log.debug((Object)"No CMAP: Using fallback method");
            encoding = this.getEncoding();
            if (encoding != null) {
                retval = ((Encoding)encoding).getCharacter(this.getCodeFromArray(c, offset, length));
            }
            if (retval == null) {
                retval = PDFont.getStringFromArray(c, offset, length);
            }
        }
        return retval;
    }

    private static String getStringFromArray(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        if (length == 1) {
            retval = SINGLE_CHAR_STRING[(c[offset] + 256) % 256];
        } else if (length == 2) {
            retval = DOUBLE_CHAR_STRING[(c[offset] + 256) % 256][(c[offset + 1] + 256) % 256];
        } else {
            throw new IOException("Error:Unknown character length:" + length);
        }
        return retval;
    }

    private String performCMAPSubstitution(String cmapName) {
        String retval = (String)cmapSubstitutions.get(cmapName);
        if (retval == null) {
            retval = cmapName;
        }
        return retval;
    }

    private void parseCmap(InputStream cmapStream, COSName encodingName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing a new CMAP for font:" + this.font));
        }
        if (cmapStream != null) {
            CMapParser parser = new CMapParser(cmapStream, null);
            parser.parse();
            this.cmap = parser.getResult();
            if (encodingName != null) {
                cmapObjects.put(encodingName, this.cmap);
            }
        }
    }

    public void setEncoding(Encoding enc) {
        this.font.setItem(COSName.ENCODING, (COSObjectable)enc);
        this.fontEncoding = enc;
    }

    public Encoding getEncoding() throws IOException {
        EncodingManager manager = new EncodingManager();
        if (this.fontEncoding == null) {
            COSBase encoding = this.font.getDictionaryObject(COSName.ENCODING);
            if (encoding == null) {
                FontMetric metric = this.getAFM();
                if (metric != null) {
                    this.fontEncoding = new AFMEncoding(metric);
                }
                if (this.fontEncoding == null) {
                    this.fontEncoding = manager.getStandardEncoding();
                }
            } else if (encoding instanceof COSDictionary) {
                COSDictionary encodingDic = (COSDictionary)encoding;
                COSName baseEncodingName = (COSName)encodingDic.getDictionaryObject(COSName.BASE_ENCODING);
                if (baseEncodingName == null) {
                    COSName fontEncodingFromFile = this.getEncodingFromFont();
                    encodingDic.setItem(COSName.BASE_ENCODING, (COSBase)fontEncodingFromFile);
                }
                this.fontEncoding = new DictionaryEncoding(encodingDic);
            } else if (encoding instanceof COSName) {
                if (!encoding.equals(COSName.IDENTITY_H)) {
                    this.fontEncoding = manager.getEncoding((COSName)encoding);
                }
            } else {
                throw new IOException("Unexpected encoding type:" + encoding.getClass().getName());
            }
        }
        return this.fontEncoding;
    }

    public String getType() {
        return this.font.getNameAsString("Type");
    }

    public String getSubType() {
        return this.font.getNameAsString("Subtype");
    }

    public String getBaseFont() {
        return this.font.getNameAsString("BaseFont");
    }

    public void setBaseFont(String baseFont) {
        this.font.setName("BaseFont", baseFont);
    }

    public int getFirstChar() {
        return this.font.getInt("FirstChar", -1);
    }

    public void setFirstChar(int firstChar) {
        this.font.setInt("FirstChar", firstChar);
    }

    public int getLastChar() {
        return this.font.getInt("LastChar", -1);
    }

    public void setLastChar(int lastChar) {
        this.font.setInt("LastChar", lastChar);
    }

    public List getWidths() {
        COSArray array = (COSArray)this.font.getDictionaryObject("Widths");
        return COSArrayList.convertFloatCOSArrayToList(array);
    }

    public void setWidths(List widths) {
        this.font.setItem("Widths", (COSBase)COSArrayList.converterToCOSArray(widths));
    }

    public PDMatrix getFontMatrix() {
        PDMatrix matrix = null;
        COSArray array = (COSArray)this.font.getDictionaryObject("FontMatrix");
        if (array == null) {
            array = new COSArray();
            array.add(new COSFloat(0.001f));
            array.add(COSNumber.ZERO);
            array.add(COSNumber.ZERO);
            array.add(new COSFloat(0.001f));
            array.add(COSNumber.ZERO);
            array.add(COSNumber.ZERO);
        }
        matrix = new PDMatrix(array);
        return matrix;
    }

    private COSName getEncodingFromFont() throws IOException {
        COSStream fontFile;
        COSName retvalue = null;
        COSDictionary fontDescriptor = (COSDictionary)this.font.getDictionaryObject(COSName.getPDFName("FontDescriptor"));
        if (fontDescriptor != null && (fontFile = (COSStream)fontDescriptor.getDictionaryObject(COSName.getPDFName("FontFile"))) != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(fontFile.getUnfilteredStream()));
            StringTokenizer st = null;
            boolean found = false;
            String line = "";
            String key = null;
            for (int i = 0; null != (line = in.readLine()) && i < 40 && !line.equals("currentdict end") && !found; ++i) {
                st = new StringTokenizer(line);
                if (!st.hasMoreTokens() || !(key = st.nextToken()).equals("/Encoding") || !st.hasMoreTokens()) continue;
                COSName value = COSName.getPDFName(st.nextToken());
                found = true;
                if (!value.equals(COSName.MAC_ROMAN_ENCODING) && !value.equals(COSName.PDF_DOC_ENCODING) && !value.equals(COSName.STANDARD_ENCODING) && !value.equals(COSName.WIN_ANSI_ENCODING)) continue;
                retvalue = value;
            }
        }
        return retvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        afmResources = Collections.synchronizedMap(new HashMap());
        cmapObjects = Collections.synchronizedMap(new HashMap());
        afmObjects = Collections.synchronizedMap(new HashMap());
        cmapSubstitutions = Collections.synchronizedMap(new HashMap());
        afmResources.put(COSName.getPDFName("Courier-Bold"), "Resources/afm/Courier-Bold.afm");
        afmResources.put(COSName.getPDFName("Courier-BoldOblique"), "Resources/afm/Courier-BoldOblique.afm");
        afmResources.put(COSName.getPDFName("Courier"), "Resources/afm/Courier.afm");
        afmResources.put(COSName.getPDFName("Courier-Oblique"), "Resources/afm/Courier-Oblique.afm");
        afmResources.put(COSName.getPDFName("Helvetica"), "Resources/afm/Helvetica.afm");
        afmResources.put(COSName.getPDFName("Helvetica-Bold"), "Resources/afm/Helvetica-Bold.afm");
        afmResources.put(COSName.getPDFName("Helvetica-BoldOblique"), "Resources/afm/Helvetica-BoldOblique.afm");
        afmResources.put(COSName.getPDFName("Helvetica-Oblique"), "Resources/afm/Helvetica-Oblique.afm");
        afmResources.put(COSName.getPDFName("Symbol"), "Resources/afm/Symbol.afm");
        afmResources.put(COSName.getPDFName("Times-Bold"), "Resources/afm/Times-Bold.afm");
        afmResources.put(COSName.getPDFName("Times-BoldItalic"), "Resources/afm/Times-BoldItalic.afm");
        afmResources.put(COSName.getPDFName("Times-Italic"), "Resources/afm/Times-Italic.afm");
        afmResources.put(COSName.getPDFName("Times-Roman"), "Resources/afm/Times-Roman.afm");
        afmResources.put(COSName.getPDFName("ZapfDingbats"), "Resources/afm/ZapfDingbats.afm");
        cmapSubstitutions.put("ETenms-B5-H", "ETen-B5-H");
        cmapSubstitutions.put("ETenms-B5-V", "ETen-B5-V");
        SINGLE_CHAR_STRING = new String[256];
        DOUBLE_CHAR_STRING = new String[256][256];
        for (int i = 0; i < 256; ++i) {
            PDFont.SINGLE_CHAR_STRING[i] = new String(new byte[]{(byte)i});
            for (int j = 0; j < 256; ++j) {
                PDFont.DOUBLE_CHAR_STRING[i][j] = new String(new byte[]{(byte)i, (byte)j});
            }
        }
    }
}

