/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTATransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger((Class)JTATransaction.class);
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private UserTransaction userTransaction;
    private boolean newTransaction;
    private boolean begun;
    private boolean commitFailed;
    private boolean commitSucceeded;
    private boolean callback;
    private static final int NULL = Integer.MIN_VALUE;

    public JTATransaction(UserTransaction userTransaction, JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
        this.userTransaction = userTransaction;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        if (this.commitFailed) {
            throw new TransactionException("cannot re-start transaction after failed commit");
        }
        log.debug("begin");
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
                log.debug("Began a new JTA transaction");
            }
        }
        catch (Exception e) {
            log.error("JTA transaction begin failed", (Throwable)e);
            throw new TransactionException("JTA transaction begin failed", e);
        }
        boolean synchronization = this.jdbcContext.registerSynchronizationIfPossible();
        if (!this.newTransaction && !synchronization) {
            log.warn("You should set hibernate.transaction.manager_lookup_class if cache is enabled");
        }
        if (!synchronization) {
            this.callback = this.jdbcContext.registerCallbackIfNecessary();
        }
        this.begun = true;
        this.commitSucceeded = false;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean flush;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("commit");
        boolean bl = flush = !this.transactionContext.isFlushModeNever() && (this.callback || !this.transactionContext.isFlushBeforeCompletionEnabled());
        if (flush) {
            this.transactionContext.managedFlush();
        }
        if (this.callback && this.newTransaction) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        this.closeIfRequired();
        if (this.newTransaction) {
            try {
                this.userTransaction.commit();
                this.commitSucceeded = true;
                log.debug("Committed JTA UserTransaction");
            }
            catch (Exception e) {
                this.commitFailed = true;
                log.error("JTA commit failed", (Throwable)e);
                throw new TransactionException("JTA commit failed: ", e);
            }
            finally {
                this.afterCommitRollback();
            }
        } else {
            this.afterCommitRollback();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun && !this.commitFailed) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("rollback");
        try {
            this.closeIfRequired();
        }
        catch (Exception e) {
            log.error("could not close session during rollback", (Throwable)e);
        }
        try {
            if (this.newTransaction) {
                if (!this.commitFailed) {
                    this.userTransaction.rollback();
                    log.debug("Rolled back JTA UserTransaction");
                }
            } else {
                this.userTransaction.setRollbackOnly();
                log.debug("set JTA UserTransaction to rollback only");
            }
        }
        catch (Exception e) {
            log.error("JTA rollback failed", (Throwable)e);
            throw new TransactionException("JTA rollback failed", e);
        }
        finally {
            this.afterCommitRollback();
        }
    }

    private void afterCommitRollback() throws TransactionException {
        this.begun = false;
        if (this.callback) {
            if (!this.newTransaction) {
                log.warn("You should set hibernate.transaction.manager_lookup_class if cache is enabled");
            }
            int status = Integer.MIN_VALUE;
            try {
                status = this.userTransaction.getStatus();
                this.jdbcContext.afterTransactionCompletion(status == 3, this);
            }
            catch (Exception e) {
                try {
                    log.error("Could not determine transaction status after commit", (Throwable)e);
                    throw new TransactionException("Could not determine transaction status after commit", e);
                }
                catch (Throwable throwable) {
                    this.jdbcContext.afterTransactionCompletion(status == 3, this);
                    throw throwable;
                }
            }
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        try {
            status = this.userTransaction.getStatus();
        }
        catch (SystemException se) {
            log.error("Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(status);
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        try {
            status = this.userTransaction.getStatus();
        }
        catch (SystemException se) {
            log.error("Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    public boolean isActive() throws TransactionException {
        int status;
        if (!this.begun || this.commitFailed || this.commitSucceeded) {
            return false;
        }
        try {
            status = this.userTransaction.getStatus();
        }
        catch (SystemException se) {
            log.error("Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 0;
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        if (this.getTransactionManager() == null) {
            throw new IllegalStateException("JTA TransactionManager not available");
        }
        try {
            this.getTransactionManager().getTransaction().registerSynchronization(sync);
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization", e);
        }
    }

    private TransactionManager getTransactionManager() {
        return this.transactionContext.getFactory().getTransactionManager();
    }

    private void closeIfRequired() throws HibernateException {
        boolean close;
        boolean bl = close = this.callback && this.transactionContext.shouldAutoClose() && !this.transactionContext.isClosed();
        if (close) {
            this.transactionContext.managedClose();
        }
    }

    public void setTimeout(int seconds) {
        try {
            this.userTransaction.setTransactionTimeout(seconds);
        }
        catch (SystemException se) {
            throw new TransactionException("could not set transaction timeout", se);
        }
    }

    protected UserTransaction getUserTransaction() {
        return this.userTransaction;
    }
}

