/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import javax.security.jacc.EJBMethodPermission;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.secure.JACCPermissions;
import org.hibernate.secure.JACCSecurityListener;

public class JACCPreInsertEventListener
implements PreInsertEventListener,
Initializable,
JACCSecurityListener {
    private String contextID;

    public boolean onPreInsert(PreInsertEvent event) {
        EJBMethodPermission insertPermission = new EJBMethodPermission(event.getPersister().getEntityName(), "insert", null, null);
        JACCPermissions.checkPermission(event.getEntity().getClass(), this.contextID, insertPermission);
        return false;
    }

    public void initialize(Configuration cfg) {
        this.contextID = cfg.getProperty("hibernate.jacc_context_id");
    }
}

