/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.NonFlushedChanges;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonFlushedChangesImpl
implements NonFlushedChanges {
    private static final Logger log = LoggerFactory.getLogger((Class)NonFlushedChangesImpl.class);
    private Map nonFlushedChangesByEntityMode = new HashMap();

    public NonFlushedChangesImpl(EventSource session) {
        this.extractFromSession(session);
    }

    public void extractFromSession(EventSource session) {
        if (this.nonFlushedChangesByEntityMode.containsKey(session.getEntityMode())) {
            throw new AssertionFailure("Already has non-flushed changes for entity mode: " + session.getEntityMode());
        }
        this.nonFlushedChangesByEntityMode.put(session.getEntityMode(), new SessionNonFlushedChanges(session));
    }

    private SessionNonFlushedChanges getSessionNonFlushedChanges(EntityMode entityMode) {
        return (SessionNonFlushedChanges)this.nonFlushedChangesByEntityMode.get(entityMode);
    }

    ActionQueue getActionQueue(EntityMode entityMode) {
        return this.getSessionNonFlushedChanges(entityMode).actionQueue;
    }

    StatefulPersistenceContext getPersistenceContext(EntityMode entityMode) {
        return this.getSessionNonFlushedChanges(entityMode).persistenceContext;
    }

    public void clear() {
        this.nonFlushedChangesByEntityMode.clear();
    }

    private static class SessionNonFlushedChanges
    implements Serializable {
        private transient EntityMode entityMode;
        private transient ActionQueue actionQueue;
        private transient StatefulPersistenceContext persistenceContext;

        public SessionNonFlushedChanges(EventSource session) {
            this.entityMode = session.getEntityMode();
            this.actionQueue = session.getActionQueue();
            this.persistenceContext = (StatefulPersistenceContext)session.getPersistenceContext();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.entityMode = EntityMode.parse((String)ois.readObject());
            this.persistenceContext = StatefulPersistenceContext.deserialize(ois, null);
            this.actionQueue = ActionQueue.deserialize(ois, null);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            log.trace("serializing SessionNonFlushedChanges");
            oos.defaultWriteObject();
            oos.writeObject(this.entityMode.toString());
            this.persistenceContext.serialize(oos);
            this.actionQueue.serialize(oos);
        }
    }
}

