/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.partitioner;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.editor.partitioner.BufferedDocumentScanner;

public class FastPythonPartitionScanner
implements IPartitionTokenScanner,
IPythonPartitions {
    private static final int PYTHON = 0;
    private static final int COMMENT = 1;
    private static final int SINGLE_LINE_STRING1 = 2;
    private static final int SINGLE_LINE_STRING2 = 3;
    private static final int MULTI_LINE_STRING1 = 4;
    private static final int MULTI_LINE_STRING2 = 5;
    private static final int BACKQUOTES = 6;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__python_comment"), new Token((Object)"__python_singleline_string1"), new Token((Object)"__python_singleline_string2"), new Token((Object)"__python_multiline_string1"), new Token((Object)"__python_multiline_string2"), new Token((Object)"__python_backquotes")};
    private int fTokenOffset;
    private int fTokenLength;
    private String currContentType;

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        if (partitionOffset != -1 && partitionOffset < offset) {
            this.fScanner.setRange(document, partitionOffset, length + (offset - partitionOffset));
            this.fTokenOffset = partitionOffset;
            this.fTokenLength = 0;
            this.currContentType = null;
        } else {
            this.fScanner.setRange(document, offset, length);
            this.fTokenOffset = offset;
            this.fTokenLength = 0;
            this.currContentType = contentType;
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.currContentType = null;
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = 0;
        int ch = this.fScanner.read();
        if (ch == -1) {
            ++this.fTokenLength;
            return Token.EOF;
        }
        if (this.currContentType != null) {
            if (this.currContentType.equals("__python_comment")) {
                return this.handleComment(ch);
            }
            if (this.currContentType.equals("__python_singleline_string1")) {
                return this.handleSingleQuotedString(ch);
            }
            if (this.currContentType.equals("__python_singleline_string2")) {
                return this.handleSingleQuotedString(ch);
            }
            if (this.currContentType.equals("__python_multiline_string1")) {
                return this.handleSingleQuotedString(ch);
            }
            if (this.currContentType.equals("__python_multiline_string2")) {
                return this.handleSingleQuotedString(ch);
            }
            this.currContentType.equals("__python_backquotes");
        }
        switch (ch) {
            case 35: {
                return this.handleComment(ch);
            }
            case 34: 
            case 39: {
                return this.handleSingleQuotedString(ch);
            }
        }
        ++this.fTokenLength;
        return this.fTokens[0];
    }

    private IToken handleSingleQuotedString(int ch) {
        int initialChar = ch;
        int offsetEnd = this.fTokenOffset;
        if (this.isMultiLiteral(ch)) {
            return this.handleMultiSingleQuotedString(ch, offsetEnd += 2, initialChar);
        }
        ch = this.fScanner.read();
        ++offsetEnd;
        while (ch != 10 && ch != 13 && ch != initialChar && ch != -1) {
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        this.fTokenLength = ++offsetEnd - this.fTokenOffset;
        if (initialChar == 39) {
            return this.fTokens[2];
        }
        return this.fTokens[3];
    }

    private IToken handleMultiSingleQuotedString(int ch, int offsetEnd, int initialChar) {
        ch = this.fScanner.read();
        ++offsetEnd;
        while (ch != -1) {
            if (ch == initialChar && this.isMultiLiteral(ch)) {
                offsetEnd += 2;
                if (initialChar == 39) {
                    return this.fTokens[4];
                }
                return this.fTokens[5];
            }
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        if (initialChar == 39) {
            return this.fTokens[2];
        }
        return this.fTokens[3];
    }

    private boolean isMultiLiteral(int ch) {
        int c1 = this.fScanner.read();
        if (c1 == ch) {
            int c2 = this.fScanner.read();
            if (c2 == ch) {
                return true;
            }
            if (c2 != -1) {
                this.fScanner.unread();
            }
        }
        if (c1 != -1) {
            this.fScanner.unread();
        }
        return false;
    }

    private IToken handleComment(int ch) {
        int offsetEnd = this.fTokenOffset;
        while (ch != 10 && ch != 13 && ch != -1) {
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        this.fTokenLength = offsetEnd - this.fTokenOffset;
        return this.fTokens[1];
    }
}

