/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.docutils.DocUtils;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParsingUtils
implements IPythonPartitions {
    public abstract char charAt(int var1);

    public abstract int len();

    public static ParsingUtils create(Object cs) {
        if (cs instanceof char[]) {
            return new CharArrayParsingUtils((char[])cs);
        }
        if (cs instanceof FastStringBuffer) {
            return new FastStringBufferParsingUtils((FastStringBuffer)cs);
        }
        if (cs instanceof StringBuffer) {
            return new StringBufferParsingUtils((StringBuffer)cs);
        }
        if (cs instanceof String) {
            return new StringParsingUtils((String)cs);
        }
        if (cs instanceof IDocument) {
            return new IDocumentParsingUtils((IDocument)cs);
        }
        throw new RuntimeException(new StringBuffer("Don't know how to create instance for: ").append(cs.getClass()).toString());
    }

    public int eatComments(FastStringBuffer buf, int i) {
        char c;
        int len = this.len();
        while (i < len && (c = this.charAt(i)) != '\n' && c != '\r') {
            if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        if (i < len && buf != null) {
            buf.append(this.charAt(i));
        }
        return i;
    }

    public int eatWhitespaces(FastStringBuffer buf, int i) {
        char c;
        int len = this.len();
        while (i < len && (c = this.charAt(i)) == ' ') {
            if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return --i;
    }

    public int eatLiterals(FastStringBuffer buf, int i) {
        char curr = this.charAt(i);
        if (curr != '\"' && curr != '\'') {
            throw new RuntimeException("Wrong location to eat literals. Expecting ' or \" ");
        }
        int j = this.getLiteralEnd(i, curr);
        if (buf != null) {
            int len = this.len();
            int k = i;
            while (k < len && k <= j) {
                buf.append(this.charAt(k));
                ++k;
            }
        }
        return j;
    }

    public int getLiteralEnd(int i, char curr) {
        boolean multi = this.isMultiLiteral(i, curr);
        int j = multi ? this.findNextMulti(i + 3, curr) : this.findNextSingle(i + 1, curr);
        return j;
    }

    public int eatPar(int i, FastStringBuffer buf) {
        return this.eatPar(i, buf, '(');
    }

    public int getFullFlattenedLine(int i, FastStringBuffer buf) {
        char c = this.charAt(i);
        int len = this.len();
        boolean ignoreNextNewLine = false;
        while (i < len) {
            c = this.charAt(i);
            ++i;
            if (c == '\'' || c == '\"') {
                i = this.eatLiterals(null, i - 1) + 1;
            } else {
                if (c == '#') {
                    i = this.eatComments(null, i - 1) + 1;
                    break;
                }
                if (c == '(' || c == '[' || c == '{') {
                    i = this.eatPar(i - 1, null, c) + 1;
                } else if (c == '\r' || c == '\n') {
                    if (!ignoreNextNewLine) {
                        break;
                    }
                } else {
                    if (c == '\\' || c == '\\') {
                        ignoreNextNewLine = true;
                        continue;
                    }
                    if (buf != null) {
                        buf.append(c);
                    }
                }
            }
            ignoreNextNewLine = false;
        }
        return i;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public int eatPar(int i, FastStringBuffer buf, char par) {
        char c;
        char c2 = ' ';
        char closingPar = DocUtils.getPeer(par);
        int j = i + 1;
        int len = this.len();
        if (true) {
            return j;
        }
        do {
            ++j;
            if (c2 == '\'' || c2 == '\"') {
                j = this.eatLiterals(null, j - 1) + 1;
            } else if (c2 == '#') {
                j = this.eatComments(null, j - 1) + 1;
            } else if (c2 == par) {
                j = this.eatPar(j - 1, null, par) + 1;
            } else if (buf != null) {
                buf.append(c2);
            }
            if (j >= len) return j;
            c = this.charAt(j);
            c2 = c;
        } while (c != closingPar);
        return j;
    }

    public int findNextSingle(int i, char curr) {
        boolean ignoreNext = false;
        int len = this.len();
        while (i < len) {
            char c = this.charAt(i);
            if (!ignoreNext && c == curr) break;
            if (!ignoreNext) {
                if (c == '\\') {
                    ignoreNext = true;
                }
            } else {
                ignoreNext = false;
            }
            ++i;
        }
        return i;
    }

    public int findNextMulti(int i, char curr) {
        int len = this.len();
        while (i + 2 < len) {
            char c = this.charAt(i);
            if (c == curr && this.charAt(i + 1) == curr && this.charAt(i + 2) == curr) break;
            ++i;
            if (c != '\\') continue;
            ++i;
        }
        if (len < i + 2) {
            return len;
        }
        return i + 2;
    }

    public boolean isMultiLiteral(int i, char curr) {
        int len = this.len();
        if (len <= i + 2) {
            return false;
        }
        return this.charAt(i + 1) == curr && this.charAt(i + 2) == curr;
    }

    public static void removeCommentsWhitespacesAndLiterals(FastStringBuffer buf) {
        ParsingUtils.removeCommentsWhitespacesAndLiterals(buf, true);
    }

    public static void removeCommentsWhitespacesAndLiterals(FastStringBuffer buf, boolean whitespacesToo) {
        ParsingUtils parsingUtils = ParsingUtils.create(buf);
        int i = 0;
        while (i < buf.length()) {
            int j;
            char ch = buf.charAt(i);
            if (ch == '#') {
                j = i;
                while (j < buf.length() && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(j);
                    ++j;
                }
                buf.delete(i, j);
            }
            if (ch == '\'' || ch == '\"') {
                j = parsingUtils.getLiteralEnd(i, ch);
                if (whitespacesToo) {
                    buf.delete(i, j + 1);
                } else {
                    int k = 0;
                    while (i + k < j + 1) {
                        buf.replace(i + k, i + k + 1, " ");
                        ++k;
                    }
                }
            }
            ++i;
        }
        if (whitespacesToo) {
            int length = buf.length();
            int i2 = length - 1;
            while (i2 >= 0) {
                char ch = buf.charAt(i2);
                if (Character.isWhitespace(ch)) {
                    buf.deleteCharAt(i2);
                }
                --i2;
            }
        }
    }

    public static void removeLiterals(FastStringBuffer buf) {
        ParsingUtils parsingUtils = ParsingUtils.create(buf);
        int i = 0;
        while (i < buf.length()) {
            char ch = buf.charAt(i);
            if (ch == '#') {
                while (i < buf.length() && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(i);
                    ++i;
                }
            }
            if (ch == '\'' || ch == '\"') {
                int j = parsingUtils.getLiteralEnd(i, ch);
                int k = 0;
                while (i + k < j + 1) {
                    buf.replace(i + k, i + k + 1, " ");
                    ++k;
                }
            }
            ++i;
        }
    }

    public static Iterator<String> getNoLiteralsOrCommentsIterator(IDocument doc) {
        return new PyDocIterator(doc);
    }

    public static void removeCommentsAndWhitespaces(FastStringBuffer buf) {
        int i = 0;
        while (i < buf.length()) {
            char ch = buf.charAt(i);
            if (ch == '#') {
                int j = i;
                while (j < buf.length() - 1 && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(++j);
                }
                buf.delete(i, j);
            }
            ++i;
        }
        int length = buf.length();
        int i2 = length - 1;
        while (i2 >= 0) {
            char ch = buf.charAt(i2);
            if (Character.isWhitespace(ch)) {
                buf.deleteCharAt(i2);
            }
            --i2;
        }
    }

    public static String getContentType(String initial, int currPos) {
        FastStringBuffer buf = new FastStringBuffer(initial, 0);
        ParsingUtils parsingUtils = ParsingUtils.create(initial);
        String curr = "__dftl_partition_content_type";
        int i = 0;
        while (i < buf.length() && i < currPos) {
            char ch = buf.charAt(i);
            curr = "__dftl_partition_content_type";
            if (ch == '#') {
                curr = "__python_comment";
                int j = i;
                while (j < buf.length() - 1 && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(++j);
                }
                i = j;
            }
            if (i >= currPos) {
                return curr;
            }
            if (ch == '\'' || ch == '\"') {
                curr = "__python_singleline_string1";
                if (ch == '\"') {
                    curr = "__python_singleline_string2";
                }
                i = parsingUtils.getLiteralEnd(i, ch);
            }
            ++i;
        }
        return curr;
    }

    public static String getContentType(IDocument document, int i) {
        IDocumentExtension3 docExtension = (IDocumentExtension3)document;
        IDocumentPartitionerExtension2 partitioner = (IDocumentPartitionerExtension2)docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        if (partitioner != null) {
            return partitioner.getContentType(i, true);
        }
        return ParsingUtils.getContentType(document.get(), i);
    }

    public static String makePythonParseable(String code, String delimiter) {
        return ParsingUtils.makePythonParseable(code, delimiter, new FastStringBuffer());
    }

    public static String makePythonParseable(String code, String delimiter, FastStringBuffer lastLine) {
        FastStringBuffer buffer = new FastStringBuffer();
        FastStringBuffer currLine = new FastStringBuffer();
        boolean foundNewLine = false;
        boolean lastWasNewLine = false;
        if (lastLine.length() > 0) {
            lastWasNewLine = true;
        }
        int i = 0;
        while (i < code.length()) {
            boolean foundNewLineAtChar = false;
            char c = code.charAt(i);
            if (c == '\r') {
                if (i + 1 < code.length() && code.charAt(i + 1) == '\n') {
                    ++i;
                }
                foundNewLineAtChar = true;
            } else if (c == '\n') {
                foundNewLineAtChar = true;
            }
            if (!foundNewLineAtChar) {
                if (lastWasNewLine && !Character.isWhitespace(c) && lastLine.length() > 0 && Character.isWhitespace(lastLine.charAt(0))) {
                    buffer.append(delimiter);
                }
                currLine.append(c);
                lastWasNewLine = false;
            } else {
                lastWasNewLine = true;
            }
            if (foundNewLineAtChar || i == code.length() - 1) {
                if (!PySelection.containsOnlyWhitespaces(currLine.toString())) {
                    buffer.append(currLine);
                    lastLine = currLine;
                    currLine = new FastStringBuffer();
                    buffer.append(delimiter);
                    foundNewLine = true;
                } else {
                    currLine = new FastStringBuffer();
                }
            }
            ++i;
        }
        if (!foundNewLine) {
            buffer.append(delimiter);
        } else {
            if (!WordUtils.endsWith(buffer, '\r') && !WordUtils.endsWith(buffer, '\n')) {
                buffer.append(delimiter);
            }
            if (lastLine.length() > 0 && Character.isWhitespace(lastLine.charAt(0)) && (code.indexOf(13) != -1 || code.indexOf(10) != -1)) {
                buffer.append(delimiter);
            }
        }
        return buffer.toString();
    }

    public static String removeComments(String line) {
        int i = line.indexOf(35);
        if (i != -1) {
            return line.substring(0, i);
        }
        return line;
    }

    private static class CharArrayParsingUtils
    extends ParsingUtils {
        private char[] cs;

        public CharArrayParsingUtils(char[] cs) {
            this.cs = cs;
        }

        public int len() {
            return this.cs.length;
        }

        public char charAt(int i) {
            return this.cs[i];
        }
    }

    private static class FastStringBufferParsingUtils
    extends ParsingUtils {
        private FastStringBuffer cs;

        public FastStringBufferParsingUtils(FastStringBuffer cs) {
            this.cs = cs;
        }

        public int len() {
            return this.cs.length();
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static class IDocumentParsingUtils
    extends ParsingUtils {
        private IDocument cs;

        public IDocumentParsingUtils(IDocument cs) {
            this.cs = cs;
        }

        public int len() {
            return this.cs.getLength();
        }

        public char charAt(int i) {
            try {
                return this.cs.getChar(i);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class StringBufferParsingUtils
    extends ParsingUtils {
        private StringBuffer cs;

        public StringBufferParsingUtils(StringBuffer cs) {
            this.cs = cs;
        }

        public int len() {
            return this.cs.length();
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static class StringParsingUtils
    extends ParsingUtils {
        private String cs;

        public StringParsingUtils(String cs) {
            this.cs = cs;
        }

        public int len() {
            return this.cs.length();
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }
}

