/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.pages.extractlocal;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.controls.LabeledEdit;
import org.python.pydev.refactoring.ui.pages.listener.IValidationPage;
import org.python.pydev.refactoring.ui.validator.NameValidator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractLocalComposite
extends Composite {
    private LabeledEdit variableNameEdit;
    private AbstractScopeNode<?> scopeAdapter;
    private IValidationPage page;

    public ExtractLocalComposite(IValidationPage page, Composite parent, AbstractScopeNode<?> scope) {
        super(parent, 0);
        this.page = page;
        this.scopeAdapter = scope;
        this.createComposite();
    }

    public void createComposite() {
        this.setLayout((Layout)new GridLayout());
        this.createVariableName(this);
        this.pack();
    }

    private void createVariableName(Composite control) {
        Composite variableNameComposite = new Composite(control, 0);
        FillLayout compositeLayout = new FillLayout(256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        variableNameComposite.setLayoutData((Object)gridData);
        variableNameComposite.setLayout((Layout)compositeLayout);
        this.variableNameEdit = new LabeledEdit(variableNameComposite, Messages.extractLocalVariableTitle);
    }

    public void registerListeners(IValidationPage page) {
        this.variableNameEdit.getEdit().addListener(24, (Listener)page);
    }

    public String getVariableName() {
        return this.variableNameEdit.getEdit().getText();
    }

    public boolean validate() {
        NameValidator nameValidator = new NameValidator(this.scopeAdapter);
        try {
            nameValidator.validateVariableName(this.getVariableName());
            nameValidator.validateUniqueVariable(this.getVariableName());
        }
        catch (Throwable e) {
            this.page.setErrorMessage(e.getMessage());
        }
        return this.page.getErrorMessage() == null;
    }
}

