/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.actions.AbstractBreakpointRulerAction;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.fInfo = rulerInfo;
        this.fTextEditor = editor;
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean enabled = this.getBreakpoint().isEnabled();
            this.setText(enabled ? "&Disable Breakpoint" : "&Enable Breakpoint");
        }
        catch (CoreException ce) {
            PydevDebugPlugin.log(4, ce.getLocalizedMessage(), ce);
        }
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            new Job("Enabling / Disabling Breakpoint"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        EnableDisableBreakpointRulerAction.this.getBreakpoint().setEnabled(!EnableDisableBreakpointRulerAction.this.getBreakpoint().isEnabled());
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)EnableDisableBreakpointRulerAction.this.getTextEditor().getEditorSite().getShell(), (String)"Enabling/disabling breakpoints", (String)"Exceptions occurred enabling disabling the breakpoint", (IStatus)e.getStatus());
                            }
                        });
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule();
        }
    }
}

