/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.ProjectFile;

public final class DatatypeConverter {
    private static final ThreadLocal<ProjectFile> PARENT_FILE = new ThreadLocal();
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal();
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal();

    public static final String printDateTime(Date date) {
        return date == null ? null : DatatypeConverter.getDateFormat().format(date);
    }

    public static final Date parseDateTime(String string) {
        Date date = null;
        if (string != null && string.length() != 0) {
            try {
                date = DatatypeConverter.getDateFormat().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static final String printTime(Date date) {
        return date == null ? null : DatatypeConverter.getTimeFormat().format(date);
    }

    public static final Date parseTime(String string) {
        Date date = null;
        if (string != null && string.length() != 0) {
            try {
                date = DatatypeConverter.getTimeFormat().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static final void setParentFile(ProjectFile projectFile) {
        PARENT_FILE.set(projectFile);
    }

    private static final DateFormat getDateFormat() {
        DateFormat dateFormat = DATE_FORMAT.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }

    private static final DateFormat getTimeFormat() {
        DateFormat dateFormat = TIME_FORMAT.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("HH:mm:ss");
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }
}

