/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.mpp.MPPUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RTFEmbeddedObject {
    private int m_typeFlag1;
    private int m_typeFlag2;
    private byte[] m_data;
    private static final String OBJDATA = "\\objdata";

    private RTFEmbeddedObject(List<byte[]> list, int n) {
        switch (n) {
            case 2: 
            case 5: {
                this.m_typeFlag1 = this.getInt(list);
                this.m_typeFlag2 = this.getInt(list);
                int n2 = this.getInt(list);
                this.m_data = this.getData(list, n2);
                break;
            }
            case 1: {
                int n3 = this.getInt(list);
                this.m_data = this.getData(list, n3);
                break;
            }
        }
    }

    public int getTypeFlag1() {
        return this.m_typeFlag1;
    }

    public int getTypeFlag2() {
        return this.m_typeFlag2;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public String getDataString() {
        return this.m_data == null ? "" : new String(this.m_data);
    }

    public static List<List<RTFEmbeddedObject>> getEmbeddedObjects(String string) {
        LinkedList<LinkedList<RTFEmbeddedObject>> linkedList = null;
        int n = string.indexOf(OBJDATA);
        if (n != -1) {
            linkedList = new LinkedList<LinkedList<RTFEmbeddedObject>>();
            while (n != -1) {
                LinkedList<RTFEmbeddedObject> linkedList2 = new LinkedList<RTFEmbeddedObject>();
                linkedList.add(linkedList2);
                n = RTFEmbeddedObject.readObjectData(n, string, linkedList2);
                n = string.indexOf(OBJDATA, n);
            }
        }
        return linkedList;
    }

    private int getInt(List<byte[]> list) {
        int n;
        if (!list.isEmpty()) {
            byte[] byArray = list.remove(0);
            n = MPPUtility.getInt(byArray, 0);
        } else {
            n = 0;
        }
        return n;
    }

    private byte[] getData(List<byte[]> list, int n) {
        byte[] byArray;
        if (!list.isEmpty()) {
            byte[] byArray2;
            if (n < 4) {
                n = 4;
            }
            byArray = new byte[n];
            for (int i = 0; i < n; i += byArray2.length) {
                byArray2 = list.remove(0);
                System.arraycopy(byArray2, 0, byArray, i, byArray2.length);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    private static int readObjectData(int n, String string, List<RTFEmbeddedObject> list) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        n += OBJDATA.length();
        int n2 = n = RTFEmbeddedObject.skipEndOfLine(string, n);
        while (n != -1) {
            int n3 = RTFEmbeddedObject.getBlockLength(string, n);
            n2 = RTFEmbeddedObject.readDataBlock(string, n, n3, linkedList);
            n = RTFEmbeddedObject.skipEndOfLine(string, n2);
        }
        while (!linkedList.isEmpty()) {
            RTFEmbeddedObject rTFEmbeddedObject = new RTFEmbeddedObject(linkedList, 2);
            list.add(rTFEmbeddedObject);
            if (linkedList.isEmpty()) continue;
            RTFEmbeddedObject rTFEmbeddedObject2 = new RTFEmbeddedObject(linkedList, rTFEmbeddedObject.getTypeFlag2());
            list.add(rTFEmbeddedObject2);
        }
        return n2;
    }

    private static int skipEndOfLine(String string, int n) {
        boolean bl = false;
        block4: while (!bl) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': {
                    ++n;
                    continue block4;
                }
                case '}': {
                    n = -1;
                    bl = true;
                    continue block4;
                }
            }
            bl = true;
        }
        return n;
    }

    private static int getBlockLength(String string, int n) {
        int n2 = n;
        boolean bl = false;
        block3: while (!bl) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': 
                case '\r': 
                case '}': {
                    bl = true;
                    continue block3;
                }
            }
            ++n;
        }
        int n3 = n - n2;
        return n3;
    }

    private static int readDataBlock(String string, int n, int n2, List<byte[]> list) {
        int n3 = n2 / 2;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            n += 2;
        }
        list.add(byArray);
        return n;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("[RTFObject");
        printWriter.println("   Flag1=" + this.m_typeFlag1);
        printWriter.println("   Flag2=" + this.m_typeFlag2);
        printWriter.println("   Data=");
        printWriter.println(MPPUtility.hexdump(this.m_data, true, 16, "  "));
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

