/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.resource;

import com.projity.algorithm.ReverseQuery;
import com.projity.algorithm.TimeIteratorGenerator;
import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.algorithm.buffer.GroupedCalculatedValues;
import com.projity.association.AssociationList;
import com.projity.configuration.CircularDependencyException;
import com.projity.datatype.ImageLink;
import com.projity.datatype.Rate;
import com.projity.datatype.RateFormat;
import com.projity.document.Document;
import com.projity.field.CustomFields;
import com.projity.field.CustomFieldsImpl;
import com.projity.field.FieldContext;
import com.projity.interval.InvalidValueObjectForIntervalException;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.assignment.HasAssignmentsImpl;
import com.projity.pm.assignment.timesheet.TimesheetHelper;
import com.projity.pm.availability.AvailabilityTable;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.costing.CostRateTable;
import com.projity.pm.costing.CostRateTables;
import com.projity.pm.costing.EarnedValueCalculator;
import com.projity.pm.key.HasKeyImpl;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseResource
implements Resource {
    static final long serialVersionUID = 273977742329L;
    private static Resource UNASSIGNED = null;
    public static final int UNASSIGNED_ID = -65535;
    transient HasAssignments hasAssignments = new HasAssignmentsImpl();
    private transient HasKeyImpl hasKey;
    protected transient ResourcePool resourcePool;
    protected String notes = "";
    protected String group = "";
    protected String initials = "";
    protected String phonetics = "";
    protected String rbsCode = "";
    protected String emailAddress = "";
    protected String materialLabel = "";
    protected String userAccount = "";
    protected int resourceType = 1;
    protected transient CostRateTables costRateTables = new CostRateTables();
    protected double maximumUnits = 1.0;
    protected boolean generic = false;
    protected boolean inactive = false;
    protected transient CustomFieldsImpl customFields = new CustomFieldsImpl();
    protected long externalId = -1L;
    protected int accrueAt = 3;
    protected WorkCalendar workCalendar = null;
    private static short DEFAULT_VERSION = (short)2;
    private short version = DEFAULT_VERSION;
    private transient boolean dirty;
    protected transient boolean master;
    protected transient GroupedCalculatedValues globalWorkVector;
    private transient Set<Integer> authorizedRoles;
    private transient int defaultRole;
    private transient int license;
    private transient int licenseOptions;
    private transient AvailabilityTable availabilityTable = new AvailabilityTable(null);
    protected transient Object serverMeta;

    @Override
    public long getEarliestAssignmentStart() {
        return this.hasAssignments.getEarliestAssignmentStart();
    }

    @Override
    public boolean hasActiveAssignment(long l, long l2) {
        return this.hasAssignments.hasActiveAssignment(l, l2);
    }

    public EnterpriseResource(ResourcePool resourcePool) {
        this(resourcePool == null || resourcePool.isLocal(), resourcePool);
    }

    public EnterpriseResource(boolean bl, ResourcePool resourcePool) {
        this.hasKey = new HasKeyImpl(bl, this);
        this.resourcePool = resourcePool;
        if (resourcePool != null) {
            this.workCalendar = WorkingCalendar.getInstanceBasedOn(resourcePool.getDefaultCalendar());
            this.workCalendar.setName("");
        }
    }

    public static Resource getUnassignedInstance() {
        if (UNASSIGNED == null) {
            UNASSIGNED = new EnterpriseResource(null);
            UNASSIGNED.setName(Messages.getString("Text.Unassigned"));
            UNASSIGNED.setUniqueId(-65535L);
        }
        return UNASSIGNED;
    }

    public boolean isDefault() {
        return this.getUniqueId() == -65535L;
    }

    @Override
    public long getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(long l) {
        this.externalId = l;
    }

    @Override
    public int getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setResourceType(int n) {
        if (n == this.resourceType) {
            return;
        }
        boolean bl = this.isLabor();
        this.resourceType = n;
        if (bl != this.isLabor()) {
            this.setStandardRate(new Rate());
            this.setOvertimeRate(new Rate());
            if (!this.isLabor()) {
                this.getStandardRate().setTimeUnit(-2);
                this.getOvertimeRate().setTimeUnit(-2);
            }
        }
    }

    @Override
    public double getCostPerUse() {
        return this.costRateTables.getCostPerUse();
    }

    @Override
    public Rate getOvertimeRate() {
        return this.costRateTables.getOvertimeRate();
    }

    @Override
    public Rate getStandardRate() {
        return this.costRateTables.getStandardRate();
    }

    @Override
    public void setCostPerUse(double d) {
        this.costRateTables.setCostPerUse(d);
    }

    @Override
    public void setOvertimeRate(Rate rate) {
        if (!this.isLabor()) {
            rate.makeUnitless();
        }
        this.costRateTables.setOvertimeRate(rate);
    }

    @Override
    public void setStandardRate(Rate rate) {
        if (!this.isLabor()) {
            rate.makeUnitless();
        }
        this.costRateTables.setStandardRate(rate);
    }

    @Override
    public long getEffectiveDate() {
        return this.costRateTables.getEffectiveDate();
    }

    @Override
    public void setEffectiveDate(long l) throws InvalidValueObjectForIntervalException {
        this.costRateTables.setEffectiveDate(l);
    }

    @Override
    public boolean isReadOnlyEffectiveDate(FieldContext fieldContext) {
        return this.costRateTables.isReadOnlyEffectiveDate(fieldContext);
    }

    @Override
    public CostRateTable getCostRateTable(int n) {
        return this.costRateTables.getCostRateTable(n);
    }

    @Override
    public int getAccrueAt() {
        return this.accrueAt;
    }

    @Override
    public void setAccrueAt(int n) {
        this.accrueAt = n;
    }

    @Override
    public void addAssignment(Assignment assignment) {
        this.hasAssignments.addAssignment(assignment);
    }

    @Override
    public void buildReverseQuery(ReverseQuery reverseQuery) {
        this.hasAssignments.buildReverseQuery(reverseQuery);
    }

    @Override
    public Assignment findAssignment(Resource resource) {
        return this.hasAssignments.findAssignment(resource);
    }

    @Override
    public Assignment findAssignment(Task task) {
        return this.hasAssignments.findAssignment(task);
    }

    @Override
    public double getMaximumUnits() {
        return this.maximumUnits;
    }

    public void setMaximumUnits(double d) {
        this.maximumUnits = d;
    }

    @Override
    public AssociationList getAssignments() {
        return this.hasAssignments.getAssignments();
    }

    @Override
    public int getSchedulingType() {
        return this.hasAssignments.getSchedulingType();
    }

    public int hashCode() {
        return this.hasAssignments.hashCode();
    }

    @Override
    public boolean isEffortDriven() {
        return false;
    }

    @Override
    public void removeAssignment(Assignment assignment) {
        this.hasAssignments.removeAssignment(assignment);
    }

    @Override
    public void setEffortDriven(boolean bl) {
        this.hasAssignments.setEffortDriven(bl);
    }

    @Override
    public void setSchedulingType(int n) {
        this.hasAssignments.setSchedulingType(n);
    }

    @Override
    public void updateAssignment(Assignment assignment) {
        this.hasAssignments.updateAssignment(assignment);
    }

    public static Closure forAllAssignments(Closure closure) {
        return HasAssignmentsImpl.forAllAssignments(closure);
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String string) {
        this.notes = string;
    }

    @Override
    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        this.hasAssignments.forEachWorkingInterval(closure, bl, workCalendar);
    }

    @Override
    public void setWorkCalendar(WorkCalendar workCalendar) {
        this.workCalendar = workCalendar;
    }

    @Override
    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    @Override
    public WorkCalendar getEffectiveWorkCalendar() {
        return this.workCalendar;
    }

    @Override
    public boolean isReadOnlyEffortDriven(FieldContext fieldContext) {
        return this.hasAssignments.isReadOnlyEffortDriven(fieldContext);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String string) {
        this.group = string;
    }

    @Override
    public String getInitials() {
        return this.initials;
    }

    @Override
    public void setInitials(String string) {
        this.initials = string;
        if (this.getName() == null) {
            this.setName(string);
        }
    }

    @Override
    public String getPhonetics() {
        return this.phonetics;
    }

    @Override
    public void setPhonetics(String string) {
        this.phonetics = string;
    }

    @Override
    public double getRemainingOvertimeCost() {
        return -1.0;
    }

    @Override
    public Date getCreated() {
        return this.hasKey.getCreated();
    }

    @Override
    public long getId() {
        return this.hasKey.getId();
    }

    @Override
    public String getName() {
        return this.hasKey.getName();
    }

    @Override
    public long getUniqueId() {
        return this.hasKey.getUniqueId();
    }

    @Override
    public void setCreated(Date date) {
        this.hasKey.setCreated(date);
    }

    @Override
    public void setId(long l) {
        this.hasKey.setId(l);
    }

    @Override
    public void setName(String string) {
        this.hasKey.setName(string);
        if ((this.getInitials() == null || this.getInitials().length() == 0) && string != null && string.length() > 0) {
            this.setInitials(string.substring(0, 1));
        }
        if (this.workCalendar != null) {
            this.workCalendar.setName(string);
        }
    }

    @Override
    public void setUniqueId(long l) {
        this.hasKey.setUniqueId(l);
    }

    @Override
    public double actualCost(long l, long l2) {
        return this.hasAssignments.actualCost(l, l2);
    }

    @Override
    public long actualWork(long l, long l2) {
        return this.hasAssignments.actualWork(l, l2);
    }

    @Override
    public long remainingWork(long l, long l2) {
        return this.hasAssignments.remainingWork(l, l2);
    }

    @Override
    public double acwp(long l, long l2) {
        return this.hasAssignments.acwp(l, l2);
    }

    @Override
    public double bac(long l, long l2) {
        return this.hasAssignments.bac(l, l2);
    }

    @Override
    public double bcwp(long l, long l2) {
        return this.hasAssignments.bcwp(l, l2);
    }

    @Override
    public double bcws(long l, long l2) {
        return this.hasAssignments.bcws(l, l2);
    }

    @Override
    public double cost(long l, long l2) {
        return this.hasAssignments.cost(l, l2);
    }

    @Override
    public long work(long l, long l2) {
        return this.hasAssignments.work(l, l2);
    }

    @Override
    public String getName(FieldContext fieldContext) {
        return this.hasKey.getName(fieldContext);
    }

    @Override
    public void calcDataBetween(Object object, TimeIteratorGenerator timeIteratorGenerator, CalculatedValues calculatedValues) {
        this.hasAssignments.calcDataBetween(object, timeIteratorGenerator, calculatedValues);
    }

    @Override
    public String getRbsCode() {
        return this.rbsCode;
    }

    @Override
    public void setRbsCode(String string) {
        this.rbsCode = string;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    @Override
    public Document getDocument() {
        return this.resourcePool;
    }

    @Override
    public Collection childrenToRollup() {
        return this.hasAssignments.childrenToRollup();
    }

    @Override
    public double getCost(FieldContext fieldContext) {
        return this.cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getWork(FieldContext fieldContext) {
        return this.work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getActualCost(FieldContext fieldContext) {
        return this.actualCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getActualWork(FieldContext fieldContext) {
        return this.actualWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getRemainingWork(FieldContext fieldContext) {
        return this.remainingWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getRemainingCost(FieldContext fieldContext) {
        return this.getCost(fieldContext) - this.getActualCost(fieldContext);
    }

    @Override
    public double getAcwp(FieldContext fieldContext) {
        return this.acwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBac(FieldContext fieldContext) {
        return this.bac(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcwp(FieldContext fieldContext) {
        return this.bcwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcws(FieldContext fieldContext) {
        return this.bcws(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().sv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getEac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().eac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getVac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().vac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().spi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCsi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().csi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cvPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().svPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getTcpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().tcpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double baselineCost(long l, long l2) {
        return this.hasAssignments.baselineCost(l, l2);
    }

    @Override
    public long baselineWork(long l, long l2) {
        return this.hasAssignments.baselineWork(l, l2);
    }

    @Override
    public double getBaselineCost(int n, FieldContext fieldContext) {
        return this.baselineCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getBaselineWork(int n, FieldContext fieldContext) {
        return this.baselineWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    private boolean isFieldHidden(FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBaselineCost(int n, FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideBaselineWork(int n, FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideAcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcws(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideEac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideVac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideTcpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public long calcActiveAssignmentDuration(WorkCalendar workCalendar) {
        return this.hasAssignments.calcActiveAssignmentDuration(workCalendar);
    }

    @Override
    public boolean isAssignment() {
        return false;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }

    @Override
    public String getMaterialLabel() {
        return this.materialLabel;
    }

    @Override
    public void setMaterialLabel(String string) {
        this.materialLabel = string;
    }

    @Override
    public boolean isLabor() {
        return this.resourceType == 1;
    }

    @Override
    public boolean isReadOnlyMaterialLabel(FieldContext fieldContext) {
        return this.isLabor();
    }

    @Override
    public String getUserAccount() {
        return this.userAccount;
    }

    @Override
    public final void setUserAccount(String string) {
        this.userAccount = string;
    }

    @Override
    public boolean isInactive() {
        return this.inactive;
    }

    @Override
    public void setInactive(boolean bl) {
        this.inactive = bl;
    }

    @Override
    public boolean isGeneric() {
        return this.generic;
    }

    @Override
    public void setGeneric(boolean bl) {
        this.generic = bl;
    }

    public short getVersion() {
        return this.version;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.hasKey.serialize(objectOutputStream);
        this.costRateTables.serialize(objectOutputStream);
        this.customFields.serialize(objectOutputStream);
        objectOutputStream.writeInt(this.hasAssignments.getSchedulingType());
        objectOutputStream.writeBoolean(this.hasAssignments.isEffortDriven());
        this.availabilityTable.serialize(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hasKey = HasKeyImpl.deserialize(objectInputStream, this);
        this.costRateTables = CostRateTables.deserialize(objectInputStream);
        try {
            this.customFields = CustomFieldsImpl.deserialize(objectInputStream);
        }
        catch (OptionalDataException optionalDataException) {
            this.customFields = new CustomFieldsImpl();
        }
        this.hasAssignments = new HasAssignmentsImpl();
        if (this.version >= 2) {
            this.hasAssignments.setSchedulingType(objectInputStream.readInt());
            this.hasAssignments.setEffortDriven(objectInputStream.readBoolean());
            this.availabilityTable = AvailabilityTable.deserialize(objectInputStream);
        } else {
            this.availabilityTable = new AvailabilityTable(null);
        }
        this.version = DEFAULT_VERSION;
    }

    public Object clone() {
        try {
            EnterpriseResource enterpriseResource = (EnterpriseResource)super.clone();
            enterpriseResource.hasKey = new HasKeyImpl(this.isLocal() && Environment.getStandAlone(), enterpriseResource);
            enterpriseResource.setName(new String(this.getName()));
            if (this.notes != null) {
                enterpriseResource.notes = new String(this.notes);
            }
            if (this.group != null) {
                enterpriseResource.group = new String(this.group);
            }
            if (this.group != null) {
                enterpriseResource.initials = new String(this.initials);
            }
            if (this.phonetics != null) {
                enterpriseResource.phonetics = new String(this.phonetics);
            }
            if (this.rbsCode != null) {
                enterpriseResource.rbsCode = new String(this.rbsCode);
            }
            if (this.emailAddress != null) {
                enterpriseResource.emailAddress = new String(this.emailAddress);
            }
            if (this.materialLabel != null) {
                enterpriseResource.materialLabel = new String(this.materialLabel);
            }
            if (this.userAccount != null) {
                enterpriseResource.userAccount = new String(this.userAccount);
            }
            enterpriseResource.costRateTables = (CostRateTables)this.costRateTables.clone();
            enterpriseResource.hasAssignments = (HasAssignments)((HasAssignmentsImpl)this.hasAssignments).cloneWithResource(enterpriseResource);
            enterpriseResource.customFields = (CustomFieldsImpl)this.customFields.clone();
            enterpriseResource.availabilityTable = (AvailabilityTable)this.availabilityTable.clone();
            enterpriseResource.availabilityTable.initAfterCloning();
            return enterpriseResource;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void cleanClone() {
        this.resourcePool = null;
    }

    @Override
    public WorkCalendar getBaseCalendar() {
        if (this.getWorkCalendar() == null) {
            return null;
        }
        return (WorkingCalendar)((WorkingCalendar)this.getWorkCalendar()).getBaseCalendar();
    }

    @Override
    public void setBaseCalendar(WorkCalendar workCalendar) throws CircularDependencyException {
        WorkCalendar workCalendar2 = this.getWorkCalendar();
        if (workCalendar2 == null) {
            return;
        }
        CalendarService.getInstance().reassignCalendar(this, workCalendar2, workCalendar);
        ((WorkingCalendar)this.getWorkCalendar()).changeBaseCalendar(workCalendar);
        this.invalidateAssignmentCalendars();
    }

    @Override
    public void setWork(long l, FieldContext fieldContext) {
    }

    @Override
    public void setRemainingWork(long l, FieldContext fieldContext) {
    }

    @Override
    public void setActualWork(long l, FieldContext fieldContext) {
    }

    @Override
    public boolean isReadOnlyWork(FieldContext fieldContext) {
        return true;
    }

    @Override
    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return true;
    }

    @Override
    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return true;
    }

    @Override
    public double getActualFixedCost(FieldContext fieldContext) {
        return 0.0;
    }

    @Override
    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return true;
    }

    @Override
    public double fixedCost(long l, long l2) {
        return 0.0;
    }

    @Override
    public double actualFixedCost(long l, long l2) {
        return 0.0;
    }

    @Override
    public double getFixedCost(FieldContext fieldContext) {
        return 0.0;
    }

    @Override
    public void setFixedCost(double d, FieldContext fieldContext) {
    }

    @Override
    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return true;
    }

    @Override
    public String getTimeUnitLabel() {
        if (this.getResourceType() == 1) {
            return null;
        }
        return this.getMaterialLabel();
    }

    @Override
    public boolean fieldHideOvertimeRate(FieldContext fieldContext) {
        return !this.isLabor();
    }

    @Override
    public boolean fieldHideBaseCalendar(FieldContext fieldContext) {
        return !this.isLabor();
    }

    @Override
    public boolean hasLaborAssignment() {
        return this.isLabor() && !this.getAssignments().isEmpty();
    }

    @Override
    public void invalidateAssignmentCalendars() {
        this.hasAssignments.invalidateAssignmentCalendars();
    }

    @Override
    public Document invalidateCalendar() {
        this.invalidateAssignmentCalendars();
        return this.getResourcePool();
    }

    @Override
    public boolean isWork() {
        return this.getResourceType() == 1;
    }

    @Override
    public boolean isMaterial() {
        return this.getResourceType() == 0;
    }

    @Override
    public boolean isMe() {
        if (this.userAccount == null) {
            return false;
        }
        return this.userAccount.equals(Environment.getLogin());
    }

    @Override
    public boolean isParent() {
        return false;
    }

    @Override
    public long getParentId(int n) {
        return 0L;
    }

    @Override
    public double getCustomCost(int n) {
        return this.customFields.getCustomCost(n);
    }

    @Override
    public long getCustomDate(int n) {
        return this.customFields.getCustomDate(n);
    }

    @Override
    public long getCustomDuration(int n) {
        return this.customFields.getCustomDuration(n);
    }

    @Override
    public long getCustomFinish(int n) {
        return this.customFields.getCustomFinish(n);
    }

    @Override
    public boolean getCustomFlag(int n) {
        return this.customFields.getCustomFlag(n);
    }

    @Override
    public double getCustomNumber(int n) {
        return this.customFields.getCustomNumber(n);
    }

    @Override
    public long getCustomStart(int n) {
        return this.customFields.getCustomStart(n);
    }

    @Override
    public String getCustomText(int n) {
        return this.customFields.getCustomText(n);
    }

    @Override
    public void setCustomCost(int n, double d) {
        this.customFields.setCustomCost(n, d);
    }

    @Override
    public void setCustomDate(int n, long l) {
        this.customFields.setCustomDate(n, l);
    }

    @Override
    public void setCustomDuration(int n, long l) {
        this.customFields.setCustomDuration(n, l);
    }

    @Override
    public void setCustomFinish(int n, long l) {
        this.customFields.setCustomFinish(n, l);
    }

    @Override
    public void setCustomFlag(int n, boolean bl) {
        this.customFields.setCustomFlag(n, bl);
    }

    @Override
    public void setCustomNumber(int n, double d) {
        this.customFields.setCustomNumber(n, d);
    }

    @Override
    public void setCustomStart(int n, long l) {
        this.customFields.setCustomStart(n, l);
    }

    @Override
    public void setCustomText(int n, String string) {
        this.customFields.setCustomText(n, string);
    }

    public CustomFields getCustomFields() {
        return this.customFields;
    }

    @Override
    public boolean applyTimesheet(Collection collection, long l) {
        return TimesheetHelper.applyTimesheet(this.getAssignments(), collection, l);
    }

    @Override
    public long getLastTimesheetUpdate() {
        return TimesheetHelper.getLastTimesheetUpdate(this.getAssignments());
    }

    @Override
    public boolean isPendingTimesheetUpdate() {
        return TimesheetHelper.isPendingTimesheetUpdate(this.getAssignments());
    }

    @Override
    public int getTimesheetStatus() {
        return TimesheetHelper.getTimesheetStatus(this.getAssignments());
    }

    @Override
    public String getTimesheetStatusName() {
        return TimesheetHelper.getTimesheetStatusName(this.getTimesheetStatus());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isReadOnly() {
        return !this.master && !this.isLocal() && !Environment.getStandAlone();
    }

    @Override
    public boolean isLocal() {
        return this.hasKey.isLocal();
    }

    @Override
    public void setLocal(boolean bl) {
        this.hasKey.setLocal(bl);
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean bl) {
        this.master = bl;
    }

    public GroupedCalculatedValues getGlobalWorkVector() {
        return this.globalWorkVector;
    }

    public void setGlobalWorkVector(GroupedCalculatedValues groupedCalculatedValues) {
        this.globalWorkVector = groupedCalculatedValues;
    }

    @Override
    public long getFinishOffset() {
        return 0L;
    }

    @Override
    public long getStartOffset() {
        return 0L;
    }

    @Override
    public RateFormat getRateFormat() {
        return RateFormat.getInstance(this.getTimeUnitLabel(), false, this.isLabor(), this.isLabor());
    }

    @Override
    public String getResourceName() {
        return this.getName();
    }

    public ImageLink getBudgetStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getCpi(null));
    }

    public ImageLink getScheduleStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getSpi(null));
    }

    @Override
    public boolean isUser() {
        return this.userAccount != null && this.userAccount.length() > 0;
    }

    @Override
    public boolean renumber(boolean bl) {
        return this.hasKey.renumber(bl);
    }

    @Override
    public boolean isAssignedToSomeProject() {
        if (this.hasAssignments.getAssignments().size() > 0) {
            return true;
        }
        return this.globalWorkVector != null && this.globalWorkVector.size() != 0;
    }

    public Set<Integer> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public void setAuthorizedRoles(Set<Integer> set) {
        this.authorizedRoles = set;
    }

    public void filterRoles(List list, List list2) {
        if (this.authorizedRoles == null) {
            return;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        Object e = null;
        while (iterator2.hasNext()) {
            Object e2 = iterator.next();
            int n = (Integer)iterator2.next();
            if (n == 0) {
                e = e2;
            }
            if ((n != 0 || this.getAssignments().size() <= 0) && this.authorizedRoles.contains(n)) continue;
            iterator.remove();
        }
        if (list.size() == 0) {
            list.add(e);
        }
    }

    public int getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(int n) {
        this.defaultRole = n;
    }

    public int getLicense() {
        return this.license;
    }

    public void setLicense(int n) {
        this.license = n;
    }

    public int getLicenseOptions() {
        return this.licenseOptions;
    }

    public void setLicenseOptions(int n) {
        this.licenseOptions = n;
    }

    public boolean isInactiveLicense() {
        return this.license == 0;
    }

    public boolean isExternal() {
        return (this.licenseOptions & 2) == 2;
    }

    public boolean isAdministrator() {
        return (this.licenseOptions & 1) == 1;
    }

    @Override
    public AvailabilityTable getAvailabilityTable() {
        return this.availabilityTable;
    }

    public Object getServerMeta() {
        return this.serverMeta;
    }

    public void setServerMeta(Object object) {
        this.serverMeta = object;
    }
}

