/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.dependency;

import com.projity.association.Association;
import com.projity.association.InvalidAssociationException;
import com.projity.datatype.Duration;
import com.projity.datatype.DurationFormat;
import com.projity.document.Document;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.criticalpath.ScheduleWindow;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.DependencyType;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.task.BelongsToDocument;
import com.projity.pm.task.HasProject;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.server.data.DataObject;
import com.projity.strings.Messages;
import java.util.Date;

public class Dependency
implements Association,
BelongsToDocument,
DataObject {
    static final long serialVersionUID = 283794049292031L;
    private int dependencyType;
    private transient HasDependencies predecessor;
    private transient HasDependencies successor;
    private transient boolean disabled = false;
    private long lag;
    private transient long earlyDate;
    private transient long lateDate;
    public static final long NEEDS_CALCULATION = -1L;
    transient boolean newId = true;
    private transient boolean dirty;

    public static Dependency getInstance(HasDependencies hasDependencies, HasDependencies hasDependencies2) {
        return Dependency.getInstance(hasDependencies, hasDependencies2, 1, 0L);
    }

    public static Dependency getInstance(HasDependencies hasDependencies, HasDependencies hasDependencies2, int n, long l) {
        return new Dependency(hasDependencies, hasDependencies2, n, l);
    }

    private Dependency(HasDependencies hasDependencies, HasDependencies hasDependencies2, int n, long l) {
        this.predecessor = hasDependencies;
        this.successor = hasDependencies2;
        this.dependencyType = n;
        this.lag = l;
    }

    public void updateDependencyLists() {
        this.predecessor.getSuccessorList().add(this);
        this.successor.getPredecessorList().add(this);
    }

    public HasDependencies getPredecessor() {
        return this.predecessor;
    }

    public HasDependencies getSuccessor() {
        return this.successor;
    }

    public long getLag() {
        return this.lag;
    }

    public void setLag(long l) {
        this.lag = l;
    }

    public void copyPrincipalFieldsFrom(Association association) {
        this.lag = ((Dependency)association).lag;
        this.dependencyType = ((Dependency)association).dependencyType;
    }

    public final WorkCalendar getEffectiveWorkCalendar() {
        return this.predecessor.getHasCalendar().getEffectiveWorkCalendar();
    }

    public void setPredecessor(HasDependencies hasDependencies) {
        this.predecessor = hasDependencies;
    }

    public void setSuccessor(HasDependencies hasDependencies) {
        this.successor = hasDependencies;
    }

    public int getDependencyType() {
        return this.dependencyType;
    }

    public void setDependencyType(int n) throws InvalidAssociationException {
        if (((Task)this.getSuccessor()).isWbsParent() && (n == 0 || n == 2)) {
            throw new InvalidAssociationException(Messages.getString("Message.parentSuccessorCannotHaveFinishLink"));
        }
        this.dependencyType = n;
    }

    boolean isCircular() {
        return this.predecessor.dependsOn(this.successor);
    }

    boolean isLinkToParent() {
        return ((Task)this.successor).wbsDescendentOf((Task)this.predecessor);
    }

    boolean isLinkToChild() {
        return ((Task)this.predecessor).wbsDescendentOf((Task)this.successor);
    }

    public void testValid(boolean bl) throws InvalidAssociationException {
        if (this.isLinkToParent() || this.isLinkToChild()) {
            throw new InvalidAssociationException(Messages.getString("Message.cannotLinkToSummary"));
        }
        if (this.isCircular()) {
            throw new InvalidAssociationException(Messages.getString("Message.circularDependency"));
        }
        if (!bl && this.predecessor.getSuccessorList().findRight(this.successor) != null) {
            throw new InvalidAssociationException(Messages.getString("Message.cannotLinkTwice"));
        }
    }

    public Object getLeft() {
        return this.predecessor;
    }

    public Object getRight() {
        return this.successor;
    }

    public void doAddService(Object object) {
        DependencyService.getInstance().connect(this, object);
    }

    public void doRemoveService(Object object) {
        DependencyService.getInstance().remove(this, object, true);
    }

    public void doUpdateService(Object object) {
        DependencyService.getInstance().update(this, object);
    }

    public boolean isDefault() {
        return false;
    }

    public Document getDocument() {
        return ((BelongsToDocument)((Object)this.getSuccessor())).getDocument();
    }

    public boolean refersToDocument(Document document) {
        return ((Task)this.getSuccessor()).getMasterDocument() == document || ((Task)this.getPredecessor()).getMasterDocument() == document;
    }

    public void fireCreateEvent(Object object) {
        ((Task)this.getSuccessor()).getMasterDocument().getObjectEventManager().fireCreateEvent(object, this);
    }

    public void fireUpdateEvent(Object object) {
        ((Task)this.getSuccessor()).getMasterDocument().getObjectEventManager().fireUpdateEvent(object, this);
    }

    public void fireDeleteEvent(Object object) {
        ((Task)this.getSuccessor()).getMasterDocument().getObjectEventManager().fireDeleteEvent(object, this);
    }

    public boolean isExternal() {
        return ((Task)this.getSuccessor()).getProjectId() != ((Task)this.getPredecessor()).getProjectId();
    }

    public boolean isCrossProject() {
        return this.isExternal();
    }

    public String toString() {
        return "[predecessor]" + this.predecessor + " [successor]" + this.successor;
    }

    public String getPredecessorName() {
        return ((Task)this.predecessor).getName();
    }

    public String getSuccessorName() {
        return ((Task)this.successor).getName();
    }

    public String getQualifiedPredecessorName() {
        if (this.isExternal()) {
            return ((Task)this.predecessor).getTaskAndProjectName();
        }
        return this.predecessor.toString();
    }

    public String getQualifiedSuccessorName() {
        if (this.isExternal()) {
            return ((Task)this.successor).getTaskAndProjectName();
        }
        return this.successor.toString();
    }

    public long getPredecessorId() {
        return ((Task)this.predecessor).getUniqueId();
    }

    public long getSuccessorId() {
        return ((Task)this.successor).getUniqueId();
    }

    public long getPredecessorIdNumber() {
        return ((Task)this.predecessor).getId();
    }

    public long getSuccessorIdNumber() {
        return ((Task)this.successor).getId();
    }

    public String getName() {
        return null;
    }

    public void setName(String string) {
    }

    public long getUniqueId() {
        return 0L;
    }

    public void setUniqueId(long l) {
    }

    public String getUniqueIdString() {
        return this.getPredecessorId() + "." + this.getSuccessorId();
    }

    public boolean isNew() {
        return this.newId;
    }

    public void setNew(boolean bl) {
        this.newId = bl;
    }

    public long getLeadValue() {
        long l = this.getLag();
        if (Duration.isPercent(l)) {
            long l2 = Duration.millis(l);
            float f = Duration.getPercentAsDecimal(l2);
            if (Duration.isElapsed(l)) {
                l = (long)((float)((Task)this.getPredecessor()).getElapsedDuration() * f);
                l = Duration.setAsElapsed(l);
            } else {
                l = (long)((float)((Task)this.getPredecessor()).getDuration() * f);
            }
        }
        return l;
    }

    public HasDependencies getTask(boolean bl) {
        return bl ? this.predecessor : this.successor;
    }

    public long calcDependencyDate(boolean bl, long l, long l2, boolean bl2) {
        return bl ? this.calcForwardDependencyDate(l, l2, bl2) : this.calcReverseDependencyDate(l, l2, bl2);
    }

    public long calcForwardDependencyDate(long l, long l2, boolean bl) {
        if (this.disabled) {
            return this.earlyDate;
        }
        long l3 = 0L;
        boolean bl2 = !bl;
        switch (this.dependencyType) {
            case 1: {
                l3 = l2;
                break;
            }
            case 3: {
                l3 = l;
                break;
            }
            case 0: {
                l3 = ((ScheduleWindow)((Object)this.successor)).calcOffsetFrom(l2, l2, false, false, bl2);
                break;
            }
            case 2: {
                l3 = ((ScheduleWindow)((Object)this.successor)).calcOffsetFrom(l, l, false, false, bl2);
            }
        }
        this.earlyDate = this.getEffectiveWorkCalendar().add(l3, this.getLeadValue(), bl2);
        return this.earlyDate;
    }

    public long calcReverseDependencyDate(long l, long l2, boolean bl) {
        if (this.disabled) {
            return this.lateDate;
        }
        long l3 = 0L;
        boolean bl2 = !bl;
        switch (this.getDependencyType()) {
            case 1: {
                l3 = l2;
                break;
            }
            case 3: {
                l3 = ((ScheduleWindow)((Object)this.getPredecessor())).calcOffsetFrom(l2, l2, false, false, bl2);
                break;
            }
            case 0: {
                l3 = l;
                break;
            }
            case 2: {
                l3 = ((ScheduleWindow)((Object)this.getPredecessor())).calcOffsetFrom(l, l, false, false, bl2);
            }
        }
        this.lateDate = this.getEffectiveWorkCalendar().add(l3, this.getLeadValue(), bl2);
        return this.lateDate;
    }

    public long getDate(boolean bl) {
        return bl ? this.earlyDate : this.lateDate;
    }

    public void setDate(boolean bl, long l) {
        System.out.println(this + "setting date to " + new Date(l));
        if (bl) {
            this.earlyDate = l;
        } else {
            this.lateDate = l;
        }
    }

    public String htmlString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        stringBuffer.append(Messages.getString("Gantt.tooltip.link")).append(": ");
        stringBuffer.append(DependencyType.toLongString(this.getDependencyType())).append(" ");
        stringBuffer.append(DurationFormat.format(this.getLag())).append("<br>");
        stringBuffer.append(Messages.getString("Gantt.tooltip.from")).append(": ");
        stringBuffer.append(this.getQualifiedPredecessorName()).append("<br>");
        stringBuffer.append(Messages.getString("Gantt.tooltip.to")).append(": ");
        stringBuffer.append(this.getQualifiedSuccessorName()).append("<br>");
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        Project project;
        this.dirty = bl;
        if (bl && this.predecessor != null && (project = ((HasProject)((Object)this.predecessor)).getProject()) != null) {
            project.setGroupDirty(true);
        }
    }

    public Document getMasterDocument() {
        return ((Task)this.getSuccessor()).getMasterDocument();
    }

    public void replace(Object object, boolean bl) {
        if (bl) {
            this.setPredecessor((HasDependencies)object);
        } else {
            this.setSuccessor((HasDependencies)object);
        }
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public final void setDisabled(boolean bl) {
        this.disabled = bl;
    }
}

