/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration;

import com.projity.configuration.Dictionary;
import com.projity.field.InvalidFormulaException;
import com.projity.graphic.configuration.BarFormat;
import com.projity.graphic.configuration.BarStyles;
import com.projity.scripting.Formula;
import com.projity.scripting.FormulaFactory;
import com.projity.strings.Messages;
import org.apache.commons.collections.Predicate;

public class BarStyle
implements Predicate {
    public static final String FORMULA_PREFIX = "BarStyle";
    String name = null;
    String id = null;
    String formulaText = null;
    String formulaClass = null;
    String barFormatName = null;
    String type = null;
    String formatId = null;
    boolean link = false;
    boolean annotation = false;
    boolean calendar = false;
    boolean horizontalGrid = false;
    private BarFormat barFormat = null;
    private Formula formula = null;
    BarStyles belongsTo;
    boolean active = true;

    public boolean isHorizontalGrid() {
        return this.horizontalGrid;
    }

    public void setHorizontalGrid(boolean bl) {
        this.horizontalGrid = bl;
    }

    public boolean evaluate(Object object) {
        if (!this.active) {
            return false;
        }
        try {
            if (this.formula == null) {
                return true;
            }
            return (Boolean)this.formula.evaluate(object);
        }
        catch (InvalidFormulaException invalidFormulaException) {
            return false;
        }
    }

    public String getBarFormatName() {
        return this.barFormatName;
    }

    public void setFormatId(String string) {
        this.formatId = string;
        String string2 = Messages.getString(string);
        this.barFormat = (BarFormat)Dictionary.get("BarFormatCategory", string2);
    }

    public String getFormulaText() {
        return this.formulaText;
    }

    void build() {
        if (this.formulaText == null && this.formulaClass == null) {
            this.formulaClass = "com.projity.scripting.formulas.TrueFormula";
        }
        if (this.formulaClass != null) {
            this.formula = FormulaFactory.addNormal(this.formulaClass, this.name);
        } else if (this.formulaText != null) {
            this.formula = FormulaFactory.addScripted(FORMULA_PREFIX + this.belongsTo.getName(), this.name, this.type, this.formulaText);
        }
        String string = Messages.getString(this.formatId);
        this.barFormat = (BarFormat)Dictionary.get("BarFormatCategory", string);
    }

    public void setFormulaText(String string) {
        this.formulaText = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public BarFormat getBarFormat() {
        return this.barFormat;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean bl) {
        this.link = bl;
    }

    public boolean isAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(boolean bl) {
        this.annotation = bl;
    }

    public boolean isCalendar() {
        return this.calendar;
    }

    public void setCalendar(boolean bl) {
        this.calendar = bl;
    }

    public void setBelongsTo(BarStyles barStyles) {
        this.belongsTo = barStyles;
    }

    public String getFormulaClass() {
        return this.formulaClass;
    }

    public void setFormulaClass(String string) {
        this.formulaClass = string;
    }
}

