/**
* <h2> <span> Summary </span></h2>
* <p><b>Core Function</b>
* </p><p>Evaluates an argument to determine whether it is a finite number.
* </p>
* <h2> <span> Syntax </span></h2>
* <p><code>
* isFinite(<i>number</i>)
* </code>
* </p>
* <h2> <span> Parameters </span></h2>
* <dl><dt style="font-weight:bold"> <code>number</code></dt><dd> The number to evaluate.
* </dd></dl>
* <h2> <span> Description </span></h2>
* <p><code>isFinite</code> is a top-level function and is not associated with any object.
* </p><p>You can use this method to determine whether a number is a finite number. The <code>isFinite</code> method examines the number in its argument. If the argument is <code>NaN</code>, positive infinity or negative infinity, this method returns <code>false</code>, otherwise it returns <code>true</code>.
* </p>
* <h2> <span> Examples </span></h2>
* <h3> <span> Example: Using <code>isFinite</code> </span></h3>
* <p>You can check a client input to determine whether it is a finite number.
* </p>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">if (isFinite(ClientInput)) {
* / * take specific steps * /
* }
* </pre>
* <h2> <span> See also </span></h2>
* <p><a href="Number:NEGATIVE_INFINITY" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:NEGATIVE INFINITY">Number.NEGATIVE_INFINITY</a>,
* <a href="Number:POSITIVE_INFINITY" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:POSITIVE INFINITY">Number.POSITIVE_INFINITY</a>
* </p>
* 
* <ul style="list-style-type:none;font-size:0.9em;text-align:center">
* <li id="f-copyright">Content is available under <a href="http://developer.mozilla.org/en/docs/MDC:Copyrights" shape="rect" title="MDC:Copyrights">these licenses</a>.</li>	  		<li id="f-about"><a href="http://developer.mozilla.org/en/docs/MDC:About" shape="rect" title="MDC:About">About MDC</a></li>	  				</ul>
*/
var IsFinite = {
  // This is just a stub for a builtin native JavaScript object.
};
/**
* <h2> <span> Summary </span></h2>
* <p><b>Core Function</b>
* </p><p>Evaluates an argument to determine whether it is a finite number.
* </p>
* <h2> <span> Syntax </span></h2>
* <p><code>
* isFinite(<i>number</i>)
* </code>
* </p>
* <h2> <span> Parameters </span></h2>
* <dl><dt style="font-weight:bold"> <code>number</code></dt><dd> The number to evaluate.
* </dd></dl>
* <h2> <span> Description </span></h2>
* <p><code>isFinite</code> is a top-level function and is not associated with any object.
* </p><p>You can use this method to determine whether a number is a finite number. The <code>isFinite</code> method examines the number in its argument. If the argument is <code>NaN</code>, positive infinity or negative infinity, this method returns <code>false</code>, otherwise it returns <code>true</code>.
* </p>
* <h2> <span> Examples </span></h2>
* <h3> <span> Example: Using <code>isFinite</code> </span></h3>
* <p>You can check a client input to determine whether it is a finite number.
* </p>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">if (isFinite(ClientInput)) {
* / * take specific steps * /
* }
* </pre>
* <h2> <span> See also </span></h2>
* <p><a href="Number:NEGATIVE_INFINITY" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:NEGATIVE INFINITY">Number.NEGATIVE_INFINITY</a>,
* <a href="Number:POSITIVE_INFINITY" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:POSITIVE INFINITY">Number.POSITIVE_INFINITY</a>
* </p>
* 
* <ul style="list-style-type:none;font-size:0.9em;text-align:center">
* <li id="f-copyright">Content is available under <a href="http://developer.mozilla.org/en/docs/MDC:Copyrights" shape="rect" title="MDC:Copyrights">these licenses</a>.</li>	  		<li id="f-about"><a href="http://developer.mozilla.org/en/docs/MDC:About" shape="rect" title="MDC:About">About MDC</a></li>	  				</ul>
*/
function isFinite(number) {};

