/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.netbeans.microedition.databinding.core;

import org.netbeans.microedition.databinding.DataBinder;
import org.netbeans.microedition.databinding.el.ELContext;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;
import org.netbeans.microedition.databinding.IndexableDataSet;

import java.util.Vector;

/**
 * @author David Kaspar
 */
public class DataBindingELContext extends ELContext {

    public static final DataBindingELContext CONTEXT = new DataBindingELContext ();

    public Object getValue (Object base, Object property) {
        //System.out.println("--- base="+base+", property="+property);
        if (base != null) {
            if (property instanceof String) {
                Object value = null;
                try {
                   value = ((DataSet) base).getValue((String)property);
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
                //System.out.println("returned value="+value);
                return value;
            } else if (property instanceof Long  &&  base instanceof IndexableDataSet) {
                IndexableDataSet ids = (IndexableDataSet)base;
                try {
                    return ids.getRow ((int)((Long)property).longValue());
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
                return null;
            } else if (property instanceof Integer  &&  base instanceof IndexableDataSet) {
                IndexableDataSet ids = (IndexableDataSet)base;
                try {
                    return ids.getRow (((Integer)property).intValue());
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
                return null;
            }
        }
        System.out.println("Cannot resolve getValue: base=" + base + ", property="+property+", class="+property.getClass());
        return null;
    }

    public boolean isReadOnly (Object base, Object property) {
        //System.out.println("base="+base+", property="+property);
        if (base != null) {
            if (property instanceof String) {
                boolean value = false;
                try {
                   value = ((DataSet) base).isReadOnly ((String)property);
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
                //System.out.println("returned value="+value);
                return value;
            } else if (property instanceof Long  &&  base instanceof IndexableDataSet) {
                IndexableDataSet ids = (IndexableDataSet)base;
                return ids.isReadOnly();
            } else if (property instanceof Integer  &&  base instanceof IndexableDataSet) {
                IndexableDataSet ids = (IndexableDataSet)base;
                return ids.isReadOnly();
            }
        }
        System.out.println("Cannot resolve isReadOnly: base=" + base + ", property="+property+", class="+property.getClass());
        return true;
    }

    public void setValue (Object base, Object property, Object value) {
        //System.out.println("base="+base+", property="+property);
        if (base != null) {
            if (property instanceof String) {
                try {
                   ((DataSet) base).setValue ((String)property, value);
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
            } else if (property instanceof Long  &&  base instanceof IndexableDataSet) {
                try {
                   ((IndexableDataSet) base).setRow ((int) ((Long) property).longValue(), value);
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
            } else if (property instanceof Integer  &&  base instanceof IndexableDataSet) {
                try {
                   ((IndexableDataSet) base).setRow (((Integer) property).intValue(), value);
                } catch (DataBindingException e) {
                    e.printStackTrace ();  // TODO
                }
            }
        }
        System.out.println("Cannot resolve setValue: base=" + base + ", property="+property+", class="+property.getClass());
    }

    public Object resolveVariable (String variable) {
        //System.out.println("--- variable" + variable);
        DataSet dataSet = DataBinder.getRegisteredDataSet (variable);
        if (dataSet == null)
            System.out.println ("Cannot find registered root dataset for variable: " + variable);    
        return dataSet;
    }

    public Object invokeFunction (String qualifiedName, Vector arguments) {
//        if (dataSource.getFunctionSet() != null) {
//            return dataSource.getFunctionSet().invokeFunction(qualifiedName,arguments);
//        } else {
//            return FunctionSet.FUNCTION_SET_NOT_AVAILABLE;
//        }
        return null;
    }

    public Object createPointer (Object base, Object property) {
        return new BindingPair ((DataSet) base, property);
    }

} 