/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.util.Map;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.form.I18nServiceImpl;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.openide.loaders.DataObject;

public class FormI18nString
extends JavaI18nString
implements I18nValue {
    String bundleName;
    Object allData;

    public FormI18nString(I18nSupport i18nSupport) {
        super(i18nSupport);
    }

    public FormI18nString(JavaI18nString javaI18nString) {
        this(FormI18nString.createNewSupport(javaI18nString.getSupport()), javaI18nString.getKey(), javaI18nString.getValue(), javaI18nString.getComment(), javaI18nString.getArguments(), javaI18nString.getReplaceFormat(), javaI18nString instanceof FormI18nString ? ((FormI18nString)javaI18nString).bundleName : null);
        ((JavaResourceHolder)this.support.getResourceHolder()).setLocalization(((JavaResourceHolder)javaI18nString.getSupport().getResourceHolder()).getLocalization());
    }

    FormI18nString(DataObject dataObject) {
        super(new FormI18nSupport.Factory().createI18nSupport(dataObject));
        boolean bl = I18nServiceImpl.isNbBundleAvailable(dataObject.getPrimaryFile());
        if (I18nUtil.getDefaultReplaceFormat((!bl ? 1 : 0) != 0).equals(this.getReplaceFormat())) {
            this.setReplaceFormat(I18nUtil.getDefaultReplaceFormat((boolean)bl));
        }
    }

    private FormI18nString(I18nSupport i18nSupport, String string, String string2, String string3, String[] stringArray, String string4, String string5) {
        super(i18nSupport);
        this.key = string;
        this.value = string2;
        this.comment = string3;
        this.arguments = stringArray;
        this.replaceFormat = string4;
        this.bundleName = string5;
    }

    public Object copy(FormProperty formProperty) {
        FormI18nString formI18nString;
        FormModel formModel = formProperty.getPropertyContext().getFormModel();
        if (formModel == null) {
            return this.getValue();
        }
        FormDataObject formDataObject = FormEditor.getFormDataObject((FormModel)formModel);
        if (formDataObject == null) {
            return this.getValue();
        }
        if (formModel.getSettings().isI18nAutoMode()) {
            formI18nString = new FormI18nString(FormI18nString.createNewSupport((DataObject)formDataObject, null, ((FormI18nSupport)this.support).getIdentifier()), "#auto", (String)this.getValue(), this.getComment(), this.getArguments(), this.getReplaceFormat(), this.bundleName);
            JavaResourceHolder javaResourceHolder = (JavaResourceHolder)this.support.getResourceHolder();
            formI18nString.allData = javaResourceHolder.getAllData(this.getKey());
        } else {
            I18nSupport i18nSupport = FormI18nString.createNewSupport((DataObject)formDataObject, this.support.getResourceHolder().getResource(), ((FormI18nSupport)this.support).getIdentifier());
            formI18nString = new FormI18nString(i18nSupport, this.getKey(), (String)this.getValue(), this.getComment(), this.getArguments(), this.getReplaceFormat(), this.bundleName);
            if (formDataObject != this.support.getSourceDataObject()) {
                ResourceHolder resourceHolder = i18nSupport.getResourceHolder();
                formI18nString.value = resourceHolder.getValueForKey(this.getKey());
                formI18nString.comment = resourceHolder.getCommentForKey(this.getKey());
            }
        }
        return formI18nString;
    }

    public String toString() {
        return this.getValue();
    }

    private static I18nSupport createNewSupport(I18nSupport i18nSupport) {
        return FormI18nString.createNewSupport(i18nSupport.getSourceDataObject(), i18nSupport.getResourceHolder().getResource(), i18nSupport instanceof JavaI18nSupport ? ((JavaI18nSupport)i18nSupport).getIdentifier() : null);
    }

    private static I18nSupport createNewSupport(DataObject dataObject, DataObject dataObject2, String string) {
        FormI18nSupport formI18nSupport = (FormI18nSupport)new FormI18nSupport.Factory().createI18nSupport(dataObject);
        formI18nSupport.setIdentifier(string);
        if (dataObject2 != null) {
            formI18nSupport.getResourceHolder().setResource(dataObject2);
        }
        return formI18nSupport;
    }

    public Object getDesignValue() {
        Object object = this.getValue();
        if (object == null) {
            return FormDesignValue.IGNORED_VALUE;
        }
        return object;
    }

    public Object getDesignValue(Object object) {
        return null;
    }

    public String getDescription() {
        return "<" + this.getKey() + ">";
    }

    protected void fillFormatMap(Map<String, String> map) {
        super.fillFormatMap(map);
        if (this.getSupport().getResourceHolder().getResource() == null && this.bundleName != null) {
            String string = this.bundleName;
            if (string.endsWith(".properties")) {
                string = string.substring(0, string.length() - 11);
            }
            map.put("bundleNameSlashes", string);
            map.put("bundleNameDots", string.replace('/', '.'));
        }
    }
}

