/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.lang.model.element.TypeElement;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MainClassChooser
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ChangeListener changeListener;
    private String dialogSubtitle = null;
    private Collection<ElementHandle<TypeElement>> possibleMainClasses;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;

    public MainClassChooser(FileObject[] fileObjectArray) {
        this(fileObjectArray, null);
    }

    public MainClassChooser(FileObject[] fileObjectArray, String string) {
        this.dialogSubtitle = string;
        this.initComponents();
        this.jMainClassList.setCellRenderer(new MainClassRenderer());
        this.initClassesView(fileObjectArray);
    }

    private void initClassesView(final FileObject[] fileObjectArray) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(listSelectionEvent));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(mouseEvent));
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MainClassChooser.this.possibleMainClasses = SourceUtils.getMainClasses((FileObject[])fileObjectArray);
                if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                        }
                    });
                } else {
                    final ElementHandle[] elementHandleArray = MainClassChooser.this.possibleMainClasses.toArray(new ElementHandle[MainClassChooser.this.possibleMainClasses.size()]);
                    Arrays.sort(elementHandleArray, new MainClassComparator());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(elementHandleArray);
                            MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                        }
                    });
                }
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private boolean isValidMainClassName(Object object) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(object);
    }

    public String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            return ((ElementHandle)this.jMainClassList.getSelectedValue()).getQualifiedName();
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListener = null;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        return Utils.hasMainMethod(fileObject);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(380, 300));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_MainClassChooser"));
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(MainClassChooser.class).getString("CTL_AvaialableMainClasses"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_jMainClassList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private static class MainClassComparator
    implements Comparator<ElementHandle> {
        private MainClassComparator() {
        }

        @Override
        public int compare(ElementHandle elementHandle, ElementHandle elementHandle2) {
            return elementHandle.getQualifiedName().compareTo(elementHandle2.getQualifiedName());
        }
    }

    private static final class MainClassRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MainClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object instanceof String) {
                string = (String)object;
            }
            string = object instanceof ElementHandle ? ((ElementHandle)object).getQualifiedName() : object.toString();
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

