/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class MainClassUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    private static RequestProcessor RP = new RequestProcessor();
    private final Project project;
    private final PropertyEvaluator eval;
    private final UpdateHelper helper;
    private final ClassPath sourcePath;
    private final String mainClassPropName;
    private FileObject current;
    private FileChangeListener listener;

    public MainClassUpdater(Project project, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ClassPath classPath, String string) {
        assert (project != null);
        assert (propertyEvaluator != null);
        assert (updateHelper != null);
        assert (classPath != null);
        assert (string != null);
        this.project = project;
        this.eval = propertyEvaluator;
        this.helper = updateHelper;
        this.sourcePath = classPath;
        this.mainClassPropName = string;
        this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.addFileChangeListener();
    }

    public synchronized void unregister() {
        if (this.current != null && this.listener != null) {
            this.current.removeFileChangeListener(this.listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.mainClassPropName.equals(propertyChangeEvent.getPropertyName())) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    MainClassUpdater.this.addFileChangeListener();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject;
        if (!this.project.getProjectDirectory().isValid()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            fileObject = this.current;
        }
        if (fileRenameEvent.getFile() == fileObject) {
            object = new Runnable(){

                @Override
                public void run() {
                    try {
                        Object object;
                        String string = (String)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return MainClassUpdater.this.eval.getProperty(MainClassUpdater.this.mainClassPropName);
                            }
                        });
                        Collection collection = SourceUtils.getMainClasses((FileObject)fileObject);
                        String string2 = null;
                        if (!collection.isEmpty()) {
                            object = (ElementHandle)collection.iterator().next();
                            string2 = object.getQualifiedName();
                        }
                        if (string2 != null && !string2.equals(string) && MainClassUpdater.this.helper.requestUpdate()) {
                            object = string2;
                            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>((String)object){
                                final /* synthetic */ String val$newMainClassFinal;
                                {
                                    this.val$newMainClassFinal = string;
                                }

                                public Void run() throws Exception {
                                    EditableProperties editableProperties = MainClassUpdater.this.helper.getProperties("nbproject/project.properties");
                                    editableProperties.put(MainClassUpdater.this.mainClassPropName, this.val$newMainClassFinal);
                                    MainClassUpdater.this.helper.putProperties("nbproject/project.properties", editableProperties);
                                    ProjectManager.getDefault().saveProject(MainClassUpdater.this.project);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (MutexException mutexException) {
                        Exceptions.printStackTrace((Throwable)mutexException);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                object.run();
            } else {
                SwingUtilities.invokeLater((Runnable)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileChangeListener() {
        Object object = this;
        synchronized (object) {
            if (this.current != null && this.listener != null) {
                this.current.removeFileChangeListener(this.listener);
                this.current = null;
                this.listener = null;
            }
        }
        object = this.eval.getProperty(this.mainClassPropName);
        if (object != null) {
            try {
                FileObject[] fileObjectArray = this.sourcePath.getRoots();
                if (fileObjectArray.length > 0) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/boot");
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/compile");
                    ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath2, (ClassPath)this.sourcePath);
                    JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                    javaSource.runWhenScanFinished((Task)new Task<CompilationController>((String)object, classpathInfo){
                        final /* synthetic */ String val$mainClassName;
                        final /* synthetic */ ClasspathInfo val$cpInfo;
                        {
                            this.val$mainClassName = string;
                            this.val$cpInfo = classpathInfo;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(CompilationController compilationController) throws Exception {
                            TypeElement typeElement = compilationController.getElements().getTypeElement(this.val$mainClassName);
                            if (typeElement != null) {
                                MainClassUpdater mainClassUpdater = MainClassUpdater.this;
                                synchronized (mainClassUpdater) {
                                    MainClassUpdater.this.current = SourceUtils.getFile((Element)typeElement, (ClasspathInfo)this.val$cpInfo);
                                    MainClassUpdater.this.listener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)MainClassUpdater.this, (Object)MainClassUpdater.this.current);
                                    if (MainClassUpdater.this.current != null && MainClassUpdater.this.sourcePath.contains(MainClassUpdater.this.current)) {
                                        MainClassUpdater.this.current.addFileChangeListener(MainClassUpdater.this.listener);
                                    }
                                }
                            }
                        }
                    }, true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

