/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ConnectPanel
extends JPanel {
    private ConnectController controller;
    private JTextField hostField;
    private JLabel hostLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField timeoutField;
    private JLabel timeoutLabel;

    public ConnectPanel() {
        this.initComponents();
        this.hostField.setText("localhost");
        this.portField.setText("7000");
        this.timeoutField.setText("15");
        this.controller = new ConnectController();
    }

    ConnectController getController() {
        return this.controller;
    }

    private boolean check() {
        try {
            this.getPort();
        }
        catch (NumberFormatException _) {
            Util.showWarning(NbBundle.getMessage(ConnectPanel.class, (String)"ConnectPanel.InvalidPort"));
            return false;
        }
        return true;
    }

    private String getHost() {
        return this.hostField.getText().trim();
    }

    private int getPort() {
        return Integer.parseInt(this.portField.getText().trim());
    }

    private int getTimeout() {
        try {
            return Integer.parseInt(this.timeoutField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            return 15;
        }
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutField = new JTextField();
        this.hostLabel.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"ConnectPanel.hostLabel.text"));
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"ConnectPanel.portLabel.text"));
        this.timeoutLabel.setLabelFor(this.timeoutField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"ConnectPanel.timeoutLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.hostLabel).add((Component)this.portLabel).add((Component)this.timeoutLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.portField, -1, 361, Short.MAX_VALUE).add((Component)this.hostField, -1, 361, Short.MAX_VALUE).add((Component)this.timeoutField, -1, 361, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.hostField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.portLabel).add((Component)this.portField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeoutLabel).add((Component)this.timeoutField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    final class ConnectController
    implements Controller {
        ConnectController() {
        }

        public boolean ok() {
            final RubyDebuggerImplementation debugger = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
            if (!ConnectPanel.this.check()) {
                return false;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    debugger.attach(ConnectPanel.this.getHost(), ConnectPanel.this.getPort(), ConnectPanel.this.getTimeout());
                }
            }, "Ruby Debugger Attach").start();
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

